/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.widgets.timegraph.dialogs;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.progress.WorkbenchJob;

public class FilteredCheckboxTree
extends FilteredTree
implements ICheckable {
    protected Set<Object> fCheckedObjects = new HashSet<Object>();
    private CheckboxTreeViewer fCheckboxTreeViewer;

    @Deprecated
    public FilteredCheckboxTree(Composite parent, int treeStyle, PatternFilter filter, boolean useNewLook) {
        this(parent, treeStyle, filter, useNewLook, false);
    }

    public FilteredCheckboxTree(Composite parent, int treeStyle, PatternFilter filter, boolean useNewLook, boolean useFastHashLookup) {
        super(parent, treeStyle, filter, useNewLook);
        TreeViewer viewer = this.getViewer();
        if (viewer != null) {
            viewer.setUseHashlookup(useFastHashLookup);
        }
    }

    protected TreeViewer doCreateTreeViewer(Composite parentComposite, int style) {
        this.fCheckboxTreeViewer = new CheckboxTreeViewer(parentComposite, style);
        this.fCheckboxTreeViewer.setUseHashlookup(true);
        this.fCheckboxTreeViewer.addCheckStateListener(event -> {
            if (event.getChecked()) {
                this.fCheckedObjects.add(event.getElement());
            } else {
                this.fCheckedObjects.remove(event.getElement());
            }
        });
        return this.fCheckboxTreeViewer;
    }

    protected WorkbenchJob doCreateRefreshJob() {
        final WorkbenchJob job = super.doCreateRefreshJob();
        return new WorkbenchJob("Refresh Filter"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (FilteredCheckboxTree.this.fCheckboxTreeViewer.getTree().isDisposed()) {
                    return Status.CANCEL_STATUS;
                }
                HashSet<Object> expandedElements = new HashSet<Object>(Arrays.asList(FilteredCheckboxTree.this.fCheckboxTreeViewer.getExpandedElements()));
                job.runInUIThread(monitor);
                expandedElements.addAll(Arrays.asList(FilteredCheckboxTree.this.fCheckboxTreeViewer.getExpandedElements()));
                FilteredCheckboxTree.this.fCheckboxTreeViewer.getTree().setRedraw(false);
                FilteredCheckboxTree.this.fCheckboxTreeViewer.expandAll();
                FilteredCheckboxTree.this.fCheckboxTreeViewer.setCheckedElements(FilteredCheckboxTree.this.getCheckedElements());
                ISelection selection = FilteredCheckboxTree.this.fCheckboxTreeViewer.getSelection();
                FilteredCheckboxTree.this.fCheckboxTreeViewer.collapseAll();
                FilteredCheckboxTree.this.fCheckboxTreeViewer.getTree().setRedraw(true);
                FilteredCheckboxTree.this.fCheckboxTreeViewer.setExpandedElements(expandedElements.toArray());
                FilteredCheckboxTree.this.fCheckboxTreeViewer.setSelection(selection);
                return Status.OK_STATUS;
            }
        };
    }

    public boolean getChecked(Object element) {
        return this.fCheckedObjects.contains(element);
    }

    public boolean setChecked(Object element, boolean state) {
        boolean checkable = this.fCheckboxTreeViewer.setChecked(element, state);
        if (!state) {
            this.fCheckedObjects.remove(element);
        } else if (checkable) {
            this.fCheckedObjects.add(element);
        }
        return checkable;
    }

    public void addCheckStateListener(ICheckStateListener listener) {
        this.fCheckboxTreeViewer.addCheckStateListener(listener);
    }

    public void removeCheckStateListener(ICheckStateListener listener) {
        this.fCheckboxTreeViewer.addCheckStateListener(listener);
    }

    public CheckboxTreeViewer getCheckboxTreeViewer() {
        return this.fCheckboxTreeViewer;
    }

    public Object[] getCheckedElements() {
        return this.fCheckedObjects.toArray();
    }

    public void setCheckedElements(Object[] elements) {
        this.fCheckedObjects = new HashSet<Object>();
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            this.fCheckedObjects.add(element);
            ++n2;
        }
        this.fCheckboxTreeViewer.setCheckedElements(elements);
    }

    public boolean setSubtreeChecked(Object element, boolean state) {
        this.checkSubtree(element, state);
        return this.fCheckboxTreeViewer.setSubtreeChecked(element, state);
    }

    protected void checkSubtree(Object element, boolean state) {
        if (!state || this.fCheckboxTreeViewer.testFindItem(element) != null) {
            if (state) {
                this.fCheckedObjects.add(element);
            } else {
                this.fCheckedObjects.remove(element);
            }
            Object[] objectArray = ((ITreeContentProvider)this.fCheckboxTreeViewer.getContentProvider()).getChildren(element);
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                this.checkSubtree(o, state);
                ++n2;
            }
        }
    }
}

