/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.views.uml2sd;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.DrawableToolTip;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.ITimeCompressionListener;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.ScrollView;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.core.AsyncMessage;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.core.BaseMessage;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.core.ExecutionOccurrence;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.core.Frame;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.core.GraphNode;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.core.ITimeRange;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.core.Lifeline;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.core.Metrics;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.core.SDTimeEvent;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.drawings.IColor;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.drawings.impl.ColorImpl;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.preferences.SDViewPref;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.util.TimeEventComparator;

public class TimeCompressionBar
extends ScrollView
implements DisposeListener {
    private static final int BASE_RED_VALUE = 255;
    private static final int BASE_GREEN_BLUE_VALUE = 225;
    private static final int COLOR_STEP = 25;
    private static final int NUMBER_STEPS = 10;
    private List<ITimeCompressionListener> fListenerList = null;
    private Frame fFrame = null;
    private List<SDTimeEvent> fNodeList = null;
    private ITmfTimestamp fMinTime = TmfTimestamp.fromSeconds((long)0L);
    private ITmfTimestamp fMaxTime = TmfTimestamp.fromSeconds((long)0L);
    private float fZoomValue = 1.0f;
    private DrawableToolTip fTooltip = null;
    private ColorImpl[] fColors;
    private Accessible fAccessible = null;
    private int fFocusedWidget = -1;
    private Lifeline fLifeline = null;
    private int fLifelineStart = 0;
    private int fLifelineNumEvents = 0;
    private IColor fLifelineColor = null;
    private int fNextNodeY = 0;
    private int fPrevNodeY = 0;

    public TimeCompressionBar(Composite parent, int s) {
        super(parent, s | 0x40000, false);
        this.setVScrollBarMode(2);
        this.setHScrollBarMode(2);
        this.fListenerList = new ArrayList<ITimeCompressionListener>();
        this.fColors = new ColorImpl[10];
        int greenBlue = 225;
        int step = 25;
        int i = 0;
        while (i < this.fColors.length) {
            this.fColors[i] = new ColorImpl(Display.getDefault(), 255, greenBlue, greenBlue);
            greenBlue -= 25;
            ++i;
        }
        super.addDisposeListener((DisposeListener)this);
        this.fAccessible = this.getViewControl().getAccessible();
        this.fAccessible.addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID == 0) {
                    if (TimeCompressionBar.this.fTooltip != null) {
                        e.result = TimeCompressionBar.this.fTooltip.getAccessibleText();
                    }
                } else if (e.childID == 1) {
                    TimeCompressionBar.this.createFakeTooltip();
                    e.result = TimeCompressionBar.this.fTooltip.getAccessibleText();
                }
            }
        });
        this.fAccessible.addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getFocus(AccessibleControlEvent e) {
                e.childID = TimeCompressionBar.this.fFocusedWidget == -1 ? -1 : TimeCompressionBar.this.fFocusedWidget;
            }

            public void getRole(AccessibleControlEvent e) {
                switch (e.childID) {
                    case -1: {
                        e.detail = 10;
                        break;
                    }
                    case 0: {
                        e.detail = 13;
                        break;
                    }
                    case 1: {
                        e.detail = 41;
                        break;
                    }
                }
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = 0x100000;
                if (e.childID == -1) {
                    e.detail |= 4;
                } else {
                    e.detail |= 0x200000;
                    if (e.childID == TimeCompressionBar.this.fFocusedWidget) {
                        e.detail |= 0x16;
                    }
                }
            }
        });
        this.getViewControl().addTraverseListener((TraverseListener)new LocalTraverseListener());
        this.addTraverseListener(new LocalTraverseListener());
        this.getViewControl().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                TimeCompressionBar.this.redraw();
            }

            public void focusLost(FocusEvent e) {
                TimeCompressionBar.this.redraw();
            }
        });
    }

    void setFocus(int newFocusShape) {
        this.fFocusedWidget = newFocusShape;
        if (this.fFocusedWidget == -1) {
            this.getViewControl().getAccessible().setFocus(-1);
        } else {
            this.getViewControl().getAccessible().setFocus(this.fFocusedWidget);
        }
    }

    public void setFrame(Frame theFrame) {
        this.fFrame = theFrame;
        this.fMinTime = this.fFrame.getMinTime();
        this.fMaxTime = this.fFrame.getMaxTime();
    }

    @Override
    protected void drawContents(GC gc, int clipx, int clipy, int clipw, int cliph) {
        BaseMessage m;
        int firstVisible;
        if (this.fFrame == null) {
            return;
        }
        this.fNodeList = new ArrayList<SDTimeEvent>();
        int messageArraysStep = 1;
        if ((float)(Metrics.getMessageFontHeigth() + 20) * this.fZoomValue < 2.0f) {
            messageArraysStep = Math.round(1.0f + 1.0f / ((float)(Metrics.getMessageFontHeigth() + 20) * this.fZoomValue));
        }
        if ((firstVisible = this.fFrame.getFirstVisibleSyncMessage()) > 0) {
            --firstVisible;
        }
        int i = firstVisible;
        while (i < this.fFrame.syncMessageCount()) {
            m = this.fFrame.getSyncMessage(i);
            if (this.addMessageIfVisible(m)) break;
            i += messageArraysStep;
        }
        firstVisible = this.fFrame.getFirstVisibleSyncMessageReturn();
        if (firstVisible > 0) {
            --firstVisible;
        }
        i = firstVisible;
        while (i < this.fFrame.syncMessageReturnCount()) {
            m = this.fFrame.getSyncMessageReturn(i);
            if (this.addMessageIfVisible(m)) break;
            i += messageArraysStep;
        }
        firstVisible = this.fFrame.getFirstVisibleAsyncMessage();
        if (firstVisible > 0) {
            --firstVisible;
        }
        i = firstVisible;
        while (i < this.fFrame.asyncMessageCount()) {
            m = this.fFrame.getAsyncMessage(i);
            if (this.addMessageIfVisible(m)) break;
            i += messageArraysStep;
        }
        firstVisible = this.fFrame.getFirstVisibleAsyncMessageReturn();
        if (firstVisible > 0) {
            --firstVisible;
        }
        i = firstVisible;
        while (i < this.fFrame.asyncMessageReturnCount()) {
            m = this.fFrame.getAsyncMessageReturn(i);
            if (this.addMessageIfVisible(m)) break;
            i += messageArraysStep;
        }
        List<SDTimeEvent> executionOccurrencesWithTime = this.fFrame.getExecutionOccurrencesWithTime();
        if (executionOccurrencesWithTime != null) {
            this.fNodeList.addAll(executionOccurrencesWithTime);
        }
        SDTimeEvent[] temp = this.fNodeList.toArray(new SDTimeEvent[this.fNodeList.size()]);
        Arrays.sort(temp, new TimeEventComparator());
        this.fNodeList = Arrays.asList(temp);
        Image dbuffer = new Image((Device)this.getDisplay(), this.getClientArea().width, this.getClientArea().height);
        GC gcim = new GC((Drawable)dbuffer);
        int i2 = 0;
        while (i2 < this.fNodeList.size() - 1) {
            block21: {
                int colIndex;
                SDTimeEvent m2;
                SDTimeEvent m1;
                block20: {
                    m1 = this.fNodeList.get(i2);
                    m2 = this.fNodeList.get(i2 + 1);
                    if (!SDViewPref.getInstance().excludeExternalTime() || !(m1.getGraphNode() instanceof BaseMessage) || !(m2.getGraphNode() instanceof BaseMessage)) break block20;
                    BaseMessage mes1 = (BaseMessage)((Object)m1.getGraphNode());
                    BaseMessage mes2 = (BaseMessage)((Object)m2.getGraphNode());
                    if (mes2.getStartLifeline() == null || mes1.getEndLifeline() == null) break block21;
                }
                this.fMinTime = this.fFrame.getMinTime();
                this.fMaxTime = this.fFrame.getMaxTime();
                ITmfTimestamp minMaxdelta = this.fMaxTime.getDelta(this.fMinTime);
                double gr = (double)minMaxdelta.getValue() / 10.0;
                ITmfTimestamp delta = m2.getTime().getDelta(m1.getTime()).getDelta(this.fMinTime);
                long absDelta = Math.abs(delta.getValue());
                ColorImpl color = gr != 0.0 ? ((colIndex = Math.round((float)((double)absDelta / gr))) < this.fColors.length && colIndex > 0 ? this.fColors[colIndex - 1] : (colIndex <= 0 ? this.fColors[0] : this.fColors[this.fColors.length - 1])) : this.fColors[0];
                if (color.getColor() instanceof Color) {
                    gcim.setBackground((Color)color.getColor());
                }
                PairOfYs poy = TimeCompressionBar.adjustHeights(m1, m2);
                int y1 = poy.getY1();
                int y2 = poy.getY2();
                gcim.fillRectangle(this.contentsToViewX(0), this.contentsToViewY(Math.round((float)y1 * this.fZoomValue)), 10, Math.round((float)(y2 - y1) * this.fZoomValue) + 1);
                if (messageArraysStep == 1) {
                    Color backupColor = gcim.getForeground();
                    gcim.setForeground(Display.getDefault().getSystemColor(1));
                    gcim.drawRectangle(this.contentsToViewX(0), this.contentsToViewY(Math.round((float)y1 * this.fZoomValue)), 9, Math.round((float)(y2 - y1) * this.fZoomValue));
                    gcim.setForeground(backupColor);
                }
            }
            ++i2;
        }
        if (this.getViewControl().isFocusControl() || this.isFocusControl()) {
            gcim.drawFocus(this.contentsToViewX(0), this.contentsToViewY(Math.round((float)this.fPrevNodeY * this.fZoomValue)), this.contentsToViewX(10), Math.round((float)(this.fNextNodeY - this.fPrevNodeY) * this.fZoomValue));
        }
        try {
            gc.drawImage(dbuffer, 0, 0, this.getClientArea().width, this.getClientArea().height, 0, 0, this.getClientArea().width, this.getClientArea().height);
        }
        catch (Exception e) {
            Activator.getDefault().logError("Error drawing image", e);
        }
        gcim.dispose();
        dbuffer.dispose();
        gc.dispose();
    }

    private boolean addMessageIfVisible(BaseMessage m) {
        ITimeRange timeRange;
        if (m instanceof ITimeRange && (timeRange = (ITimeRange)((Object)m)).hasTimeInfo()) {
            SDTimeEvent t = new SDTimeEvent(timeRange.getStartTime(), m.getStartOccurrence(), timeRange);
            this.fNodeList.add(t);
            if (m instanceof AsyncMessage) {
                t = new SDTimeEvent(timeRange.getEndTime(), m.getEndOccurrence(), timeRange);
                this.fNodeList.add(t);
            }
            return this.isNotVisible(m);
        }
        return false;
    }

    private boolean isNotVisible(BaseMessage m) {
        return (float)m.getY() * this.fZoomValue > (float)(this.getContentsY() + this.getVisibleHeight());
    }

    private static int addHeightIfAsynchronousMessage(SDTimeEvent timeEvent, int yPos) {
        AsyncMessage as;
        if (timeEvent.getGraphNode() instanceof AsyncMessage && (as = (AsyncMessage)timeEvent.getGraphNode()).getEndTime() == timeEvent.getTime()) {
            return yPos + as.getHeight();
        }
        return yPos;
    }

    private static int addHeight(SDTimeEvent timeEvent, int yPos) {
        ExecutionOccurrence eo = (ExecutionOccurrence)timeEvent.getGraphNode();
        if (timeEvent.getEvent() == eo.getEndOccurrence()) {
            return yPos + eo.getHeight();
        }
        return yPos;
    }

    private static int addHeightIfExecutionOccurence(SDTimeEvent timeWidget, int yPos) {
        if (timeWidget.getGraphNode() instanceof ExecutionOccurrence) {
            ExecutionOccurrence eo2 = (ExecutionOccurrence)timeWidget.getGraphNode();
            if (timeWidget.getEvent() == eo2.getEndOccurrence()) {
                return yPos + eo2.getHeight();
            }
        }
        return yPos;
    }

    protected boolean checkFocusOnChilds(Control children) {
        if (children instanceof Composite) {
            Control[] child = ((Composite)children).getChildren();
            int i = 0;
            while (i < child.length) {
                if (child[i].isFocusControl()) {
                    return true;
                }
                this.checkFocusOnChilds(child[i]);
                ++i;
            }
        }
        return false;
    }

    public boolean isFocusControl() {
        Control[] child = this.getChildren();
        int i = 0;
        while (i < child.length) {
            if (child[i].isFocusControl()) {
                return true;
            }
            this.checkFocusOnChilds(child[i]);
            ++i;
        }
        return false;
    }

    @Override
    protected void contentsMouseMoveEvent(MouseEvent event) {
        if (this.fTooltip != null) {
            this.fTooltip.hideToolTip();
        }
        super.contentsMouseMoveEvent(event);
        if (!this.isFocusControl() || this.getViewControl().isFocusControl()) {
            Control[] child = this.getParent().getChildren();
            int i = 0;
            while (i < child.length) {
                if (child[i].isFocusControl()) break;
                ++i;
            }
        }
        this.setFocus(-1);
    }

    @Override
    protected void contentsMouseHover(MouseEvent e) {
        if (this.fTooltip == null) {
            this.fTooltip = new DrawableToolTip(this);
        }
        if (this.fFrame != null) {
            this.setFocus(0);
            int i = 0;
            while (i < this.fNodeList.size() - 1) {
                SDTimeEvent m2;
                SDTimeEvent m1 = this.fNodeList.get(i);
                if (!TimeCompressionBar.skipIfLifelineIsNull(m1, m2 = this.fNodeList.get(i + 1))) {
                    PairOfYs poy = TimeCompressionBar.adjustHeights(m1, m2);
                    int m1Y = Math.round((float)poy.getY1() * this.fZoomValue);
                    int m2Y = Math.round((float)poy.getY2() * this.fZoomValue);
                    if (m1Y < e.y && m2Y >= e.y) {
                        ITmfTimestamp delta = m2.getTime().getDelta(m1.getTime());
                        this.fTooltip.showToolTip(delta, this.fMinTime, this.fMaxTime);
                    }
                }
                ++i;
            }
        }
        this.setFocus(0);
    }

    @Override
    protected void contentsMouseExit(MouseEvent e) {
        if (this.fTooltip != null) {
            this.fTooltip.hideToolTip();
        }
    }

    @Override
    protected void contentsMouseUpEvent(MouseEvent event) {
        this.selectTimeDelta(event.y, 0);
        this.setFocus();
        super.contentsMouseUpEvent(event);
    }

    public void highlightRegion(BaseMessage mes1, BaseMessage mes2) {
        AsyncMessage as;
        BaseMessage localMes1 = mes1;
        BaseMessage localMes2 = mes2;
        if (this.fFrame == null) {
            return;
        }
        if (!(localMes1 instanceof ITimeRange)) {
            return;
        }
        if (!(localMes2 instanceof ITimeRange)) {
            return;
        }
        ITimeRange t1 = (ITimeRange)((Object)localMes1);
        ITimeRange t2 = (ITimeRange)((Object)localMes2);
        ITmfTimestamp time1 = t1.getStartTime();
        ITmfTimestamp time2 = t2.getStartTime();
        int event1 = localMes1.getEventOccurrence();
        int event2 = localMes2.getEventOccurrence();
        if (localMes1 instanceof AsyncMessage) {
            as = (AsyncMessage)localMes1;
            time1 = as.getEndTime();
            event1 = as.getEndOccurrence();
        }
        if (localMes2 instanceof AsyncMessage) {
            as = (AsyncMessage)localMes2;
            if (as.getEndOccurrence() > as.getStartOccurrence()) {
                time1 = as.getEndTime();
                event1 = as.getEndOccurrence();
            } else {
                time1 = as.getStartTime();
                event1 = as.getStartOccurrence();
            }
        }
        if (event1 > event2) {
            AsyncMessage as2;
            BaseMessage tempMes = localMes2;
            localMes2 = localMes1;
            localMes1 = tempMes;
            t1 = (ITimeRange)((Object)localMes1);
            t2 = (ITimeRange)((Object)localMes2);
            time1 = t1.getStartTime();
            time2 = t2.getStartTime();
            event1 = localMes1.getEventOccurrence();
            event2 = localMes2.getEventOccurrence();
            if (localMes1 instanceof AsyncMessage) {
                as2 = (AsyncMessage)localMes1;
                time1 = as2.getEndTime();
                event1 = as2.getEndOccurrence();
            }
            if (localMes2 instanceof AsyncMessage) {
                as2 = (AsyncMessage)localMes2;
                if (as2.getEndOccurrence() > as2.getStartOccurrence()) {
                    time1 = as2.getEndTime();
                    event1 = as2.getEndOccurrence();
                } else {
                    time1 = as2.getStartTime();
                    event1 = as2.getStartOccurrence();
                }
            }
        }
        ITmfTimestamp minMaxdelta = this.fMaxTime.getDelta(this.fMinTime);
        double gr = (double)minMaxdelta.getValue() / 10.0;
        ITmfTimestamp delta = time2.getDelta(time1).getDelta(this.fMinTime);
        long absDelta = Math.abs(delta.getValue());
        int colIndex = 0;
        if (gr != 0.0) {
            colIndex = Math.round((float)((double)absDelta / gr));
            if (colIndex >= this.fColors.length) {
                colIndex = this.fColors.length - 1;
            } else if (colIndex < 0) {
                colIndex = 0;
            }
        } else {
            colIndex = 0;
        }
        int j = 0;
        while (j < this.fListenerList.size()) {
            ITimeCompressionListener list = this.fListenerList.get(j);
            if (localMes1.getEndLifeline() != null) {
                list.deltaSelected(localMes1.getEndLifeline(), event1, event2 - event1, this.fColors[colIndex]);
            } else if (localMes2.getStartLifeline() != null) {
                list.deltaSelected(localMes2.getStartLifeline(), event1, event2 - event1, this.fColors[colIndex]);
            } else {
                list.deltaSelected(localMes1.getStartLifeline(), event1, event2 - event1, this.fColors[colIndex]);
            }
            ++j;
        }
    }

    public void highlightRegionSync(BaseMessage mes1, BaseMessage mes2) {
        this.getDisplay().syncExec(() -> this.highlightRegion(mes1, mes2));
    }

    @Override
    public void scrollBy(int x, int y) {
    }

    public void setZoom(float value) {
        this.fZoomValue = value;
        this.redraw();
    }

    public void addTimeCompressionListener(ITimeCompressionListener listener) {
        if (!this.fListenerList.contains(listener)) {
            this.fListenerList.add(listener);
        }
    }

    public void removeSelectionChangedListener(ITimeCompressionListener listener) {
        this.fListenerList.remove(listener);
    }

    public void widgetDisposed(DisposeEvent e) {
        if (this.fTooltip != null) {
            this.fTooltip.dispose();
        }
        super.removeDisposeListener((DisposeListener)this);
        int i = 0;
        while (i < this.fColors.length) {
            this.fColors[i].dispose();
            ++i;
        }
    }

    @Override
    protected void keyPressedEvent(KeyEvent event) {
        int i;
        if (this.fTooltip != null) {
            this.fTooltip.hideToolTip();
        }
        if (!this.isFocusControl() || this.getViewControl().isFocusControl()) {
            Control[] child = this.getParent().getChildren();
            i = 0;
            while (i < child.length) {
                if (child[i].isFocusControl()) break;
                ++i;
            }
        }
        this.setFocus(-1);
        boolean top = false;
        if (this.fNextNodeY == 0) {
            top = true;
        }
        if (this.fFrame != null && this.fNextNodeY == 0) {
            i = 0;
            while (i < this.fNodeList.size() - 1 && i < 1) {
                SDTimeEvent m2;
                SDTimeEvent m1 = this.fNodeList.get(i);
                if (!TimeCompressionBar.skipIfLifelineIsNull(m1, m2 = this.fNodeList.get(i + 1))) {
                    PairOfYs poy = TimeCompressionBar.adjustHeights(m1, m2);
                    this.fPrevNodeY = Math.round((float)poy.getY1() * this.fZoomValue);
                    this.fNextNodeY = Math.round((float)poy.getY2() * this.fZoomValue);
                }
                ++i;
            }
        }
        if (this.fLifeline != null) {
            int j = 0;
            while (j < this.fListenerList.size()) {
                ITimeCompressionListener list = this.fListenerList.get(j);
                list.deltaSelected(this.fLifeline, this.fLifelineStart, this.fLifelineNumEvents, this.fLifelineColor);
                ++j;
            }
        }
        if (event.keyCode == 0x1000002) {
            if (!top) {
                this.selectTimeDelta(this.fNextNodeY + 1, 1);
            } else {
                this.selectTimeDelta(this.fPrevNodeY + 1, 1);
            }
            this.setFocus(1);
        } else if (event.keyCode == 0x1000001) {
            this.selectTimeDelta(this.fPrevNodeY - 1, 2);
            this.setFocus(1);
        } else if (event.keyCode == 0x1000004) {
            this.selectTimeDelta(this.fPrevNodeY, 1);
            this.setFocus(1);
        }
        super.keyPressedEvent(event);
    }

    protected void selectTimeDelta(int dy, int direction) {
        SDTimeEvent lastM1 = null;
        SDTimeEvent lastM2 = null;
        int lastY1 = 0;
        int lastY2 = 0;
        boolean done = false;
        if (this.fFrame != null) {
            int i = 0;
            while (i < this.fNodeList.size() - 1) {
                SDTimeEvent m2;
                SDTimeEvent m1 = this.fNodeList.get(i);
                if (!TimeCompressionBar.skipIfLifelineIsNull(m1, m2 = this.fNodeList.get(i + 1))) {
                    PairOfYs poy = TimeCompressionBar.adjustHeights(m1, m2);
                    int m1Y = Math.round((float)poy.getY1() * this.fZoomValue);
                    int m2Y = Math.round((float)poy.getY2() * this.fZoomValue);
                    if (m1Y < dy && m2Y > dy || !done && m2Y > dy && direction == 1 && lastM1 != null || !done && m1Y > dy && direction == 2 && lastM1 != null) {
                        if (m1Y > dy && direction == 2) {
                            m1 = lastM1;
                            m2 = lastM2;
                            m1Y = lastY1;
                            m2Y = lastY2;
                        }
                        done = true;
                        this.fPrevNodeY = m1Y;
                        this.fNextNodeY = m2Y;
                        ITmfTimestamp minMaxdelta = this.fMaxTime.getDelta(this.fMinTime);
                        double gr = (double)minMaxdelta.getValue() / 10.0;
                        ITmfTimestamp delta = m2.getTime().getDelta(m1.getTime()).getDelta(this.fMinTime);
                        long absDelta = Math.abs(delta.getValue());
                        int colIndex = 0;
                        if (gr != 0.0) {
                            colIndex = Math.round((float)((double)absDelta / gr));
                            if (colIndex >= this.fColors.length) {
                                colIndex = this.fColors.length - 1;
                            } else if (colIndex < 0) {
                                colIndex = 0;
                            }
                        } else {
                            colIndex = 0;
                        }
                        if (m1.getGraphNode() instanceof BaseMessage) {
                            BaseMessage mes1 = (BaseMessage)((Object)m1.getGraphNode());
                            if (mes1.getEndLifeline() != null) {
                                this.fLifeline = mes1.getEndLifeline();
                                this.fLifelineStart = m1.getEvent();
                                this.fLifelineNumEvents = m2.getEvent() - m1.getEvent();
                                this.fLifelineColor = this.fColors[colIndex];
                            } else if (m2.getGraphNode() instanceof BaseMessage && ((BaseMessage)((Object)m2.getGraphNode())).getStartLifeline() != null) {
                                this.fLifeline = ((BaseMessage)((Object)m2.getGraphNode())).getStartLifeline();
                                this.fLifelineStart = m1.getEvent();
                                this.fLifelineNumEvents = m2.getEvent() - m1.getEvent();
                                this.fLifelineColor = this.fColors[colIndex];
                            } else {
                                this.fLifeline = mes1.getStartLifeline();
                                this.fLifelineStart = m1.getEvent();
                                this.fLifelineNumEvents = m2.getEvent() - m1.getEvent();
                                this.fLifelineColor = this.fColors[colIndex];
                            }
                        } else if (m1.getGraphNode() instanceof ExecutionOccurrence) {
                            ExecutionOccurrence eo;
                            if (m2.getGraphNode() instanceof ExecutionOccurrence) {
                                eo = (ExecutionOccurrence)m2.getGraphNode();
                                this.fLifeline = eo.getLifeline();
                                this.fLifelineStart = m1.getEvent();
                                this.fLifelineNumEvents = m2.getEvent() - m1.getEvent();
                                this.fLifelineColor = this.fColors[colIndex];
                            } else {
                                eo = (ExecutionOccurrence)m1.getGraphNode();
                                this.fLifeline = eo.getLifeline();
                                this.fLifelineStart = m1.getEvent();
                                this.fLifelineNumEvents = m2.getEvent() - m1.getEvent();
                                this.fLifelineColor = this.fColors[colIndex];
                            }
                        }
                        int j = 0;
                        while (j < this.fListenerList.size()) {
                            ITimeCompressionListener list = this.fListenerList.get(j);
                            list.deltaSelected(this.fLifeline, this.fLifelineStart, this.fLifelineNumEvents, this.fLifelineColor);
                            ++j;
                        }
                        break;
                    }
                    lastM1 = m1;
                    lastM2 = m2;
                    lastY1 = m1Y;
                    lastY2 = m2Y;
                }
                ++i;
            }
        }
    }

    protected void createFakeTooltip() {
        if (this.fTooltip == null) {
            this.fTooltip = new DrawableToolTip(this);
        }
        if (this.fFrame != null) {
            this.setFocus(0);
            int i = 0;
            while (i < this.fNodeList.size() - 1) {
                SDTimeEvent m2;
                SDTimeEvent m1 = this.fNodeList.get(i);
                if (!TimeCompressionBar.skipIfLifelineIsNull(m1, m2 = this.fNodeList.get(i + 1))) {
                    PairOfYs poy = TimeCompressionBar.adjustHeights(m1, m2);
                    int m1Y = Math.round((float)poy.getY1() * this.fZoomValue);
                    int m2Y = Math.round((float)poy.getY2() * this.fZoomValue);
                    if (m1Y < this.fPrevNodeY + 1 && m2Y >= this.fPrevNodeY + 1) {
                        ITmfTimestamp delta = m2.getTime().getDelta(m1.getTime());
                        this.fTooltip.showToolTip(delta, this.fMinTime, this.fMaxTime);
                        this.fTooltip.hideToolTip();
                    }
                }
                ++i;
            }
        }
    }

    private static PairOfYs adjustHeights(SDTimeEvent m1, SDTimeEvent m2) {
        int y1 = ((GraphNode)((Object)m1.getGraphNode())).getY();
        int y2 = ((GraphNode)((Object)m2.getGraphNode())).getY();
        y1 = TimeCompressionBar.addHeightIfAsynchronousMessage(m1, y1);
        y2 = TimeCompressionBar.addHeightIfAsynchronousMessage(m2, y2);
        if (m1.getGraphNode() instanceof ExecutionOccurrence) {
            y1 = TimeCompressionBar.addHeight(m1, y1);
            y2 = TimeCompressionBar.addHeightIfExecutionOccurence(m2, y2);
        }
        return new PairOfYs(y1, y2);
    }

    private static boolean skipIfLifelineIsNull(SDTimeEvent m1, SDTimeEvent m2) {
        if (SDViewPref.getInstance().excludeExternalTime() && m1.getGraphNode() instanceof BaseMessage && m2.getGraphNode() instanceof BaseMessage) {
            BaseMessage mes1 = (BaseMessage)((Object)m1.getGraphNode());
            BaseMessage mes2 = (BaseMessage)((Object)m2.getGraphNode());
            if (mes2.getStartLifeline() == null || mes1.getEndLifeline() == null) {
                return true;
            }
        }
        return false;
    }

    protected static class LocalTraverseListener
    implements TraverseListener {
        protected LocalTraverseListener() {
        }

        public void keyTraversed(TraverseEvent e) {
            if (e.detail == 16 || e.detail == 8) {
                e.doit = true;
            }
        }
    }

    private static class PairOfYs {
        private final int fY1;
        private final int fY2;

        public PairOfYs(int y1, int y2) {
            this.fY1 = y1;
            this.fY2 = y2;
        }

        public int getY1() {
            return this.fY1;
        }

        public int getY2() {
            return this.fY2;
        }
    }
}

