/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.viewers.xychart;

import com.google.common.annotations.VisibleForTesting;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swtchart.Chart;
import org.eclipse.swtchart.IAxis;
import org.eclipse.swtchart.ICustomPaintListener;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.ISeriesSet;
import org.eclipse.swtchart.ITitle;
import org.eclipse.swtchart.LineStyle;
import org.eclipse.swtchart.Range;
import org.eclipse.tracecompass.internal.tmf.ui.viewers.xychart.TmfXYChartTimeAdapter;
import org.eclipse.tracecompass.internal.tmf.ui.viewers.xychart.TmfXyUiUtils;
import org.eclipse.tracecompass.internal.tmf.ui.viewers.xychart.XYAxis;
import org.eclipse.tracecompass.internal.tmf.ui.views.ITmfTimeNavigationProvider;
import org.eclipse.tracecompass.internal.tmf.ui.views.ITmfTimeZoomProvider;
import org.eclipse.tracecompass.internal.tmf.ui.views.ITmfZoomToSelectionProvider;
import org.eclipse.tracecompass.tmf.core.signal.TmfSelectionRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfTimestampFormatUpdateSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfWindowRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimePreferences;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceContext;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.viewers.IImageSave;
import org.eclipse.tracecompass.tmf.ui.viewers.TmfTimeViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.xychart.AxisRange;
import org.eclipse.tracecompass.tmf.ui.viewers.xychart.ITmfChartTimeProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.xychart.TmfBaseProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.xychart.TmfMouseDragProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.xychart.TmfMouseDragZoomProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.xychart.TmfMouseSelectionProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.xychart.TmfMouseWheelZoomProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.xychart.TmfSimpleTooltipProvider;
import org.eclipse.tracecompass.tmf.ui.views.FormatTimeUtils;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.TimeGraphColorScheme;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.TimeGraphScale;

public abstract class TmfXYChartViewer
extends TmfTimeViewer
implements ITmfChartTimeProvider,
IImageSave,
IAdaptable {
    private static final int DEFAULT_SCALE_HEIGHT = 22;
    private Composite fCommonComposite;
    private @NonNull TimeGraphColorScheme fColorScheme = new TimeGraphColorScheme();
    private Chart fSwtChart;
    private TimeGraphScale fTimeScaleCtrl;
    private @Nullable FormatTimeUtils.TimeFormat fTimeFormat = null;
    private TmfBaseProvider fMouseSelectionProvider;
    private TmfBaseProvider fMouseDragZoomProvider;
    private TmfBaseProvider fMouseWheelZoomProvider;
    private TmfBaseProvider fToolTipProvider;
    private TmfBaseProvider fMouseDragProvider;
    private boolean fSendTimeAlignSignals = false;
    private final TmfXYChartTimeAdapter fDataProvider;
    private AxisRange fFixedYRange = null;
    private IStatusLineManager fStatusLineManager;

    public TmfXYChartViewer(Composite parent, String title, String xLabel, String yLabel) {
        Composite commonComposite;
        this.fCommonComposite = commonComposite = new Composite(parent, parent.getStyle()){

            public void redraw() {
                TmfXYChartViewer.this.fSwtChart.redraw();
                TmfXYChartViewer.this.fTimeScaleCtrl.redraw();
            }
        };
        commonComposite.addDisposeListener(e -> this.fColorScheme.dispose());
        commonComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().spacing(0, 0).margins(0, 0).create());
        commonComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.fSwtChart = new Chart(commonComposite, 0){

            public void addFocusListener(FocusListener listener) {
                TmfXYChartViewer.this.fSwtChart.getPlotArea().getControl().addFocusListener(listener);
            }

            public void removeFocusListener(FocusListener listener) {
                TmfXYChartViewer.this.fSwtChart.getPlotArea().getControl().removeFocusListener(listener);
            }

            public boolean setFocus() {
                return TmfXYChartViewer.this.fSwtChart.getPlotArea().getControl().setFocus();
            }

            public boolean forceFocus() {
                return TmfXYChartViewer.this.fSwtChart.getPlotArea().getControl().forceFocus();
            }
        };
        this.fSwtChart.getAxisSet().getXAxis(0).getGrid().setStyle(LineStyle.NONE);
        this.fSwtChart.getPlotArea().addCustomPaintListener(new ICustomPaintListener(){

            public void paintControl(PaintEvent e) {
                TmfXYChartViewer.this.drawGridLines(e.gc);
            }

            public boolean drawBehindSeries() {
                return true;
            }
        });
        this.fSwtChart.addPaintListener(e -> {
            Rectangle bounds = this.fSwtChart.getPlotArea().getControl().getBounds();
            int y = this.fTimeScaleCtrl.getLocation().y;
            this.fTimeScaleCtrl.setBounds(bounds.x, y, bounds.width, 22);
            this.fTimeScaleCtrl.redraw();
        });
        this.fTimeScaleCtrl = new TimeGraphScale(commonComposite, this.fColorScheme, 1024);
        Color backgroundColor = this.fColorScheme.getColor(38);
        this.fSwtChart.setBackground(backgroundColor);
        commonComposite.setBackground(backgroundColor);
        backgroundColor = this.fColorScheme.getColor(32);
        this.fSwtChart.getPlotArea().setBackground(backgroundColor);
        this.fSwtChart.setForeground(this.fColorScheme.getColor(39));
        this.fTimeScaleCtrl.setLayoutData(new GridData(4, -1, true, false));
        this.fTimeScaleCtrl.setHeight(22);
        ((Composite)this.fSwtChart.getPlotArea()).addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ((Composite)TmfXYChartViewer.this.fSwtChart.getPlotArea()).setFocus();
            }
        });
        IAxis xAxis = this.fSwtChart.getAxisSet().getXAxis(0);
        IAxis yAxis = this.fSwtChart.getAxisSet().getYAxis(0);
        this.initTitle(title, this.fSwtChart.getTitle());
        this.initTitle(null, this.fSwtChart.getTitle());
        xAxis.getTick().setVisible(false);
        yAxis.getTick().setForeground(this.fColorScheme.getColor(39));
        this.initTitle(yLabel, yAxis.getTitle());
        this.fMouseSelectionProvider = new TmfMouseSelectionProvider(this);
        this.fMouseDragZoomProvider = new TmfMouseDragZoomProvider(this);
        this.fMouseWheelZoomProvider = new TmfMouseWheelZoomProvider(this);
        this.fToolTipProvider = new TmfSimpleTooltipProvider(this);
        this.fMouseDragProvider = new TmfMouseDragProvider(this);
        this.fSwtChart.addDisposeListener(e -> this.internalDispose());
        this.fDataProvider = new TmfXYChartTimeAdapter(this);
        this.fTimeScaleCtrl.setTimeProvider(this.fDataProvider);
        this.updateTimeFormat();
    }

    private void initTitle(String label, ITitle titleCtrl) {
        titleCtrl.setForeground(this.fColorScheme.getColor(39));
        if (label == null) {
            titleCtrl.setVisible(false);
        } else {
            titleCtrl.setText(label);
        }
    }

    protected void setSwtChart(Chart chart) {
        this.fSwtChart = chart;
    }

    public Chart getSwtChart() {
        return this.fSwtChart;
    }

    public void setTimeAxisVisible(boolean visible) {
        GridData gridData = (GridData)this.fTimeScaleCtrl.getLayoutData();
        gridData.exclude = !visible;
        this.fTimeScaleCtrl.setVisible(visible);
        this.fCommonComposite.requestLayout();
    }

    public void setSelectionProvider(TmfBaseProvider provider) {
        if (this.fMouseSelectionProvider != null) {
            this.fMouseSelectionProvider.dispose();
        }
        this.fMouseSelectionProvider = provider;
    }

    public void setMouseDragZoomProvider(TmfBaseProvider provider) {
        if (this.fMouseDragZoomProvider != null) {
            this.fMouseDragZoomProvider.dispose();
        }
        this.fMouseDragZoomProvider = provider;
    }

    public void setMouseWheelZoomProvider(TmfBaseProvider provider) {
        if (this.fMouseWheelZoomProvider != null) {
            this.fMouseWheelZoomProvider.dispose();
        }
        this.fMouseWheelZoomProvider = provider;
    }

    public void setTooltipProvider(TmfBaseProvider provider) {
        if (this.fToolTipProvider != null) {
            this.fToolTipProvider.dispose();
        }
        this.fToolTipProvider = provider;
    }

    public void setMouseDrageProvider(TmfBaseProvider provider) {
        if (this.fMouseDragProvider != null) {
            this.fMouseDragProvider.dispose();
        }
        this.fMouseDragProvider = provider;
    }

    @Override
    public long getTimeOffset() {
        return this.getWindowStartTime() - 1L;
    }

    @Override
    public Control getControl() {
        return this.fSwtChart;
    }

    @Override
    public void refresh() {
        this.fSwtChart.redraw();
    }

    public void dispose() {
        if (!this.fSwtChart.isDisposed()) {
            this.fSwtChart.dispose();
        }
    }

    private void internalDispose() {
        super.dispose();
        if (this.fMouseSelectionProvider != null) {
            this.fMouseSelectionProvider.dispose();
        }
        if (this.fMouseDragZoomProvider != null) {
            this.fMouseDragZoomProvider.dispose();
        }
        if (this.fMouseWheelZoomProvider != null) {
            this.fMouseWheelZoomProvider.dispose();
        }
        if (this.fToolTipProvider != null) {
            this.fToolTipProvider.dispose();
        }
        if (this.fMouseDragProvider != null) {
            this.fMouseDragProvider.dispose();
        }
    }

    @Override
    public void loadTrace(ITmfTrace trace) {
        super.loadTrace(trace);
        this.clearContent();
        this.updateContent();
    }

    @Override
    public void reset() {
        super.reset();
        this.setStartTime(0L);
        this.setEndTime(0L);
        this.clearContent();
    }

    protected abstract void updateContent();

    @VisibleForTesting
    public boolean isDirty() {
        if (this.getTrace() == null) {
            return false;
        }
        TmfTraceContext ctx = TmfTraceManager.getInstance().getCurrentTraceContext();
        long startTime = ctx.getWindowRange().getStartTime().toNanos();
        long endTime = ctx.getWindowRange().getEndTime().toNanos();
        return this.getWindowStartTime() != startTime || this.getWindowEndTime() != endTime;
    }

    private void drawGridLines(GC gc) {
        Point size = this.fSwtChart.getPlotArea().getSize();
        Color foreground = this.fSwtChart.getAxisSet().getXAxis(0).getGrid().getForeground();
        gc.setForeground(foreground);
        gc.setAlpha(foreground.getAlpha());
        gc.setLineStyle(3);
        for (int x : this.fTimeScaleCtrl.getTickList()) {
            gc.drawLine(x, 0, x, size.y);
        }
        gc.setAlpha(255);
    }

    protected void setTimeFormat(FormatTimeUtils.TimeFormat timeFormat) {
        this.fTimeFormat = timeFormat;
        if (this.fSwtChart != null) {
            this.updateTimeFormat();
            this.fSwtChart.getAxisSet().adjustRange();
            this.fSwtChart.redraw();
        }
    }

    @Override
    @TmfSignalHandler
    public void selectionRangeUpdated(TmfSelectionRangeUpdatedSignal signal) {
        super.selectionRangeUpdated(signal);
        if (signal != null && signal.getSource() != this && this.getTrace() != null && this.fMouseSelectionProvider != null) {
            this.fMouseSelectionProvider.refresh();
        }
    }

    @Override
    @TmfSignalHandler
    public void windowRangeUpdated(TmfWindowRangeUpdatedSignal signal) {
        super.windowRangeUpdated(signal);
        this.updateContent();
    }

    @TmfSignalHandler
    public void timestampFormatUpdated(TmfTimestampFormatUpdateSignal signal) {
        this.updateTimeFormat();
        this.fSwtChart.getAxisSet().adjustRange();
        this.fSwtChart.redraw();
    }

    public void setFixedYRange(@Nullable AxisRange yRange) {
        this.fFixedYRange = yRange;
        this.updateContent();
    }

    public @Nullable AxisRange getFixedYRange() {
        return this.fFixedYRange;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == ITmfTimeNavigationProvider.class) {
            return (T)this.getTimeNavigator();
        }
        if (adapter == ITmfTimeZoomProvider.class) {
            return (T)this.getTimeZoomProvider();
        }
        if (adapter == ITmfZoomToSelectionProvider.class) {
            return (T)this.getZoomToSelectionProvider();
        }
        return null;
    }

    protected void clearContent() {
        if (!this.fSwtChart.isDisposed()) {
            ISeriesSet set = this.fSwtChart.getSeriesSet();
            ISeries[] series = set.getSeries();
            int i = 0;
            while (i < series.length) {
                set.deleteSeries(series[i].getId());
                ++i;
            }
            IAxis[] iAxisArray = this.fSwtChart.getAxisSet().getAxes();
            int n = iAxisArray.length;
            int n2 = 0;
            while (n2 < n) {
                IAxis axis = iAxisArray[n2];
                axis.setRange(new Range(0.0, 1.0));
                ++n2;
            }
            this.fSwtChart.redraw();
        }
    }

    protected static Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public int getPointAreaOffset() {
        int pixelCoordinate = 0;
        IAxis[] xAxes = this.getSwtChart().getAxisSet().getXAxes();
        if (xAxes.length > 0) {
            IAxis axis = xAxes[0];
            pixelCoordinate = axis.getPixelCoordinate(axis.getRange().lower);
        }
        return this.getSwtChart().toControl((Point)((Composite)this.fSwtChart.getPlotArea()).toDisplay((int)pixelCoordinate, (int)0)).x;
    }

    public int getPointAreaWidth() {
        IAxis[] xAxes = this.getSwtChart().getAxisSet().getXAxes();
        if (xAxes.length > 0) {
            IAxis axis = xAxes[0];
            int x1 = this.getPointAreaOffset();
            int x2 = axis.getPixelCoordinate(axis.getRange().upper);
            x2 = this.getSwtChart().toControl((Point)((Composite)this.fSwtChart.getPlotArea()).toDisplay((int)x2, (int)0)).x;
            int width = x2 - x1;
            return width;
        }
        return this.getSwtChart().getPlotArea().getSize().x;
    }

    public void setSendTimeAlignSignals(boolean sendTimeAlignSignals) {
        this.fSendTimeAlignSignals = sendTimeAlignSignals;
    }

    public boolean isSendTimeAlignSignals() {
        return this.fSendTimeAlignSignals;
    }

    @Override
    public void saveImage(String filename, int format) {
        this.getSwtChart().save(filename, format);
    }

    public void setStatusLineManager(IStatusLineManager statusLineManager) {
        if (this.fStatusLineManager != null && statusLineManager == null) {
            this.fStatusLineManager.setMessage(null);
        }
        this.fStatusLineManager = statusLineManager;
    }

    public void updateStatusLine(long startTime, long endTime, long cursorTime) {
        FormatTimeUtils.TimeFormat timeFormat = this.fTimeScaleCtrl.getTimeProvider().getTimeFormat().convert();
        boolean isCalendar = timeFormat == FormatTimeUtils.TimeFormat.CALENDAR;
        StringBuilder message = new StringBuilder();
        String spaces = "     ";
        if (cursorTime >= 0L) {
            message.append("T: ");
            if (isCalendar) {
                message.append(String.valueOf(FormatTimeUtils.formatDate(cursorTime + this.getTimeOffset())) + ' ');
            }
            message.append(FormatTimeUtils.formatTime(cursorTime + this.getTimeOffset(), timeFormat, FormatTimeUtils.Resolution.NANOSEC));
            message.append(spaces);
        }
        if (startTime == endTime) {
            message.append("T1: ");
            if (isCalendar) {
                message.append(String.valueOf(FormatTimeUtils.formatDate(startTime + this.getTimeOffset())) + ' ');
            }
            message.append(FormatTimeUtils.formatTime(startTime + this.getTimeOffset(), timeFormat, FormatTimeUtils.Resolution.NANOSEC));
        } else {
            message.append("T1: ");
            if (isCalendar) {
                message.append(String.valueOf(FormatTimeUtils.formatDate(startTime + this.getTimeOffset())) + ' ');
            }
            message.append(FormatTimeUtils.formatTime(startTime + this.getTimeOffset(), timeFormat, FormatTimeUtils.Resolution.NANOSEC));
            message.append(spaces);
            message.append("T2: ");
            if (isCalendar) {
                message.append(String.valueOf(FormatTimeUtils.formatDate(endTime + this.getTimeOffset())) + ' ');
            }
            message.append(FormatTimeUtils.formatTime(endTime + this.getTimeOffset(), timeFormat, FormatTimeUtils.Resolution.NANOSEC));
            message.append(spaces);
            message.append("\u0394: " + FormatTimeUtils.formatDelta(endTime - startTime, timeFormat, FormatTimeUtils.Resolution.NANOSEC));
        }
        this.fStatusLineManager.setMessage(message.toString());
    }

    private ITmfTimeZoomProvider getTimeZoomProvider() {
        return (zoomIn, useMousePosition) -> {
            Chart chart = this.getSwtChart();
            if (chart == null) {
                return;
            }
            XYAxis xAxis = XYAxis.create(chart.getAxisSet().getXAxis(0));
            Point cursorDisplayLocation = TmfXYChartViewer.getDisplay().getCursorLocation();
            Point cursorControlLocation = ((Composite)this.fSwtChart.getPlotArea()).toControl(cursorDisplayLocation);
            Point cursorParentLocation = ((Composite)this.fSwtChart.getPlotArea()).getParent().toControl(cursorDisplayLocation);
            Rectangle controlBounds = this.getSwtChart().getPlotArea().getControl().getBounds();
            if (!controlBounds.contains(cursorParentLocation.x, controlBounds.y)) {
                return;
            }
            if (useMousePosition) {
                TmfXyUiUtils.zoom(this, xAxis, zoomIn, cursorControlLocation.x);
            } else {
                TmfXyUiUtils.zoom(this, xAxis, zoomIn);
            }
        };
    }

    private ITmfTimeNavigationProvider getTimeNavigator() {
        return left -> {
            Chart chart = this.getSwtChart();
            if (chart != null) {
                TmfXyUiUtils.horizontalScroll(this, XYAxis.create(chart.getAxisSet().getXAxis(0)), left);
            }
        };
    }

    private ITmfZoomToSelectionProvider getZoomToSelectionProvider() {
        return () -> {
            long selEnd;
            long selBegin = this.getSelectionBeginTime();
            if (selBegin != (selEnd = this.getSelectionEndTime())) {
                this.updateWindow(selBegin, selEnd);
            }
        };
    }

    private void updateTimeFormat() {
        if (this.fTimeFormat == null) {
            String datime = (String)TmfTimePreferences.getPreferenceMap().get("org.eclipse.linuxtools.tmf.core.prefs.time.format.datime");
            if ("TTT".equals(datime)) {
                this.fDataProvider.setTimeFormat(FormatTimeUtils.TimeFormat.RELATIVE);
            } else {
                this.fDataProvider.setTimeFormat(FormatTimeUtils.TimeFormat.CALENDAR);
            }
        } else {
            this.fDataProvider.setTimeFormat(this.fTimeFormat);
        }
    }
}

