/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.project.model;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestampFormat;
import org.eclipse.tracecompass.tmf.ui.project.model.ITmfProjectModelElement;
import org.eclipse.tracecompass.tmf.ui.project.model.ITmfStyledProjectModelElement;
import org.eclipse.tracecompass.tmf.ui.project.model.Messages;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.tracecompass.tmf.ui.project.model.UpdateTraceBoundsJob;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonLabelProvider;

public class TmfNavigatorLabelProvider
implements ICommonLabelProvider,
DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    private static Queue<TmfTraceElement> boundsToUpdate = new ConcurrentLinkedQueue<TmfTraceElement>();
    private static UpdateTraceBoundsJob updateBounds = new UpdateTraceBoundsJob(Messages.TmfNavigatorLabelProvider_UpdateBoundsJobName, boundsToUpdate);

    public Image getImage(Object element) {
        if (element instanceof ITmfProjectModelElement) {
            return ((ITmfProjectModelElement)element).getIcon();
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof ITmfProjectModelElement) {
            return ((ITmfProjectModelElement)element).getLabelText();
        }
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    public String getDescription(Object anElement) {
        return this.getText(anElement);
    }

    public void init(ICommonContentExtensionSite aConfig) {
    }

    public StyledString getStyledText(Object element) {
        String text = this.getText(element);
        StyledString styledString = null;
        if (text != null) {
            boolean displayTimeRange;
            StyledString.Styler styler;
            if (element instanceof ITmfStyledProjectModelElement && (styler = ((ITmfStyledProjectModelElement)element).getStyler()) != null) {
                styledString = new StyledString(text, styler);
            }
            if (styledString == null) {
                styledString = new StyledString(text);
            }
            if ((displayTimeRange = Activator.getDefault().getPreferenceStore().getBoolean("EXPLORER_TIMERANGE")) && element instanceof TmfTraceElement) {
                styledString.append(TmfNavigatorLabelProvider.formatTraceRange(((TmfTraceElement)element).getElementUnderTraceFolder()));
            }
        }
        return styledString;
    }

    private static StyledString formatTraceRange(TmfTraceElement traceElement) {
        ITmfTimestamp start = traceElement.getStartTime();
        ITmfTimestamp end = traceElement.getEndTime();
        if (start == null) {
            boundsToUpdate.add(traceElement);
            if (updateBounds.getState() != 4) {
                updateBounds.schedule();
            }
            return new StyledString(" [...]", StyledString.DECORATIONS_STYLER);
        }
        if (start.equals(TmfTimestamp.BIG_BANG)) {
            return new StyledString();
        }
        if (end == null || end.equals(TmfTimestamp.BIG_BANG)) {
            return new StyledString(" [" + TmfTimestampFormat.getDefaulTimeFormat().format(start.toNanos()) + " - ...]", StyledString.DECORATIONS_STYLER);
        }
        return new StyledString(" [" + TmfTimestampFormat.getDefaulTimeFormat().format(start.toNanos()) + " - " + TmfTimestampFormat.getDefaulTimeFormat().format(end.toNanos()) + "]", StyledString.DECORATIONS_STYLER);
    }
}

