/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.Messages;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.TracePackageContentProvider;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.TracePackageElement;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.TracePackageExperimentElement;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.TracePackageFilesElement;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.TracePackageLabelProvider;
import org.eclipse.tracecompass.tmf.ui.dialog.TmfFileDialogFactory;

public abstract class AbstractTracePackageWizardPage
extends WizardPage {
    private static final int COMBO_HISTORY_LENGTH = 5;
    private static final String STORE_FILE_PATHS_ID = ".STORE_FILEPATHS_ID";
    private final String fStoreFilePathId = String.valueOf(this.getName()) + ".STORE_FILEPATHS_ID";
    private final IStructuredSelection fSelection;
    private CheckboxTreeViewer fElementViewer;
    private Button fSelectAllButton;
    private Button fDeselectAllButton;
    private Combo fFilePathCombo;
    private Button fBrowseButton;

    protected AbstractTracePackageWizardPage(String pageName, String title, ImageDescriptor titleImage, IStructuredSelection selection) {
        super(pageName, title, titleImage);
        this.fSelection = selection;
    }

    protected void createElementViewer(Composite compositeParent) {
        this.fElementViewer = new CheckboxTreeViewer(compositeParent, 2852);
        this.fElementViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                TracePackageElement element = (TracePackageElement)((Object)event.getElement());
                if (!element.isEnabled()) {
                    AbstractTracePackageWizardPage.this.fElementViewer.setChecked((Object)element, element.isChecked());
                } else {
                    AbstractTracePackageWizardPage.setSubtreeChecked(AbstractTracePackageWizardPage.this.fElementViewer, element, true, event.getChecked());
                }
                this.maintainCheckIntegrity(element);
                if (element.getParent() != null) {
                    if (element instanceof TracePackageFilesElement) {
                        if (!element.isChecked()) {
                            AbstractTracePackageWizardPage.setSubtreeChecked(AbstractTracePackageWizardPage.this.fElementViewer, element.getParent(), false, false);
                        }
                    } else if (element.isChecked()) {
                        TracePackageElement parent = element.getParent();
                        while (parent != null) {
                            TracePackageElement[] tracePackageElementArray = parent.getChildren();
                            int n = tracePackageElementArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                TracePackageElement e = tracePackageElementArray[n2];
                                if (e instanceof TracePackageFilesElement) {
                                    AbstractTracePackageWizardPage.setSubtreeChecked(AbstractTracePackageWizardPage.this.fElementViewer, e, false, true);
                                    break;
                                }
                                ++n2;
                            }
                            parent = parent.getParent();
                        }
                    }
                }
                this.maintainExperimentIntegrity(element);
                AbstractTracePackageWizardPage.this.updateApproximateSelectedSize();
                AbstractTracePackageWizardPage.this.updatePageCompletion();
            }

            private void maintainCheckIntegrity(TracePackageElement element) {
                TracePackageElement parentElement = element.getParent();
                boolean allChecked = true;
                boolean oneChecked = false;
                if (parentElement != null) {
                    if (parentElement.getChildren() != null) {
                        TracePackageElement[] tracePackageElementArray = parentElement.getChildren();
                        int n = tracePackageElementArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TracePackageElement child = tracePackageElementArray[n2];
                            if (AbstractTracePackageWizardPage.this.fElementViewer.getGrayed((Object)child)) {
                                oneChecked = true;
                                allChecked = false;
                                break;
                            }
                            boolean checked = AbstractTracePackageWizardPage.this.fElementViewer.getChecked((Object)child);
                            oneChecked |= checked;
                            allChecked &= checked;
                            ++n2;
                        }
                    }
                    if (oneChecked && !allChecked) {
                        AbstractTracePackageWizardPage.this.fElementViewer.setGrayChecked((Object)parentElement, true);
                    } else {
                        AbstractTracePackageWizardPage.this.fElementViewer.setGrayed((Object)parentElement, false);
                        AbstractTracePackageWizardPage.this.fElementViewer.setChecked((Object)parentElement, allChecked);
                    }
                    this.maintainCheckIntegrity(parentElement);
                }
            }

            private void maintainExperimentIntegrity(TracePackageElement element) {
                block7: {
                    TracePackageElement parent;
                    block6: {
                        parent = element;
                        while (parent.getParent() != null) {
                            parent = parent.getParent();
                        }
                        if (!(parent instanceof TracePackageExperimentElement) || !AbstractTracePackageWizardPage.this.fElementViewer.getChecked((Object)parent)) break block6;
                        TracePackageExperimentElement experiment = (TracePackageExperimentElement)parent;
                        block1: for (String expTrace : experiment.getExpTraces()) {
                            TracePackageElement[] tracePackageElementArray = (TracePackageElement[])AbstractTracePackageWizardPage.this.fElementViewer.getInput();
                            int n = tracePackageElementArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                TracePackageElement root = tracePackageElementArray[n2];
                                if (!(root instanceof TracePackageExperimentElement) && root.getText().equals(expTrace)) {
                                    AbstractTracePackageWizardPage.this.fElementViewer.setSubtreeChecked((Object)root, true);
                                    continue block1;
                                }
                                ++n2;
                            }
                        }
                        break block7;
                    }
                    if (parent instanceof TracePackageExperimentElement || AbstractTracePackageWizardPage.this.fElementViewer.getChecked((Object)parent)) break block7;
                    TracePackageElement[] tracePackageElementArray = (TracePackageElement[])AbstractTracePackageWizardPage.this.fElementViewer.getInput();
                    int n = tracePackageElementArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        TracePackageExperimentElement experiment;
                        TracePackageElement root = tracePackageElementArray[n3];
                        if (root instanceof TracePackageExperimentElement && (experiment = (TracePackageExperimentElement)root).getExpTraces().contains(parent.getText())) {
                            AbstractTracePackageWizardPage.this.fElementViewer.setSubtreeChecked((Object)experiment, false);
                        }
                        ++n3;
                    }
                }
            }
        });
        GridData layoutData = new GridData(1808);
        this.fElementViewer.getTree().setLayoutData((Object)layoutData);
        this.fElementViewer.setContentProvider((IContentProvider)new TracePackageContentProvider());
        this.fElementViewer.setLabelProvider((IBaseLabelProvider)new TracePackageLabelProvider());
    }

    protected abstract Object createElementViewerInput();

    protected void createFilePathGroup(Composite parent, String label, int fileDialogStyle) {
        Composite filePathSelectionGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        filePathSelectionGroup.setLayout((Layout)layout);
        filePathSelectionGroup.setLayoutData((Object)new GridData(272));
        Label destinationLabel = new Label(filePathSelectionGroup, 0);
        destinationLabel.setText(label);
        this.fFilePathCombo = new Combo(filePathSelectionGroup, 2052);
        GridData data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        this.fFilePathCombo.setLayoutData((Object)data);
        this.fBrowseButton = new Button(filePathSelectionGroup, 8);
        this.fBrowseButton.setText(Messages.TracePackage_Browse);
        this.fBrowseButton.addListener(13, event -> this.handleFilePathBrowseButtonPressed(fileDialogStyle));
        this.setButtonLayoutData(this.fBrowseButton);
    }

    protected abstract void updateWithFilePathSelection();

    protected Composite createButtonsGroup(Composite parent) {
        Composite buttonComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)new GridData(272));
        this.fSelectAllButton = new Button(buttonComposite, 8);
        this.fSelectAllButton.setText(Messages.TracePackage_SelectAll);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractTracePackageWizardPage.setAllChecked(AbstractTracePackageWizardPage.this.fElementViewer, true, true);
                AbstractTracePackageWizardPage.this.updateApproximateSelectedSize();
                AbstractTracePackageWizardPage.this.updatePageCompletion();
            }
        };
        this.fSelectAllButton.addSelectionListener((SelectionListener)listener);
        this.fDeselectAllButton = new Button(buttonComposite, 8);
        this.fDeselectAllButton.setText(Messages.TracePackage_DeselectAll);
        listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractTracePackageWizardPage.setAllChecked(AbstractTracePackageWizardPage.this.fElementViewer, true, false);
                AbstractTracePackageWizardPage.this.updateApproximateSelectedSize();
                AbstractTracePackageWizardPage.this.updatePageCompletion();
            }
        };
        this.fDeselectAllButton.addSelectionListener((SelectionListener)listener);
        return buttonComposite;
    }

    protected void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] directoryNames = settings.getArray(this.fStoreFilePathId);
            if (directoryNames == null || directoryNames.length == 0) {
                return;
            }
            int i = 0;
            while (i < directoryNames.length) {
                this.fFilePathCombo.add(directoryNames[i]);
                ++i;
            }
        }
    }

    protected void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] directoryNames = settings.getArray(this.fStoreFilePathId);
            if (directoryNames == null) {
                directoryNames = new String[]{};
            }
            directoryNames = AbstractTracePackageWizardPage.addToHistory(directoryNames, this.getFilePathValue());
            settings.put(this.fStoreFilePathId, directoryNames);
        }
    }

    protected void updatePageCompletion() {
        boolean pageComplete = this.determinePageCompletion();
        this.setPageComplete(pageComplete);
        if (pageComplete) {
            this.setErrorMessage(null);
        }
    }

    protected boolean determinePageCompletion() {
        return this.fElementViewer.getCheckedElements().length > 0 && !this.getFilePathValue().isEmpty();
    }

    protected void handleErrorStatus(IStatus status) {
        String message;
        Throwable exception = status.getException();
        String string = message = status.getMessage().length() > 0 ? status.getMessage() : Messages.TracePackage_ErrorOperation;
        if (!status.isMultiStatus()) {
            this.handleError(message, exception);
            return;
        }
        StringBuilder sb = new StringBuilder();
        IStatus[] iStatusArray = status.getChildren();
        int n = iStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            Throwable childException;
            IStatus childStatus = iStatusArray[n2];
            StringBuilder childSb = new StringBuilder();
            if (!childStatus.getMessage().isEmpty()) {
                childSb.append(String.valueOf(childStatus.getMessage()) + '\n');
            }
            if ((childException = childStatus.getException()) != null) {
                String stackMessage;
                String reason = childException.getMessage();
                if (reason == null) {
                    reason = childException.toString();
                }
                if ((stackMessage = ExceptionUtils.getStackTrace((Throwable)childException)) == null) {
                    stackMessage = reason;
                }
                childSb.append(stackMessage);
            }
            if (childSb.length() > 0) {
                childSb.insert(0, '\n');
                sb.append(childSb.toString());
            }
            ++n2;
        }
        exception = new CoreException((IStatus)new Status(4, "org.eclipse.tracecompass.tmf.ui", 4, sb.toString(), null));
        Status statusWithException = new Status(4, "org.eclipse.tracecompass.tmf.ui", 4, Messages.TracePackage_ErrorMultipleProblems, exception);
        Activator.getDefault().logError(message, exception);
        ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)Messages.TracePackage_InternalErrorTitle, (String)message, (IStatus)statusWithException);
    }

    protected void handleError(String message, Throwable exception) {
        Activator.getDefault().logError(message, exception);
        this.displayErrorDialog(message, exception);
    }

    private void displayErrorDialog(String message, Throwable exception) {
        String stackMessage;
        if (exception == null) {
            Status s = new Status(4, "org.eclipse.tracecompass.tmf.ui", message);
            ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)Messages.TracePackage_InternalErrorTitle, null, (IStatus)s);
            return;
        }
        String reason = exception.getMessage();
        if (reason == null) {
            reason = exception.toString();
        }
        if ((stackMessage = ExceptionUtils.getStackTrace((Throwable)exception)) == null || stackMessage.isEmpty()) {
            stackMessage = reason;
        }
        CoreException coreException = new CoreException((IStatus)new Status(4, "org.eclipse.tracecompass.tmf.ui", 4, stackMessage, exception));
        Status s = new Status(4, "org.eclipse.tracecompass.tmf.ui", 4, reason, (Throwable)coreException);
        ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)Messages.TracePackage_InternalErrorTitle, (String)message, (IStatus)s);
    }

    protected static void setSubtreeChecked(CheckboxTreeViewer viewer, TracePackageElement element, boolean enabledOnly, boolean checked) {
        if (!enabledOnly || element.isEnabled()) {
            viewer.setChecked((Object)element, checked);
            if (checked) {
                viewer.setGrayed((Object)element, false);
            }
            element.setChecked(checked);
            if (element.getChildren() != null) {
                TracePackageElement[] tracePackageElementArray = element.getChildren();
                int n = tracePackageElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TracePackageElement child = tracePackageElementArray[n2];
                    AbstractTracePackageWizardPage.setSubtreeChecked(viewer, child, enabledOnly, checked);
                    ++n2;
                }
            }
        }
    }

    protected static void setAllChecked(CheckboxTreeViewer viewer, boolean enabledOnly, boolean checked) {
        TreeItem[] items = viewer.getTree().getItems();
        int i = 0;
        while (i < items.length) {
            Object element = items[i].getData();
            AbstractTracePackageWizardPage.setSubtreeChecked(viewer, (TracePackageElement)((Object)element), enabledOnly, checked);
            ++i;
        }
    }

    private static void addToHistory(List<String> history, String newEntry) {
        history.remove(newEntry);
        history.add(0, newEntry);
        if (history.size() > 5) {
            history.remove(5);
        }
    }

    private static String[] addToHistory(String[] history, String newEntry) {
        ArrayList<String> l = new ArrayList<String>(Arrays.asList(history));
        AbstractTracePackageWizardPage.addToHistory(l, newEntry);
        String[] r = new String[l.size()];
        l.toArray(r);
        return r;
    }

    private void handleFilePathBrowseButtonPressed(int fileDialogStyle) {
        String selectedFileName;
        FileDialog dialog = TmfFileDialogFactory.create(this.getContainer().getShell(), fileDialogStyle | 0x10000000);
        dialog.setFilterExtensions(new String[]{"*.zip;*.tar.gz;*.tar;*.tgz", "*.*"});
        dialog.setText(Messages.TracePackage_FileDialogTitle);
        String currentSourceString = this.getFilePathValue();
        int lastSeparatorIndex = currentSourceString.lastIndexOf(File.separator);
        if (lastSeparatorIndex != -1) {
            dialog.setFilterPath(currentSourceString.substring(0, lastSeparatorIndex));
        }
        if ((selectedFileName = dialog.open()) != null) {
            this.setFilePathValue(selectedFileName);
            this.updateWithFilePathSelection();
        }
    }

    protected String getFilePathValue() {
        return this.fFilePathCombo.getText().trim();
    }

    protected void setFilePathValue(String value) {
        this.fFilePathCombo.setText(value);
        this.updatePageCompletion();
    }

    protected void updateApproximateSelectedSize() {
    }

    protected CheckboxTreeViewer getElementViewer() {
        return this.fElementViewer;
    }

    protected Combo getFilePathCombo() {
        return this.fFilePathCombo;
    }

    protected IStructuredSelection getSelection() {
        return this.fSelection;
    }
}

