/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.remote.ui.wizards.fetch;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tracecompass.internal.tmf.remote.ui.messages.RemoteMessages;
import org.eclipse.tracecompass.internal.tmf.remote.ui.wizards.fetch.RemoteFetchLogWizardRemotePage;
import org.eclipse.tracecompass.internal.tmf.remote.ui.wizards.fetch.model.RemoteImportConnectionNodeElement;
import org.eclipse.tracecompass.internal.tmf.remote.ui.wizards.fetch.model.RemoteImportProfileElement;
import org.eclipse.tracecompass.internal.tmf.remote.ui.wizards.fetch.preferences.RemoteProfilesPreferencePage;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.ImportTraceWizardPage;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.Messages;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.TracePackageElement;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class RemoteFetchLogWizardPage
extends ImportTraceWizardPage {
    private static final String PAGE_NAME = "org.eclipse.tracecompass.internal.tmf.remote.ui.wizards.fetch.RemoteFetchLogWizardPage";
    private static final String ICON_PATH = "icons/elcl16/fetch_log_wiz.gif";
    private Combo fProfileNameCombo;
    private Text fNodesText;
    private Button fOverwriteExistingResourcesCheckbox;
    private List<RemoteImportProfileElement> fProfiles = new ArrayList<RemoteImportProfileElement>();
    private RemoteImportProfileElement fProfile;

    public RemoteFetchLogWizardPage(String title, IStructuredSelection selection) {
        super(PAGE_NAME, selection);
        this.setTitle(title);
        this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.tracecompass.tmf.remote.ui", (String)ICON_PATH));
        this.setDescription(RemoteMessages.RemoteFetchLogWizardPage_Description);
    }

    public boolean finish() {
        return true;
    }

    public boolean canFlipToNextPage() {
        return this.fProfile != null;
    }

    protected void createSourceGroup(final Composite parent) {
        Composite directoryContainerGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        directoryContainerGroup.setLayout((Layout)layout);
        directoryContainerGroup.setFont(parent.getFont());
        directoryContainerGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        Label profileLabel = new Label(directoryContainerGroup, 0);
        profileLabel.setText(RemoteMessages.RemoteProfilesPreferencePage_ProfileNameLabel);
        profileLabel.setFont(parent.getFont());
        this.fProfileNameCombo = new Combo(directoryContainerGroup, 2056);
        GridData pdata = new GridData(4, 4, true, false);
        pdata.widthHint = 250;
        this.fProfileNameCombo.setLayoutData((Object)pdata);
        this.fProfileNameCombo.setFont(parent.getFont());
        Button manageProfilesButton = new Button(directoryContainerGroup, 0);
        manageProfilesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)parent.getShell(), (String)"org.eclipse.linuxtools.tmf.remote.ui.preferences.remoteprofiles", (String[])new String[]{"org.eclipse.linuxtools.tmf.remote.ui.preferences.remoteprofiles"}, null);
                RemoteProfilesPreferencePage page = (RemoteProfilesPreferencePage)((Object)dialog.getSelectedPage());
                page.setSelectedProfile(RemoteFetchLogWizardPage.this.fProfileNameCombo.getText());
                if (dialog.open() == 0) {
                    RemoteFetchLogWizardPage.this.fProfiles.clear();
                    RemoteFetchLogWizardPage.this.fProfile = null;
                    RemoteFetchLogWizardPage.this.updateProfileData();
                    if (page.getSelectedProfile() != null) {
                        int index = RemoteFetchLogWizardPage.this.fProfileNameCombo.indexOf(page.getSelectedProfile());
                        RemoteFetchLogWizardPage.this.fProfileNameCombo.select(index);
                    }
                    RemoteFetchLogWizardPage.this.updateFromSourceField();
                }
            }
        });
        manageProfilesButton.setText(RemoteMessages.RemoteFetchLogWizardPage_ManageProfileLabel);
        Label nodesLabel = new Label(directoryContainerGroup, 0);
        nodesLabel.setText(RemoteMessages.RemoteFetchLogWizardPage_NodesLabel);
        nodesLabel.setFont(parent.getFont());
        this.fNodesText = new Text(directoryContainerGroup, 0);
        GridData gd_nodeText = new GridData(4, 4, true, false);
        gd_nodeText.horizontalSpan = 2;
        gd_nodeText.widthHint = 0;
        this.fNodesText.setLayoutData((Object)gd_nodeText);
        this.fNodesText.setEditable(false);
        this.fNodesText.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                RemoteFetchLogWizardPage.this.updateNodesText();
            }
        });
        this.updateProfileData();
        this.updateFromSourceField();
        this.fProfileNameCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RemoteFetchLogWizardPage.this.updateFromSourceField();
            }
        });
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    public boolean validateSourceGroup() {
        return true;
    }

    protected void createOptionsGroupButtons(Group optionsGroup) {
        this.fOverwriteExistingResourcesCheckbox = new Button((Composite)optionsGroup, 32);
        this.fOverwriteExistingResourcesCheckbox.setFont(optionsGroup.getFont());
        this.fOverwriteExistingResourcesCheckbox.setText(Messages.ImportTraceWizard_OverwriteExistingTrace);
        this.fOverwriteExistingResourcesCheckbox.setSelection(false);
        this.fOverwriteExistingResourcesCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RemoteFetchLogWizardPage.this.updateNextPage();
                RemoteFetchLogWizardPage.this.setPageComplete(RemoteFetchLogWizardPage.this.fProfile != null);
            }
        });
        this.updateWidgetEnablements();
    }

    private void updateProfileData() {
        this.fProfileNameCombo.removeAll();
        this.fProfiles = RemoteProfilesPreferencePage.getRemoteProfiles((IProgressMonitor)new NullProgressMonitor());
        int i = 0;
        for (RemoteImportProfileElement profile : this.fProfiles) {
            this.fProfileNameCombo.add(profile.getProfileName(), i++);
        }
        if (i > 0) {
            this.fProfileNameCombo.select(0);
        }
    }

    private void updateFromSourceField() {
        int index = this.fProfileNameCombo.getSelectionIndex();
        if (index < 0) {
            this.updateNodesText();
            this.updateNextPage();
            this.setPageComplete(false);
            return;
        }
        this.fProfile = this.fProfiles.get(index);
        this.updateNodesText();
        this.updateNextPage();
        this.setPageComplete(true);
    }

    private void updateNodesText() {
        if (this.fProfile == null) {
            this.fNodesText.setText("");
            this.fNodesText.setToolTipText(null);
            return;
        }
        StringBuilder text = new StringBuilder();
        StringBuilder tooltip = new StringBuilder();
        TracePackageElement[] tracePackageElementArray = this.fProfile.getChildren();
        int n = tracePackageElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            TracePackageElement element = tracePackageElementArray[n2];
            if (element instanceof RemoteImportConnectionNodeElement) {
                RemoteImportConnectionNodeElement node = (RemoteImportConnectionNodeElement)element;
                if (text.length() != 0) {
                    text.append(", ");
                    tooltip.append('\n');
                }
                String nodeInfo = String.valueOf(node.getName()) + " (" + node.getURI().toString() + ')';
                text.append(nodeInfo);
                tooltip.append(nodeInfo);
            }
            ++n2;
        }
        this.fNodesText.setText(text.toString());
        this.fNodesText.setToolTipText(null);
        while (this.fNodesText.computeSize((int)-1, (int)-1).x > this.fNodesText.getSize().x && text.length() > 0) {
            text.deleteCharAt(text.length() - 1);
            this.fNodesText.setText(String.valueOf(text.toString()) + "...");
            this.fNodesText.setToolTipText(tooltip.toString());
        }
    }

    private void updateNextPage() {
        IWizardPage nextPage = this.getNextPage();
        if (nextPage instanceof RemoteFetchLogWizardRemotePage) {
            ((RemoteFetchLogWizardRemotePage)nextPage).setPageData(this.fProfile, this.fOverwriteExistingResourcesCheckbox != null ? this.fOverwriteExistingResourcesCheckbox.getSelection() : false);
        }
    }
}

