/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.remote.core.shell;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.tmf.remote.core.shell.ICommandResult;

@NonNullByDefault
public class CommandResult
implements ICommandResult {
    private final int fResult;
    private final List<String> fOutput;
    private final List<String> fErrorOutput;

    public CommandResult(int result, @NonNull String[] output, @NonNull String[] errorOutput) {
        this.fResult = result;
        this.fOutput = ImmutableList.copyOf((Object[])output);
        this.fErrorOutput = ImmutableList.copyOf((Object[])errorOutput);
    }

    @Override
    public int getResult() {
        return this.fResult;
    }

    @Override
    public List<String> getOutput() {
        return this.fOutput;
    }

    @Override
    public List<String> getErrorOutput() {
        return this.fErrorOutput;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append("Error Output:\n");
        for (String string : this.fErrorOutput) {
            ret.append(string).append("\n");
        }
        ret.append("Return Value: ");
        ret.append(this.fResult);
        ret.append("\n");
        for (String string : this.fOutput) {
            ret.append(string).append("\n");
        }
        return NonNullUtils.nullToEmptyString((Object)ret.toString());
    }
}

