/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.io;

import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;

@NonNullByDefault
public class ResourceUtil {
    private static final boolean IS_WINDOWS = System.getProperty("os.name").contains("Windows");
    private static boolean fIsSymLinkSupported = !IS_WINDOWS;

    private ResourceUtil() {
    }

    public static boolean createSymbolicLink(IResource link, @Nullable IPath targetLocation, boolean useFileSystemLinks, @Nullable IProgressMonitor monitor) throws CoreException {
        java.nio.file.Path linkPath;
        SubMonitor subMon;
        block10: {
            block9: {
                if (!(link instanceof IFile) && !(link instanceof IFolder) || targetLocation == null) {
                    return false;
                }
                subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
                IPath location = ResourceUtil.getLocation(link);
                if (location == null || !link.exists() || !location.equals((Object)targetLocation)) break block9;
                return true;
            }
            linkPath = Paths.get(link.getProject().getLocation().append(link.getProjectRelativePath()).toOSString(), new String[0]);
            if (ResourceUtil.checkResource(link, linkPath)) break block10;
            return false;
        }
        try {
            if (!fIsSymLinkSupported || !useFileSystemLinks) {
                return ResourceUtil.createEclipseLink(link, targetLocation, (IProgressMonitor)subMon);
            }
            String targetPathString = targetLocation.toOSString();
            java.nio.file.Path targetPath = Paths.get(targetPathString, new String[0]);
            if (Files.isSymbolicLink(targetPath)) {
                targetPath = Files.readSymbolicLink(targetPath);
            }
            Files.createSymbolicLink(linkPath, targetPath, new FileAttribute[0]);
            subMon.worked(1);
            if (link.getParent() != null) {
                link.getParent().refreshLocal(1, (IProgressMonitor)subMon.split(1));
            }
            link.refreshLocal(2, (IProgressMonitor)subMon.split(1));
            return true;
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.tracecompass.tmf.core", "Error creating symbolic link", (Throwable)e));
        }
        catch (UnsupportedOperationException e) {
            fIsSymLinkSupported = false;
            return ResourceUtil.createEclipseLink(link, targetLocation, (IProgressMonitor)subMon.split(2));
        }
    }

    public static void deleteResource(@Nullable IResource resource, @Nullable IProgressMonitor monitor) throws CoreException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        if (resource == null) {
            return;
        }
        if (ResourceUtil.isFileSystemSymbolicLink(resource) && !resource.exists() && (resource instanceof IFile || resource instanceof IFolder)) {
            try {
                java.nio.file.Path linkPath = Paths.get(resource.getProject().getLocation().append(resource.getProjectRelativePath()).toOSString(), new String[0]);
                Files.delete(linkPath);
                subMon.worked(1);
                return;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        resource.delete(true, (IProgressMonitor)subMon);
    }

    public static @Nullable IResource copyResource(@Nullable IResource resource, @Nullable IPath destinationPath, int flags, @Nullable IProgressMonitor monitor) throws CoreException {
        IPath target;
        if (resource == null || destinationPath == null) {
            return null;
        }
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        boolean isFileSystemSymbolicLink = ResourceUtil.isFileSystemSymbolicLink(resource);
        IPath iPath = target = destinationPath.isAbsolute() ? destinationPath : resource.getParent().getFullPath().append(destinationPath);
        if (isFileSystemSymbolicLink && (flags & 0x20) != 0 && (resource instanceof IFile || resource instanceof IFolder)) {
            return ResourceUtil.copySymlink(resource, (IPath)NonNullUtils.checkNotNull((Object)target), (SubMonitor)NonNullUtils.checkNotNull((Object)subMon), (IWorkspaceRoot)NonNullUtils.checkNotNull((Object)workspaceRoot));
        }
        resource.copy(destinationPath, flags, (IProgressMonitor)subMon);
        return workspaceRoot.findMember(target);
    }

    public static boolean isSymbolicLink(@Nullable IResource resource) {
        boolean isLinked = false;
        if (resource != null && !(isLinked = resource.isLinked())) {
            isLinked = ResourceUtil.isFileSystemSymbolicLink(resource);
        }
        return isLinked;
    }

    public static void deleteIfBrokenSymbolicLink(@Nullable IResource resource) throws CoreException {
        if (resource == null) {
            return;
        }
        if (resource.isLinked()) {
            IPath location = resource.getLocation();
            if (location == null || !location.toFile().exists()) {
                resource.delete(true, null);
            }
        } else {
            java.nio.file.Path linkPath;
            URI uri = resource.getLocationURI();
            if (uri != null && Files.isSymbolicLink(linkPath = Paths.get(uri)) && !resource.exists()) {
                try {
                    Files.delete(linkPath);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static @Nullable IPath getLocation(@Nullable IResource resource) {
        URI locationUri = ResourceUtil.getLocationURI(resource);
        if (locationUri != null) {
            return new Path(locationUri.getPath());
        }
        return null;
    }

    public static @Nullable URI getLocationURI(@Nullable IResource resource) {
        if (resource != null) {
            if (ResourceUtil.isFileSystemSymbolicLink(resource)) {
                try {
                    return Files.readSymbolicLink(Paths.get(resource.getLocationURI())).toUri();
                }
                catch (IOException iOException) {
                }
            } else {
                return resource.getLocationURI();
            }
        }
        return null;
    }

    private static boolean createEclipseLink(IResource link, IPath targetLocation, @Nullable IProgressMonitor monitor) throws CoreException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor);
        if (link instanceof IFile) {
            ((IFile)link).createLink(targetLocation, 256, (IProgressMonitor)subMon);
        } else if (link instanceof IFolder) {
            ((IFolder)link).createLink(targetLocation, 256, (IProgressMonitor)subMon);
        }
        return true;
    }

    private static boolean isFileSystemSymbolicLink(IResource resource) {
        URI uri = resource.getLocationURI();
        return uri == null ? false : Files.isSymbolicLink(Paths.get(uri));
    }

    private static boolean checkResource(IResource link, java.nio.file.Path linkPath) throws CoreException, IOException {
        if (link.exists()) {
            if (link.isLinked() || Files.isSymbolicLink(linkPath)) {
                link.delete(true, null);
            } else {
                return false;
            }
        }
        if (Files.isSymbolicLink(linkPath)) {
            Files.delete(linkPath);
        } else if (linkPath.toFile().exists()) {
            return false;
        }
        return true;
    }

    private static @Nullable IResource copySymlink(IResource resource, IPath destinationPath, SubMonitor monitor, IWorkspaceRoot workspaceRoot) throws CoreException {
        AtomicReference newResourceRef = new AtomicReference();
        java.nio.file.Path originalLinkedFile = Paths.get(resource.getProject().getLocation().append(resource.getProjectRelativePath()).toOSString(), new String[0]);
        IPath newLocation = workspaceRoot.findMember(destinationPath.segment(0)).getLocation().append(destinationPath.removeFirstSegments(1));
        java.nio.file.Path newLinkedFile = Paths.get(newLocation.toOSString(), new String[0]);
        IResource parent = workspaceRoot.findMember(destinationPath.removeLastSegments(1));
        if (parent == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.tracecompass.tmf.core", "Parent resource does not exist: " + destinationPath.removeLastSegments(1)));
        }
        ResourcesPlugin.getWorkspace().run(mon -> {
            try {
                SubMonitor subMon = SubMonitor.convert((IProgressMonitor)mon, (int)2);
                Files.copy(originalLinkedFile, newLinkedFile, LinkOption.NOFOLLOW_LINKS);
                parent.refreshLocal(1, (IProgressMonitor)subMon.split(1));
                IResource newResource = workspaceRoot.findMember(destinationPath);
                if (newResource == null) {
                    return;
                }
                newResource.refreshLocal(2, (IProgressMonitor)subMon.split(1));
                Map persistentProperties = resource.getPersistentProperties();
                if (persistentProperties != null) {
                    for (Map.Entry entry : persistentProperties.entrySet()) {
                        newResource.setPersistentProperty((QualifiedName)entry.getKey(), (String)entry.getValue());
                    }
                }
                newResourceRef.set(newResource);
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.tracecompass.tmf.core", "Error copying symbolic link", (Throwable)e));
            }
        }, (ISchedulingRule)parent.getParent(), 1, (IProgressMonitor)monitor);
        return (IResource)newResourceRef.get();
    }
}

