/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.core.request;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.tracecompass.internal.tmf.core.Activator;
import org.eclipse.tracecompass.internal.tmf.core.TmfCoreTracer;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.request.ITmfEventRequest;
import org.eclipse.tracecompass.tmf.core.request.TmfEventRequest;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;

public class TmfCoalescedEventRequest
extends TmfEventRequest {
    private final List<ITmfEventRequest> fRequests = new ArrayList<ITmfEventRequest>();
    private TmfTimeRange fRange;
    private Map<String, Set<ITmfEventRequest>> fRequestsCache = new HashMap<String, Set<ITmfEventRequest>>();

    public TmfCoalescedEventRequest(Class<? extends ITmfEvent> dataType, TmfTimeRange range, long index, int nbRequested, ITmfEventRequest.ExecutionType priority, int dependencyLevel) {
        super(ITmfEvent.class, null, index, nbRequested, priority, dependencyLevel);
        this.fRange = range;
        if (TmfCoreTracer.isRequestTraced()) {
            String type = this.getClass().getName();
            type = type.substring(type.lastIndexOf(46) + 1);
            String message = "CREATED " + (this.getExecType() == ITmfEventRequest.ExecutionType.BACKGROUND ? "(BG)" : "(FG)") + " Type=" + type + " Index=" + this.getIndex() + " NbReq=" + this.getNbRequested() + " Range=" + this.getRange() + " DataType=" + this.getDataType().getSimpleName();
            TmfCoreTracer.traceRequest(this.getRequestId(), message);
        }
    }

    @Override
    public TmfTimeRange getRange() {
        return this.fRange;
    }

    public void addRequest(ITmfEventRequest request) {
        if (request instanceof TmfCoalescedEventRequest) {
            TmfCoalescedEventRequest otherRequest = (TmfCoalescedEventRequest)request;
            for (ITmfEventRequest subRequest : otherRequest.fRequests) {
                this.fRequests.add(subRequest);
                this.merge(subRequest);
            }
        } else {
            this.fRequests.add(request);
            this.merge(request);
        }
    }

    public boolean isCompatible(ITmfEventRequest request) {
        return request.getExecType() == this.getExecType() && request.getDependencyLevel() == this.getDependencyLevel() && this.ranksOverlap(request) && this.timeRangesOverlap(request);
    }

    private boolean ranksOverlap(ITmfEventRequest request) {
        long start = request.getIndex();
        long end = start + (long)request.getNbRequested();
        return start <= this.fIndex + (long)this.fNbRequested + 1L && end >= this.fIndex - 1L;
    }

    private boolean timeRangesOverlap(ITmfEventRequest request) {
        ITmfTimestamp endTime;
        ITmfTimestamp startTime = request.getRange().getStartTime();
        return startTime.compareTo(endTime = request.getRange().getEndTime()) <= 0 && this.fRange.getStartTime().compareTo(this.fRange.getEndTime()) <= 0;
    }

    private void merge(ITmfEventRequest request) {
        long start = request.getIndex();
        long end = Math.min(start + (long)request.getNbRequested(), Integer.MAX_VALUE);
        if (start < this.fIndex) {
            if (this.fNbRequested != Integer.MAX_VALUE) {
                this.fNbRequested = (int)((long)this.fNbRequested + (this.fIndex - start));
            }
            this.fIndex = start;
        }
        this.fNbRequested = request.getNbRequested() == Integer.MAX_VALUE || this.fNbRequested == Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)Math.max(end - this.fIndex, (long)this.fNbRequested);
        ITmfTimestamp startTime = request.getRange().getStartTime();
        ITmfTimestamp endTime = request.getRange().getEndTime();
        if (!this.fRange.contains(startTime) && this.fRange.getStartTime().compareTo(startTime) > 0) {
            this.fRange = new TmfTimeRange(startTime, this.fRange.getEndTime());
        }
        if (!this.fRange.contains(endTime) && this.fRange.getEndTime().compareTo(endTime) < 0) {
            this.fRange = new TmfTimeRange(this.fRange.getStartTime(), endTime);
        }
    }

    public String getSubRequestIds() {
        StringBuffer result = new StringBuffer("[");
        int i = 0;
        while (i < this.fRequests.size()) {
            if (i != 0) {
                result.append(", ");
            }
            result.append(this.fRequests.get(i).getRequestId());
            ++i;
        }
        result.append("]");
        return result.toString();
    }

    @Override
    public void handleData(ITmfEvent data) {
        super.handleData(data);
        long index = this.getIndex() + (long)this.getNbRead() - 1L;
        String traceName = data.getTrace().getName();
        Set<ITmfEventRequest> requests = this.fRequestsCache.get(traceName);
        if (requests == null) {
            requests = new HashSet<ITmfEventRequest>();
            for (ITmfEventRequest myRequest : this.fRequests) {
                if (!myRequest.getProviderFilter().matches(data)) continue;
                requests.add(myRequest);
            }
            this.fRequestsCache.put(traceName, requests);
        }
        for (ITmfEventRequest request : requests) {
            long start = request.getIndex();
            if (request.isCompleted() || index < start || request.getNbRead() >= request.getNbRequested()) continue;
            ITmfTimestamp ts = data.getTimestamp();
            if (!request.getRange().contains(ts) || !request.getDataType().isInstance(data)) continue;
            try {
                request.handleData(data);
            }
            catch (Exception e) {
                Activator.logError("An uncaught exception happened on request " + request + ": " + e.getMessage());
                request.fail(e);
            }
        }
    }

    @Override
    public synchronized void start() {
        for (ITmfEventRequest request : this.fRequests) {
            if (request.isCompleted()) continue;
            request.start();
        }
        super.start();
    }

    @Override
    public synchronized void done() {
        for (ITmfEventRequest request : this.fRequests) {
            if (request.isCompleted()) continue;
            request.done();
        }
        super.done();
    }

    @Override
    public void fail(Exception e) {
        for (ITmfEventRequest request : this.fRequests) {
            request.fail(e);
        }
        super.fail(e);
    }

    @Override
    public void cancel() {
        for (ITmfEventRequest request : this.fRequests) {
            if (request.isCompleted()) continue;
            request.cancel();
        }
        super.cancel();
    }

    @Override
    public synchronized boolean isCompleted() {
        if (super.isCompleted()) {
            return true;
        }
        if (!this.fRequests.isEmpty()) {
            for (ITmfEventRequest request : this.fRequests) {
                if (request.isCompleted()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean isCancelled() {
        if (super.isCancelled()) {
            return true;
        }
        if (!this.fRequests.isEmpty()) {
            for (ITmfEventRequest request : this.fRequests) {
                if (request.isCancelled()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return "[TmfCoalescedEventRequest(" + this.getRequestId() + "," + this.getDataType().getSimpleName() + "," + (Object)((Object)this.getExecType()) + "," + this.getRange() + "," + this.getIndex() + "," + this.getNbRequested() + ", " + this.fRequests.toString() + ")]";
    }
}

