/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.kernel.core.analysis.graph.handlers;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.tracecompass.analysis.graph.core.building.AbstractTraceEventHandler;
import org.eclipse.tracecompass.analysis.os.linux.core.execution.graph.OsExecutionGraphProvider;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.trace.layout.Lttng28EventLayout;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.trace.layout.LttngEventLayout;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTraceWithPreDefinedEvents;
import org.eclipse.tracecompass.tmf.core.trace.TmfEventTypeCollectionHelper;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;

public class BaseHandler
extends AbstractTraceEventHandler {
    private final OsExecutionGraphProvider fProvider;
    private Map<ITmfTrace, String> fWakeupEventMap;

    BaseHandler(OsExecutionGraphProvider provider, int priority) {
        super(priority);
        this.fProvider = provider;
        this.fWakeupEventMap = new HashMap<ITmfTrace, String>();
        ITmfTrace trace = this.getProvider().getTrace();
        Collection traceSet = TmfTraceManager.getTraceSet((ITmfTrace)trace);
        for (ITmfTrace traceItem : traceSet) {
            IKernelAnalysisEventLayout layout = this.getProvider().getEventLayout(traceItem);
            String wakeupEvent = layout.eventSchedProcessWakeup();
            if (traceItem instanceof ITmfTraceWithPreDefinedEvents) {
                Set content = ((ITmfTraceWithPreDefinedEvents)traceItem).getContainedEventTypes();
                Set traceEvents = TmfEventTypeCollectionHelper.getEventNames((Iterable)content);
                if (layout instanceof LttngEventLayout) {
                    Lttng28EventLayout layout28;
                    LttngEventLayout lttngLayout = (LttngEventLayout)layout;
                    if (traceEvents.contains(lttngLayout.eventSchedProcessTTWU())) {
                        wakeupEvent = lttngLayout.eventSchedProcessTTWU();
                    } else if (layout instanceof Lttng28EventLayout && traceEvents.contains((layout28 = (Lttng28EventLayout)layout).eventSchedProcessWaking())) {
                        wakeupEvent = layout28.eventSchedProcessWaking();
                    }
                }
            }
            this.fWakeupEventMap.put(traceItem, wakeupEvent);
        }
    }

    public OsExecutionGraphProvider getProvider() {
        return this.fProvider;
    }

    public boolean isWakeupEvent(ITmfEvent event) {
        Lttng28EventLayout layout28;
        LttngEventLayout layoutDefault;
        String eventName = event.getName();
        ITmfTrace trace = event.getTrace();
        IKernelAnalysisEventLayout eventLayout = this.getProvider().getEventLayout(event.getTrace());
        String wakeupEventName = NonNullUtils.nullToEmptyString((Object)this.fWakeupEventMap.get(trace));
        if (eventLayout instanceof LttngEventLayout && wakeupEventName.equals((layoutDefault = (LttngEventLayout)eventLayout).eventSchedProcessTTWU())) {
            return eventName.equals(layoutDefault.eventSchedProcessTTWU());
        }
        if (eventLayout instanceof Lttng28EventLayout && wakeupEventName.equals((layout28 = (Lttng28EventLayout)eventLayout).eventSchedProcessWaking())) {
            return eventName.equals(layout28.eventSchedProcessWaking()) || eventName.equals(layout28.eventSchedProcessWakeupNew());
        }
        if (wakeupEventName.equals(eventLayout.eventSchedProcessWakeup())) {
            return eventLayout.eventsSchedWakeup().contains(eventName);
        }
        return false;
    }

    public void handleEvent(ITmfEvent event) {
    }
}

