/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.themes.css;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.swt.graphics.Color;
import org.eclipse.tm4e.core.theme.IStyle;
import org.eclipse.tm4e.core.theme.RGB;
import org.eclipse.tm4e.core.theme.css.CSSParser;
import org.eclipse.tm4e.ui.TMUIPlugin;
import org.eclipse.tm4e.ui.themes.AbstractTokenProvider;
import org.eclipse.tm4e.ui.themes.ColorManager;

public class CSSTokenProvider
extends AbstractTokenProvider {
    private Map<IStyle, IToken> tokenMaps = new HashMap<IStyle, IToken>();
    private CSSParser parser;

    public CSSTokenProvider(InputStream in) {
        try {
            this.parser = new CSSParser(in);
            for (IStyle style : this.parser.getStyles()) {
                RGB color = style.getColor();
                if (color == null) continue;
                int s = 0;
                if (style.isBold()) {
                    s |= 1;
                }
                if (style.isItalic()) {
                    s |= 2;
                }
                if (style.isUnderline()) {
                    s |= 0x40000000;
                }
                if (style.isStrikeThrough()) {
                    s |= 0x20000000;
                }
                this.tokenMaps.put(style, (IToken)new Token((Object)new TextAttribute(ColorManager.getInstance().getColor(color), null, s)));
            }
        }
        catch (Exception e) {
            TMUIPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.tm4e.ui", e.getMessage(), (Throwable)e));
        }
    }

    @Override
    public IToken getToken(String type) {
        IToken t;
        if (type == null) {
            return null;
        }
        IStyle style = this.parser.getBestStyle(type.split("[.]"));
        if (style != null && (t = this.tokenMaps.get(style)) != null) {
            return t;
        }
        return null;
    }

    @Override
    public Color getEditorForeground() {
        IStyle style = this.parser.getBestStyle(new String[]{"editor"});
        if (style != null && style.getColor() != null) {
            return ColorManager.getInstance().getColor(style.getColor());
        }
        return null;
    }

    @Override
    public Color getEditorBackground() {
        IStyle style = this.parser.getBestStyle(new String[]{"editor"});
        if (style != null && style.getBackgroundColor() != null) {
            return ColorManager.getInstance().getColor(style.getBackgroundColor());
        }
        return null;
    }

    @Override
    public Color getEditorSelectionForeground() {
        IStyle style = this.parser.getBestStyle(new String[]{"editor", "selection"});
        if (style != null && style.getColor() != null) {
            return ColorManager.getInstance().getColor(style.getColor());
        }
        return null;
    }

    @Override
    public Color getEditorSelectionBackground() {
        IStyle style = this.parser.getBestStyle(new String[]{"editor", "selection"});
        if (style != null && style.getBackgroundColor() != null) {
            return ColorManager.getInstance().getColor(style.getBackgroundColor());
        }
        return null;
    }

    @Override
    public Color getEditorCurrentLineHighlight() {
        IStyle style = this.parser.getBestStyle(new String[]{"editor", "lineHighlight"});
        if (style != null && style.getBackgroundColor() != null) {
            return ColorManager.getInstance().getColor(style.getBackgroundColor());
        }
        return null;
    }
}

