/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.emulator;

import org.eclipse.tm.internal.terminal.emulator.IVT100EmulatorBackend;
import org.eclipse.tm.terminal.model.ITerminalTextData;
import org.eclipse.tm.terminal.model.TerminalStyle;

public class VT100EmulatorBackend
implements IVT100EmulatorBackend {
    private int fCursorColumn;
    private int fCursorLine;
    private boolean fWrapPending;
    private boolean fInsertMode;
    private TerminalStyle fDefaultStyle;
    private TerminalStyle fStyle;
    int fLines;
    int fColumns;
    private final ITerminalTextData fTerminal;
    private boolean fVT100LineWrapping;
    private ScrollRegion fScrollRegion = ScrollRegion.FULL_WINDOW;

    public VT100EmulatorBackend(ITerminalTextData terminal) {
        this.fTerminal = terminal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearAll() {
        ITerminalTextData iTerminalTextData = this.fTerminal;
        synchronized (iTerminalTextData) {
            int n = this.fTerminal.getHeight();
            int line = 0;
            while (line < n) {
                this.fTerminal.cleanLine(line);
                ++line;
            }
            this.fTerminal.setDimensions(this.fLines, this.fTerminal.getWidth());
            this.setStyle(this.getDefaultStyle());
            this.setCursor(0, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDimensions(int lines, int cols) {
        ITerminalTextData iTerminalTextData = this.fTerminal;
        synchronized (iTerminalTextData) {
            if (lines == this.fLines && cols == this.fColumns) {
                return;
            }
            int cl = this.getCursorLine();
            int cc = this.getCursorColumn();
            int height = this.fTerminal.getHeight();
            int acl = cl + height - this.fLines;
            int newLines = Math.max(lines, height);
            if (lines < this.fLines && height == this.fLines) {
                newLines = Math.max(lines, cl + 1);
            }
            this.fLines = lines;
            this.fColumns = cols;
            this.fTerminal.setDimensions(newLines, this.fColumns);
            cl = acl - (newLines - this.fLines);
            this.setCursor(cl, cc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int toAbsoluteLine(int line) {
        ITerminalTextData iTerminalTextData = this.fTerminal;
        synchronized (iTerminalTextData) {
            return this.fTerminal.getHeight() - this.fLines + line;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertCharacters(int charactersToInsert) {
        ITerminalTextData iTerminalTextData = this.fTerminal;
        synchronized (iTerminalTextData) {
            int line = this.toAbsoluteLine(this.fCursorLine);
            int n = charactersToInsert;
            int col = this.fColumns - 1;
            while (col >= this.fCursorColumn + n) {
                char c = this.fTerminal.getChar(line, col - n);
                TerminalStyle style = this.fTerminal.getStyle(line, col - n);
                this.fTerminal.setChar(line, col, c, style);
                --col;
            }
            int last = Math.min(this.fCursorColumn + n, this.fColumns);
            int col2 = this.fCursorColumn;
            while (col2 < last) {
                this.fTerminal.setChar(line, col2, '\u0000', null);
                ++col2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void eraseToEndOfScreen() {
        ITerminalTextData iTerminalTextData = this.fTerminal;
        synchronized (iTerminalTextData) {
            this.eraseLineToEnd();
            int line = this.toAbsoluteLine(this.fCursorLine + 1);
            while (line < this.toAbsoluteLine(this.fLines)) {
                this.fTerminal.cleanLine(line);
                ++line;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void eraseToCursor() {
        ITerminalTextData iTerminalTextData = this.fTerminal;
        synchronized (iTerminalTextData) {
            int line = this.toAbsoluteLine(0);
            while (line < this.toAbsoluteLine(this.fCursorLine)) {
                this.fTerminal.cleanLine(line);
                ++line;
            }
            this.eraseLineToCursor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void eraseAll() {
        ITerminalTextData iTerminalTextData = this.fTerminal;
        synchronized (iTerminalTextData) {
            int line = this.toAbsoluteLine(0);
            while (line < this.toAbsoluteLine(this.fLines)) {
                this.fTerminal.cleanLine(line);
                ++line;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void eraseLine() {
        ITerminalTextData iTerminalTextData = this.fTerminal;
        synchronized (iTerminalTextData) {
            this.fTerminal.cleanLine(this.toAbsoluteLine(this.fCursorLine));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void eraseLineToEnd() {
        ITerminalTextData iTerminalTextData = this.fTerminal;
        synchronized (iTerminalTextData) {
            int line = this.toAbsoluteLine(this.fCursorLine);
            int col = this.fCursorColumn;
            while (col < this.fColumns) {
                this.fTerminal.setChar(line, col, '\u0000', null);
                ++col;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void eraseLineToCursor() {
        ITerminalTextData iTerminalTextData = this.fTerminal;
        synchronized (iTerminalTextData) {
            int line = this.toAbsoluteLine(this.fCursorLine);
            int col = 0;
            while (col <= this.fCursorColumn) {
                this.fTerminal.setChar(line, col, '\u0000', null);
                ++col;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertLines(int n) {
        ITerminalTextData iTerminalTextData = this.fTerminal;
        synchronized (iTerminalTextData) {
            if (!this.isCusorInScrollingRegion()) {
                return;
            }
            assert (n > 0);
            int line = this.toAbsoluteLine(this.fCursorLine);
            int nLines = Math.min(this.fTerminal.getHeight() - line, this.fScrollRegion.getBottomLine() - this.fCursorLine + 1);
            this.fTerminal.scroll(line, nLines, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteCharacters(int n) {
        ITerminalTextData iTerminalTextData = this.fTerminal;
        synchronized (iTerminalTextData) {
            int first;
            int line = this.toAbsoluteLine(this.fCursorLine);
            int col = this.fCursorColumn + n;
            while (col < this.fColumns) {
                char c = this.fTerminal.getChar(line, col);
                TerminalStyle style = this.fTerminal.getStyle(line, col);
                this.fTerminal.setChar(line, col - n, c, style);
                ++col;
            }
            int col2 = first = Math.max(this.fCursorColumn, this.fColumns - n);
            while (col2 < this.fColumns) {
                this.fTerminal.setChar(line, col2, '\u0000', null);
                ++col2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteLines(int n) {
        ITerminalTextData iTerminalTextData = this.fTerminal;
        synchronized (iTerminalTextData) {
            if (!this.isCusorInScrollingRegion()) {
                return;
            }
            assert (n > 0);
            int line = this.toAbsoluteLine(this.fCursorLine);
            int nLines = Math.min(this.fTerminal.getHeight() - line, this.fScrollRegion.getBottomLine() - this.fCursorLine + 1);
            this.fTerminal.scroll(line, nLines, -n);
        }
    }

    private boolean isCusorInScrollingRegion() {
        return this.fScrollRegion.contains(this.fCursorLine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TerminalStyle getDefaultStyle() {
        ITerminalTextData iTerminalTextData = this.fTerminal;
        synchronized (iTerminalTextData) {
            return this.fDefaultStyle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDefaultStyle(TerminalStyle defaultStyle) {
        ITerminalTextData iTerminalTextData = this.fTerminal;
        synchronized (iTerminalTextData) {
            this.fDefaultStyle = defaultStyle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TerminalStyle getStyle() {
        ITerminalTextData iTerminalTextData = this.fTerminal;
        synchronized (iTerminalTextData) {
            if (this.fStyle == null) {
                return this.fDefaultStyle;
            }
            return this.fStyle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStyle(TerminalStyle style) {
        ITerminalTextData iTerminalTextData = this.fTerminal;
        synchronized (iTerminalTextData) {
            this.fStyle = style;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendString(String buffer) {
        ITerminalTextData iTerminalTextData = this.fTerminal;
        synchronized (iTerminalTextData) {
            char[] chars = buffer.toCharArray();
            if (this.fInsertMode) {
                this.insertCharacters(chars.length);
            }
            int line = this.toAbsoluteLine(this.fCursorLine);
            int i = 0;
            while (i < chars.length) {
                if (this.fWrapPending) {
                    line = this.doLineWrap();
                }
                int n = Math.min(this.fColumns - this.fCursorColumn, chars.length - i);
                this.fTerminal.setChars(line, this.fCursorColumn, chars, i, n, this.fStyle);
                int col = this.fCursorColumn + n;
                i += n;
                if (col == this.fColumns) {
                    if (this.fVT100LineWrapping) {
                        this.setCursorColumn(col - 1);
                        this.fWrapPending = true;
                        continue;
                    }
                    line = this.doLineWrap();
                    continue;
                }
                this.setCursorColumn(col);
            }
        }
    }

    private int doLineWrap() {
        int line = this.toAbsoluteLine(this.fCursorLine);
        this.fTerminal.setWrappedLine(line);
        this.doNewline();
        line = this.toAbsoluteLine(this.fCursorLine);
        this.setCursorColumn(0);
        return line;
    }

    private void doNewline() {
        if (this.fCursorLine == this.fScrollRegion.getBottomLine()) {
            this.scrollUp(1);
        } else if (this.fCursorLine + 1 >= this.fLines) {
            int h = this.fTerminal.getHeight();
            this.fTerminal.addLine();
            if (h != this.fTerminal.getHeight()) {
                this.setCursorLine(this.fCursorLine + 1);
            }
        } else {
            this.setCursorLine(this.fCursorLine + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processNewline() {
        ITerminalTextData iTerminalTextData = this.fTerminal;
        synchronized (iTerminalTextData) {
            this.doNewline();
        }
    }

    private void doReverseLineFeed() {
        if (this.fCursorLine == this.fScrollRegion.getTopLine()) {
            this.scrollDown(1);
        } else {
            this.setCursorLine(this.fCursorLine - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processReverseLineFeed() {
        ITerminalTextData iTerminalTextData = this.fTerminal;
        synchronized (iTerminalTextData) {
            this.doReverseLineFeed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCursorLine() {
        ITerminalTextData iTerminalTextData = this.fTerminal;
        synchronized (iTerminalTextData) {
            return this.fCursorLine;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCursorColumn() {
        ITerminalTextData iTerminalTextData = this.fTerminal;
        synchronized (iTerminalTextData) {
            return this.fCursorColumn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCursor(int targetLine, int targetColumn) {
        ITerminalTextData iTerminalTextData = this.fTerminal;
        synchronized (iTerminalTextData) {
            this.setCursorLine(targetLine);
            this.setCursorColumn(targetColumn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCursorColumn(int targetColumn) {
        ITerminalTextData iTerminalTextData = this.fTerminal;
        synchronized (iTerminalTextData) {
            if (targetColumn < 0) {
                targetColumn = 0;
            } else if (targetColumn >= this.fColumns) {
                targetColumn = this.fColumns - 1;
            }
            this.fCursorColumn = targetColumn;
            this.fWrapPending = false;
            this.fTerminal.setCursorColumn(targetColumn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCursorLine(int targetLine) {
        ITerminalTextData iTerminalTextData = this.fTerminal;
        synchronized (iTerminalTextData) {
            if (targetLine < 0) {
                targetLine = 0;
            } else if (targetLine >= this.fLines) {
                targetLine = this.fLines - 1;
            }
            this.fCursorLine = targetLine;
            this.fTerminal.setCursorLine(this.toAbsoluteLine(targetLine));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLines() {
        ITerminalTextData iTerminalTextData = this.fTerminal;
        synchronized (iTerminalTextData) {
            return this.fLines;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getColumns() {
        ITerminalTextData iTerminalTextData = this.fTerminal;
        synchronized (iTerminalTextData) {
            return this.fColumns;
        }
    }

    @Override
    public void setVT100LineWrapping(boolean enable) {
        this.fVT100LineWrapping = enable;
    }

    @Override
    public boolean isVT100LineWrapping() {
        return this.fVT100LineWrapping;
    }

    @Override
    public void setInsertMode(boolean enable) {
        this.fInsertMode = enable;
    }

    @Override
    public void setScrollRegion(int top, int bottom) {
        if (top < 0 || bottom < 0) {
            this.fScrollRegion = ScrollRegion.FULL_WINDOW;
        } else if (top < bottom) {
            this.fScrollRegion = new ScrollRegion(top, bottom);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scrollUp(int n) {
        assert (n > 0);
        ITerminalTextData iTerminalTextData = this.fTerminal;
        synchronized (iTerminalTextData) {
            int line = this.toAbsoluteLine(this.fScrollRegion.getTopLine());
            int nLines = Math.min(this.fTerminal.getHeight() - line, this.fScrollRegion.getHeight());
            this.fTerminal.scroll(line, nLines, -n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scrollDown(int n) {
        assert (n > 0);
        ITerminalTextData iTerminalTextData = this.fTerminal;
        synchronized (iTerminalTextData) {
            int line = this.toAbsoluteLine(this.fScrollRegion.getTopLine());
            int nLines = Math.min(this.fTerminal.getHeight() - line, this.fScrollRegion.getHeight());
            this.fTerminal.scroll(line, nLines, n);
        }
    }

    private static class ScrollRegion {
        static final ScrollRegion FULL_WINDOW = new ScrollRegion(0, 0x7FFFFFFE);
        private final int fTop;
        private final int fBottom;

        ScrollRegion(int top, int bottom) {
            this.fTop = top;
            this.fBottom = bottom;
        }

        boolean contains(int line) {
            return line >= this.fTop && line <= this.fBottom;
        }

        int getTopLine() {
            return this.fTop;
        }

        int getBottomLine() {
            return this.fBottom;
        }

        int getHeight() {
            return this.fBottom - this.fTop + 1;
        }
    }
}

