/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.forms.parts;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.tcf.te.ui.forms.FormLayoutFactory;
import org.eclipse.tcf.te.ui.forms.parts.AbstractSection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;

public abstract class AbstractFormTextSection
extends AbstractSection
implements IHyperlinkListener {
    public AbstractFormTextSection(IManagedForm form, Composite parent, int style) {
        this(form, parent, style, true);
    }

    public AbstractFormTextSection(IManagedForm form, Composite parent, int style, boolean titleBar) {
        super(form, parent, style, titleBar);
        this.getSection().setLayout((Layout)FormLayoutFactory.createClearTableWrapLayout(false, 1));
    }

    @Override
    protected void createClient(Section section, FormToolkit toolkit) {
        Assert.isNotNull((Object)section);
        Assert.isNotNull((Object)toolkit);
        section.setText(this.getSectionTitle());
        if (section.getParent().getLayout() instanceof GridLayout) {
            section.setLayoutData((Object)new GridData(4, 4, true, true));
        }
        Composite client = toolkit.createComposite((Composite)section, 0);
        Assert.isNotNull((Object)client);
        client.setLayout((Layout)FormLayoutFactory.createSectionClientTableWrapLayout(false, 1));
        client.setLayoutData((Object)new TableWrapData(256));
        FormText text = this.createFormText(client, toolkit);
        this.configureFormText(text);
        section.setClient((Control)client);
        this.setIsUpdating(false);
    }

    protected abstract String getSectionTitle();

    protected abstract String getFormTextContent();

    protected final FormText createFormText(Composite parent, FormToolkit toolkit) {
        Assert.isNotNull((Object)parent);
        Assert.isNotNull((Object)toolkit);
        return toolkit.createFormText(parent, true);
    }

    protected void configureFormText(FormText text) {
        Assert.isNotNull((Object)text);
        try {
            text.setText(this.getFormTextContent(), true, false);
        }
        catch (SWTException e) {
            text.setText(e.getMessage(), false, false);
        }
        text.addHyperlinkListener((IHyperlinkListener)this);
    }

    public void linkEntered(HyperlinkEvent e) {
        Object container = this.getManagedForm().getContainer();
        if (container instanceof IEditorPart) {
            IStatusLineManager manager = ((IEditorPart)container).getEditorSite().getActionBars().getStatusLineManager();
            manager.setMessage(e.getLabel());
        }
    }

    public void linkExited(HyperlinkEvent e) {
        Object container = this.getManagedForm().getContainer();
        if (container instanceof IEditorPart) {
            IStatusLineManager manager = ((IEditorPart)container).getEditorSite().getActionBars().getStatusLineManager();
            manager.setMessage(null);
        }
    }

    public void linkActivated(HyperlinkEvent e) {
    }
}

