/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.processes.ui.navigator.events;

import java.util.EventObject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.events.ChangeEvent;
import org.eclipse.tcf.te.runtime.events.EventManager;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.model.PendingOperationModelNode;
import org.eclipse.tcf.te.runtime.model.interfaces.IContainerModelNode;
import org.eclipse.tcf.te.runtime.model.interfaces.IModelNode;
import org.eclipse.tcf.te.runtime.model.interfaces.contexts.IAsyncRefreshableCtx;
import org.eclipse.tcf.te.tcf.core.model.interfaces.IModel;
import org.eclipse.tcf.te.tcf.core.model.interfaces.services.IModelRefreshService;
import org.eclipse.tcf.te.tcf.processes.core.model.interfaces.IProcessContextNode;
import org.eclipse.tcf.te.tcf.processes.core.model.nodes.PendingOperationNode;

public class TreeViewerListener
implements ITreeViewerListener {
    public void treeCollapsed(TreeExpansionEvent event) {
    }

    public void treeExpanded(TreeExpansionEvent event) {
        Object element = event.getElement();
        if (element instanceof IProcessContextNode) {
            final IProcessContextNode node = (IProcessContextNode)element;
            boolean needsRefresh = false;
            final IAsyncRefreshableCtx refreshable = (IAsyncRefreshableCtx)node.getAdapter(IAsyncRefreshableCtx.class);
            Assert.isNotNull((Object)refreshable);
            if (refreshable.getQueryState(IAsyncRefreshableCtx.QueryType.CHILD_LIST).equals((Object)IAsyncRefreshableCtx.QueryState.PENDING)) {
                needsRefresh = true;
            } else if (refreshable.getQueryState(IAsyncRefreshableCtx.QueryType.CHILD_LIST).equals((Object)IAsyncRefreshableCtx.QueryState.DONE)) {
                for (IProcessContextNode candidate : node.getChildren(IProcessContextNode.class)) {
                    IAsyncRefreshableCtx r = (IAsyncRefreshableCtx)candidate.getAdapter(IAsyncRefreshableCtx.class);
                    Assert.isNotNull((Object)r);
                    if (!r.getQueryState(IAsyncRefreshableCtx.QueryType.CHILD_LIST).equals((Object)IAsyncRefreshableCtx.QueryState.PENDING)) continue;
                    needsRefresh = true;
                    break;
                }
            }
            if (needsRefresh) {
                refreshable.setQueryState(IAsyncRefreshableCtx.QueryType.CHILD_LIST, IAsyncRefreshableCtx.QueryState.IN_PROGRESS);
                PendingOperationNode pendingNode = new PendingOperationNode();
                pendingNode.setParent((IContainerModelNode)node);
                refreshable.setPendingOperationNode((PendingOperationModelNode)pendingNode);
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        ChangeEvent ev = new ChangeEvent((Object)node, (Object)"changed", null, null);
                        EventManager.getInstance().fireEvent((EventObject)ev);
                        IModel model = (IModel)node.getParent(IModel.class);
                        Assert.isNotNull((Object)model);
                        final boolean changed = node.setChangeEventsEnabled(false);
                        ((IModelRefreshService)model.getService(IModelRefreshService.class)).refresh((IModelNode)node, (ICallback)new Callback(){

                            protected void internalDone(Object caller, IStatus status) {
                                refreshable.setQueryState(IAsyncRefreshableCtx.QueryType.CHILD_LIST, IAsyncRefreshableCtx.QueryState.DONE);
                                refreshable.setPendingOperationNode(null);
                                if (changed) {
                                    node.setChangeEventsEnabled(true);
                                }
                                ChangeEvent event = new ChangeEvent((Object)node, (Object)"changed", null, null);
                                EventManager.getInstance().fireEvent((EventObject)event);
                            }
                        });
                    }
                };
                Protocol.invokeLater((Runnable)runnable);
            }
        }
    }
}

