/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.launch.ui.editor;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.properties.PropertiesContainer;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.runtime.statushandler.StatusHandlerManager;
import org.eclipse.tcf.te.runtime.statushandler.interfaces.IStatusHandler;
import org.eclipse.tcf.te.tcf.core.interfaces.IPathMapService;
import org.eclipse.tcf.te.tcf.launch.ui.activator.UIPlugin;
import org.eclipse.tcf.te.tcf.launch.ui.editor.AbstractTcfLaunchTabContainerEditorPage;
import org.eclipse.tcf.te.tcf.launch.ui.editor.tabs.PathMapTab;
import org.eclipse.tcf.te.tcf.launch.ui.help.IContextHelpIds;
import org.eclipse.tcf.te.tcf.launch.ui.nls.Messages;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;

public class PathMapEditorPage
extends AbstractTcfLaunchTabContainerEditorPage {
    protected AbstractLaunchConfigurationTab createLaunchConfigurationTab() {
        return new PathMapTab(this);
    }

    @Override
    protected void onPostSave(ILaunchConfiguration config) {
        IPathMapService service;
        Assert.isNotNull((Object)config);
        final IPeerNode peerNode = this.getPeerModel(this.getEditorInput());
        if (peerNode != null && peerNode.getPeer() != null && (service = (IPathMapService)ServiceManager.getInstance().getService((Object)peerNode.getPeer(), IPathMapService.class)) != null) {
            service.applyPathMap((Object)peerNode.getPeer(), false, true, (ICallback)new Callback(){

                protected void internalDone(Object caller, IStatus status) {
                    if (status != null && status.getSeverity() == 4) {
                        Status status2 = new Status(4, UIPlugin.getUniqueIdentifier(), NLS.bind((String)Messages.PathMapEditorPage_error_apply, (Object)peerNode.getName(), (Object)status.getMessage()), status.getException());
                        IStatusHandler[] handlers = StatusHandlerManager.getInstance().getHandler((Object)peerNode);
                        if (handlers.length > 0) {
                            PropertiesContainer data = new PropertiesContainer();
                            data.setProperty("title", (Object)Messages.PathMapEditorPage_error_title);
                            data.setProperty("contextHelpId", (Object)IContextHelpIds.MESSAGE_APPLY_PATHMAP_FAILED);
                            data.setProperty("caller", (Object)this);
                            handlers[0].handleStatus((IStatus)status2, (IPropertiesContainer)data, null);
                        } else {
                            UIPlugin.getDefault().getLog().log((IStatus)status2);
                        }
                    }
                }
            });
        }
    }
}

