/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.core.internal.operations;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.IConfirmCallback;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.runtime.IFSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.FSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.OpCopyBase;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.utils.StatusHelper;
import org.eclipse.tcf.te.tcf.filesystem.core.nls.Messages;

public class OpCopyLocal
extends OpCopyBase<File> {
    private static final boolean IGNORE_CASE = new File("a").equals(new File("A"));
    private static final File[] NO_FILES = new File[0];
    private final Map<File, File[]> fChildrenCache = new HashMap<File, File[]>();

    public OpCopyLocal(List<? extends IFSTreeNode> nodes, File dest, IConfirmCallback confirmCallback) {
        super(nodes, dest, confirmCallback);
    }

    @Override
    protected File findChild(File destination, String name) {
        File[] fileArray = this.getChildren(destination);
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File child = fileArray[n2];
            String childName = child.getName();
            if (IGNORE_CASE ? childName.equalsIgnoreCase(name) : childName.equals(name)) {
                return child;
            }
            ++n2;
        }
        return null;
    }

    private File[] getChildren(File destination) {
        File[] result = this.fChildrenCache.get(destination);
        if (result == null) {
            result = destination.listFiles();
            if (result == null) {
                result = NO_FILES;
            }
            this.fChildrenCache.put(destination, result);
        }
        return result;
    }

    @Override
    protected void notifyChange(File destination) {
    }

    @Override
    protected IStatus refreshDestination(File destination, long startTime, IProgressMonitor monitor) {
        return Status.OK_STATUS;
    }

    @Override
    protected boolean isDirectory(File node) {
        return node.isDirectory();
    }

    @Override
    protected boolean isFile(File node) {
        return node.isFile();
    }

    @Override
    protected String getLocation(File node) {
        return node.getAbsolutePath();
    }

    @Override
    protected IStatus performCopy(FSTreeNode source, File destination, String newName, File existing, IProgressMonitor monitor) {
        monitor.subTask(NLS.bind((String)Messages.OpCopy_Copying, (Object)source.getLocation()));
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        if (source.isFile()) {
            return this.copyFile(source, destination, newName, (IProgressMonitor)new SubProgressMonitor(monitor, 0));
        }
        if (source.isDirectory()) {
            return this.copyFolder(source, destination, newName);
        }
        return Status.OK_STATUS;
    }

    private IStatus copyFolder(FSTreeNode source, File dest, String newName) {
        File newFolder = new File(dest, newName);
        if (!newFolder.mkdir()) {
            return StatusHelper.createStatus(MessageFormat.format(Messages.Operation_CannotCreateDirectory, newName), null);
        }
        this.fChildrenCache.remove(dest);
        this.addWorkItem(source.getChildren(), newFolder);
        return Status.OK_STATUS;
    }

    private IStatus copyFile(FSTreeNode source, File dest, String newName, IProgressMonitor monitor) {
        BufferedOutputStream output;
        File fileDest = new File(dest, newName);
        this.fChildrenCache.remove(dest);
        try {
            output = new BufferedOutputStream(new FileOutputStream(fileDest));
        }
        catch (FileNotFoundException e) {
            return StatusHelper.createStatus(MessageFormat.format(Messages.OpCopy_CannotCopyFile, newName), e);
        }
        IStatus result = source.operationDownload(output).run(monitor);
        try {
            ((OutputStream)output).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    @Override
    public String getName() {
        return Messages.OpCopy_DownloadingFile;
    }
}

