/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.launch.ui.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.tcf.te.launch.core.lm.LaunchConfigHelper;
import org.eclipse.tcf.te.launch.core.lm.LaunchManager;
import org.eclipse.tcf.te.launch.core.lm.interfaces.ILaunchManagerDelegate;
import org.eclipse.tcf.te.launch.ui.model.LaunchModel;
import org.eclipse.tcf.te.runtime.model.ContainerModelNode;
import org.eclipse.tcf.te.runtime.model.interfaces.IContainerModelNode;

public class LaunchNode
extends ContainerModelNode {
    public static final String TYPE_ROOT = "root";
    public static final String TYPE_LAUNCH_CONFIG_TYPE = "launchConfigType";
    public static final String TYPE_LAUNCH_CONFIG = "launchConfig";
    protected static final String PROPERTY_LAUNCH_CONFIG_TYPE = "launchConfigType";
    protected static final String PROPERTY_LAUNCH_CONFIG = "launchConfig";
    protected static final String PROPERTY_MODEL = "model";

    private LaunchNode(String type) {
        this.setProperty("type", type);
    }

    public LaunchNode(LaunchModel model) {
        this(TYPE_ROOT);
        this.setProperty(PROPERTY_MODEL, model);
    }

    public LaunchNode(ILaunchConfiguration config) {
        this("launchConfig");
        this.setProperty("launchConfig", config);
    }

    public LaunchNode(ILaunchConfigurationType configType) {
        this("launchConfigType");
        this.setProperty("launchConfigType", configType);
    }

    public boolean isType(String type) {
        return type.equals(this.getStringProperty("type"));
    }

    public LaunchModel getModel() {
        LaunchModel model = (LaunchModel)this.getProperty(PROPERTY_MODEL);
        IContainerModelNode parent = this.getParent();
        while (model == null && parent != null) {
            model = (LaunchModel)parent.getProperty(PROPERTY_MODEL);
            parent = parent.getParent();
        }
        Assert.isNotNull((Object)model);
        return model;
    }

    public ILaunchConfiguration getLaunchConfiguration() {
        return (ILaunchConfiguration)this.getProperty("launchConfig");
    }

    public ILaunchConfigurationType getLaunchConfigurationType() {
        if (this.getLaunchConfiguration() != null) {
            try {
                return this.getLaunchConfiguration().getType();
            }
            catch (Exception exception) {
            }
        } else if (this.isType("launchConfig")) {
            return ((LaunchNode)this.getParent()).getLaunchConfigurationType();
        }
        return (ILaunchConfigurationType)this.getProperty("launchConfigType");
    }

    public String getName() {
        if (this.isType(TYPE_ROOT)) {
            return "Launches";
        }
        if (this.isType("launchConfigType")) {
            return this.getLaunchConfigurationType().getName();
        }
        if (this.isType("launchConfig")) {
            return this.getLaunchConfiguration().getName();
        }
        return super.getName();
    }

    public int hashCode() {
        if (this.isType("launchConfigType") && this.getLaunchConfigurationType() != null) {
            return this.getLaunchConfigurationType().hashCode();
        }
        if (this.isType("launchConfig") && this.getLaunchConfiguration() != null) {
            return this.getLaunchConfiguration().hashCode();
        }
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof LaunchNode && this.isType(((LaunchNode)((Object)obj)).getStringProperty("type")) && this.getModel().getModelRoot().equals(((LaunchNode)((Object)obj)).getModel().getModelRoot())) {
            if (this.isType("launchConfigType")) {
                return this.getLaunchConfigurationType().equals(((LaunchNode)((Object)obj)).getLaunchConfigurationType());
            }
            if (this.isType("launchConfig")) {
                return this.getLaunchConfiguration().equals(((LaunchNode)((Object)obj)).getLaunchConfiguration());
            }
        }
        return super.equals(obj);
    }

    public boolean isValidFor(String mode) {
        if (this.isType("launchConfig")) {
            List<String> modes;
            if (this.getLaunchConfigurationType() == null) {
                return false;
            }
            if (mode != null && mode.trim().length() > 0) {
                modes = new ArrayList<String>();
                modes.add(mode);
            } else {
                modes = Arrays.asList(LaunchConfigHelper.getLaunchConfigTypeModes((ILaunchConfigurationType)this.getLaunchConfigurationType(), (boolean)false));
            }
            for (String m : modes) {
                if (!this.getLaunchConfigurationType().supportsMode(m)) {
                    return false;
                }
                ILaunchManagerDelegate delegate = LaunchManager.getInstance().getLaunchManagerDelegate(this.getLaunchConfigurationType(), m);
                if (delegate == null) continue;
                try {
                    delegate.validate(mode, this.getLaunchConfiguration());
                }
                catch (Exception e) {
                    return false;
                }
            }
        }
        return true;
    }
}

