/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.launch.core.persistence.launchcontext;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.tcf.te.launch.core.lm.interfaces.ILaunchSpecification;
import org.eclipse.tcf.te.launch.core.persistence.AbstractItemListPersistenceDelegate;
import org.eclipse.tcf.te.launch.core.persistence.AbstractItemListXMLParser;
import org.eclipse.tcf.te.runtime.model.interfaces.IModelNode;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.runtime.services.interfaces.IPropertiesAccessService;

public class LaunchContextsPersistenceDelegate {
    private static final Map<String, List<IModelNode>> readCache = new LinkedHashMap<String, List<IModelNode>>();
    private static final Map<String, String> writeCache = new LinkedHashMap<String, String>();
    private static final int READ_CACHE_MAX_CAPACITY = 25;
    private static final int WRITE_CACHE_MAX_CAPACITY = 25;
    private static final String TAG_LAUNCH_CONTEXT = "context";
    private static final AbstractItemListPersistenceDelegate<IModelNode> delegate = new AbstractItemListPersistenceDelegate<IModelNode>("context", "org.eclipse.tcf.te.launch.launch_contexts"){

        @Override
        protected AbstractItemListXMLParser<IModelNode> getXMLParser() {
            return new AbstractItemListXMLParser<IModelNode>(LaunchContextsPersistenceDelegate.TAG_LAUNCH_CONTEXT){

                @Override
                protected Class<?> getReadClass() {
                    return IModelNode.class;
                }
            };
        }
    };

    public static final void setLaunchContexts(ILaunchConfigurationWorkingCopy wc, IModelNode[] contexts) {
        delegate.setItems(wc, (IModelNode[])contexts);
    }

    public static final void setLaunchContexts(ILaunchSpecification launchSpec, IModelNode[] contexts) {
        delegate.setItems(launchSpec, (IModelNode[])contexts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String encodeLaunchContexts(IModelNode[] contexts) {
        Assert.isNotNull((Object)contexts);
        String result = null;
        String writeCacheKey = LaunchContextsPersistenceDelegate.makeWriteCacheKey(contexts);
        Map<String, String> map = writeCache;
        synchronized (map) {
            if (writeCache.containsKey(writeCacheKey)) {
                result = writeCache.get(writeCacheKey);
            }
        }
        if (result == null) {
            result = delegate.encodeItems((IModelNode[])contexts);
            map = writeCache;
            synchronized (map) {
                LaunchContextsPersistenceDelegate.checkCacheCapacity(writeCache, 25);
                writeCache.put(writeCacheKey, result);
            }
        }
        return result;
    }

    private static String makeWriteCacheKey(IModelNode[] contexts) {
        Assert.isNotNull((Object)contexts);
        StringBuffer key = new StringBuffer();
        IModelNode[] iModelNodeArray = contexts;
        int n = contexts.length;
        int n2 = 0;
        while (n2 < n) {
            IModelNode context = iModelNodeArray[n2];
            key.append(Integer.toHexString(context.hashCode()));
            key.append(':');
            ++n2;
        }
        if (key.charAt(key.length() - 1) == ':') {
            key.setCharAt(key.length() - 1, ' ');
        }
        return key.toString().trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final IModelNode[] decodeLaunchContexts(String encodedContexts) {
        Assert.isNotNull((Object)encodedContexts);
        List<IModelNode> contexts = null;
        if (!"".equals(encodedContexts.trim())) {
            Map<String, List<IModelNode>> map = readCache;
            synchronized (map) {
                if (readCache.containsKey(encodedContexts)) {
                    contexts = readCache.get(encodedContexts);
                    ListIterator<IModelNode> iterator = contexts.listIterator();
                    while (iterator.hasNext()) {
                        Object value;
                        IModelNode node = iterator.next();
                        IPropertiesAccessService service = (IPropertiesAccessService)ServiceManager.getInstance().getService((Object)node, IPropertiesAccessService.class);
                        boolean isGhost = false;
                        if (service != null && (value = service.getProperty((Object)node, "isghost")) instanceof Boolean) {
                            isGhost = (Boolean)value;
                        }
                        if (!isGhost) continue;
                        contexts = null;
                        readCache.remove(encodedContexts);
                        break;
                    }
                    if (contexts != null && contexts.isEmpty()) {
                        readCache.remove(encodedContexts);
                        contexts = null;
                    }
                }
            }
            if ((contexts == null || contexts.isEmpty()) && !(contexts = delegate.decodeItems(encodedContexts)).isEmpty()) {
                map = readCache;
                synchronized (map) {
                    LaunchContextsPersistenceDelegate.checkCacheCapacity(readCache, 25);
                    readCache.put(encodedContexts, contexts);
                }
            }
        }
        return contexts != null ? contexts.toArray(new IModelNode[contexts.size()]) : new IModelNode[]{};
    }

    private static final void checkCacheCapacity(Map<String, ?> cache, int maxCapacity) {
        String[] keys;
        if (cache.size() < maxCapacity) {
            return;
        }
        String[] stringArray = keys = cache.keySet().toArray(new String[cache.keySet().size()]);
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            cache.remove(key);
            if (cache.size() < maxCapacity / 2) break;
            ++n2;
        }
    }

    public static final IModelNode[] getLaunchContexts(ILaunchConfiguration configuration) {
        List<IModelNode> list = delegate.getItems(configuration);
        return list.toArray(new IModelNode[list.size()]);
    }

    public static final IModelNode[] getLaunchContexts(ILaunchSpecification launchSpec) {
        List<IModelNode> list = delegate.getItems(launchSpec);
        return list.toArray(new IModelNode[list.size()]);
    }

    public static final IModelNode getFirstLaunchContext(ILaunchConfiguration configuration) {
        List<IModelNode> list = delegate.getItems(configuration);
        return list != null && !list.isEmpty() ? list.get(0) : null;
    }
}

