/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tools.api.command.view;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerInterpreter;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.tools.api.interpreter.InterpreterUtil;
import org.eclipse.sirius.tools.api.ui.IExternalJavaAction;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.Messages;
import org.eclipse.sirius.viewpoint.description.tool.ExternalJavaAction;
import org.eclipse.sirius.viewpoint.description.tool.ExternalJavaActionParameter;
import org.eclipse.sirius.viewpoint.description.tool.ToolPackage;

public final class JavaActionFromToolCommand
extends RecordingCommand {
    private final IExternalJavaAction action;
    private final ExternalJavaAction tool;
    private final Collection<DSemanticDecorator> containerViews;

    public JavaActionFromToolCommand(TransactionalEditingDomain domain, IExternalJavaAction javaAction, ExternalJavaAction tool, Collection<DSemanticDecorator> containerViews) {
        super(domain, MessageFormat.format(Messages.JavaActionFromToolCommand_label, javaAction != null ? javaAction.getClass().getSimpleName() : ""));
        this.action = javaAction;
        this.tool = tool;
        this.containerViews = containerViews;
    }

    public void doExecute() {
        if (this.action == null || this.tool == null || this.containerViews == null) {
            return;
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        IInterpreter interpreter = InterpreterUtil.getInterpreter(this.containerViews.iterator().next().getTarget());
        RuntimeLoggerInterpreter safeInterpreter = RuntimeLoggerManager.INSTANCE.decorate(interpreter);
        for (ExternalJavaActionParameter parameter : this.tool.getParameters()) {
            Object value = null;
            if (this.containerViews.size() == 1) {
                value = safeInterpreter.evaluate(this.containerViews.iterator().next(), parameter, (EStructuralFeature)ToolPackage.eINSTANCE.getExternalJavaActionParameter_Value());
            } else {
                value = new ArrayList(this.containerViews.size());
                for (DSemanticDecorator semanticDecorator : this.containerViews) {
                    Object val = safeInterpreter.evaluate(semanticDecorator, parameter, (EStructuralFeature)ToolPackage.eINSTANCE.getExternalJavaActionParameter_Value());
                    if (val == null) continue;
                    ((List)value).add(val);
                }
            }
            parameters.put(parameter.getName(), value);
        }
        this.action.execute(this.containerViews, parameters);
    }

    public boolean canExecute() {
        return this.action != null && this.action.canExecute(this.containerViews);
    }
}

