/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.api.query;

import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DView;

public final class DViewQuery {
    private static boolean activateTrace = Boolean.parseBoolean(System.getProperty("activate_trace_getLoadedRepresentations", Boolean.FALSE.toString()));
    private DView dView;

    public DViewQuery(DView dView) {
        this.dView = dView;
    }

    public List<DRepresentation> getLoadedRepresentations() {
        if (activateTrace) {
            Thread.dumpStack();
        }
        List representations = this.dView.getOwnedRepresentationDescriptors().stream().filter(DRepresentationDescriptor::isLoadedRepresentation).map(DRepresentationDescriptor::getRepresentation).collect(Collectors.toList());
        return Collections.unmodifiableList(representations);
    }

    public List<DRepresentationDescriptor> getLoadedRepresentationsDescriptors() {
        if (activateTrace) {
            Thread.dumpStack();
        }
        List representationDescriptors = this.dView.getOwnedRepresentationDescriptors().stream().filter(DRepresentationDescriptor::isLoadedRepresentation).collect(Collectors.toList());
        return Collections.unmodifiableList(representationDescriptors);
    }

    public Iterator<EObject> getAllContentInRepresentations(Predicate<? super EObject> predicate) {
        Iterator iterator = Collections.emptyIterator();
        List<DRepresentation> allRepresentations = this.getLoadedRepresentations();
        for (DRepresentation dRepresentation : allRepresentations) {
            UnmodifiableIterator currentIterator = Iterators.filter((Iterator)dRepresentation.eAllContents(), t -> predicate.test((EObject)t));
            iterator = Iterators.concat(iterator, (Iterator)currentIterator);
        }
        return iterator;
    }
}

