/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.views.common.action;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.text.MessageFormat;
import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.ecore.extender.business.api.permission.PermissionAuthorityRegistry;
import org.eclipse.sirius.ui.tools.internal.wizards.ExtractRepresentationsWizard;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ExtractRepresentationAction
extends Action {
    private final Session session;
    private final Collection<DRepresentationDescriptor> repDescriptors;

    public ExtractRepresentationAction(Session session, Collection<DRepresentationDescriptor> selection) {
        this.session = session;
        this.repDescriptors = selection;
        ImageDescriptor descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sirius.ui", (String)"/icons/full/others/export.gif");
        this.setImageDescriptor(descriptor);
        this.setText(MessageFormat.format(Messages.ExtractRepresentationAction_label, "aird"));
        if (!this.isValidSelection()) {
            this.setEnabled(false);
        }
    }

    public void run() {
        TransactionalEditingDomain transDomain = this.session.getTransactionalEditingDomain();
        ExtractRepresentationsWizard wizard = new ExtractRepresentationsWizard(this.session, transDomain, this.repDescriptors);
        Shell defaultShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        WizardDialog dialog = new WizardDialog(defaultShell, (IWizard)wizard);
        dialog.create();
        dialog.getShell().setText(Messages.ExtractRepresentationAction_dialogTitle);
        dialog.open();
    }

    private boolean isValidSelection() {
        boolean anyInvalidExtract = Iterables.any(this.repDescriptors, (Predicate)new Predicate<DRepresentationDescriptor>(){

            public boolean apply(DRepresentationDescriptor input) {
                IPermissionAuthority permissionAuthority;
                EObject container = input.eContainer();
                return container instanceof DView && (permissionAuthority = PermissionAuthorityRegistry.getDefault().getPermissionAuthority(container)) != null && !permissionAuthority.canDeleteInstance((EObject)input);
            }
        });
        return !anyInvalidExtract;
    }
}

