/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tree.business.internal.dialect.common.tree;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.synchronizer.IntegerProvider;
import org.eclipse.sirius.synchronizer.Mapping;
import org.eclipse.sirius.synchronizer.MappingHiearchyTable;
import org.eclipse.sirius.synchronizer.OutputDescriptor;
import org.eclipse.sirius.synchronizer.Signature;
import org.eclipse.sirius.synchronizer.SignatureProvider;
import org.eclipse.sirius.synchronizer.StringSignature;
import org.eclipse.sirius.tree.business.internal.dialect.common.tree.OutputDTreeDescriptor;
import org.eclipse.sirius.tree.business.internal.dialect.common.tree.OutputTreeItemDescriptor;
import org.eclipse.sirius.tree.tools.internal.Messages;

class TreeSignatureProvider
implements SignatureProvider {
    private Map<String, Signature> allSignatures = new HashMap<String, Signature>();
    private MappingHiearchyTable hierarchyTable;

    TreeSignatureProvider(MappingHiearchyTable hierarchyTable) {
        this.hierarchyTable = hierarchyTable;
    }

    public Signature getSignature(OutputDescriptor descriptor) {
        if (descriptor instanceof OutputTreeItemDescriptor) {
            return this.doGetSignature((OutputTreeItemDescriptor)descriptor);
        }
        if (descriptor instanceof OutputDTreeDescriptor) {
            return this.doGetSignature((OutputDTreeDescriptor)descriptor);
        }
        throw new RuntimeException(MessageFormat.format(Messages.DTreeRefresh_unknownDescriptor, descriptor));
    }

    private Signature doGetSignature(OutputDTreeDescriptor desc) {
        return this.getOrCreate("tree " + this.getURI(desc.getSourceElement()) + desc.getMapping().toString());
    }

    private Signature getOrCreate(String string) {
        Signature existing = this.allSignatures.get(string);
        if (existing == null) {
            existing = new StringSignature(string);
            this.allSignatures.put(string, existing);
        }
        return existing;
    }

    private String getURI(EObject sourceElement) {
        return EcoreUtil.getURI((EObject)sourceElement).toString();
    }

    private Signature doGetSignature(OutputTreeItemDescriptor desc) {
        String sourceID = desc.getSourceElement() == null ? String.valueOf(desc.hashCode()) : IntegerProvider.getInteger((EObject)desc.getSourceElement()).toString();
        String containerID = IntegerProvider.getInteger((EObject)desc.getViewContainer()).toString();
        Collection hierarchy = this.hierarchyTable.getHierarchy((Mapping)desc.getMapping());
        return this.getOrCreate(hierarchy + sourceID + containerID);
    }
}

