/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.ui.tools.internal.paperclips;

import org.eclipse.sirius.table.ui.tools.internal.paperclips.BackgroundPiece;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.BackgroundPrint;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.PaperClips;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.PrintIterator;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.PrintPiece;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.internal.util.Util;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;

class BackgroundIterator
implements PrintIterator {
    private final PrintIterator target;
    private final RGB background;
    private final Device device;

    BackgroundIterator(BackgroundPrint print, Device device, GC gc) {
        Util.notNull(print, device, gc);
        this.device = device;
        this.target = print.target.iterator(device, gc);
        this.background = print.background;
    }

    BackgroundIterator(BackgroundIterator that) {
        this.target = that.target.copy();
        this.background = that.background;
        this.device = that.device;
    }

    @Override
    public Point minimumSize() {
        return this.target.minimumSize();
    }

    @Override
    public Point preferredSize() {
        return this.target.preferredSize();
    }

    @Override
    public boolean hasNext() {
        return this.target.hasNext();
    }

    @Override
    public PrintPiece next(int width, int height) {
        PrintPiece targetPiece = PaperClips.next(this.target, width, height);
        if (targetPiece == null) {
            return null;
        }
        return new BackgroundPiece(targetPiece, this.background, this.device);
    }

    @Override
    public PrintIterator copy() {
        return new BackgroundIterator(this);
    }
}

