/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.ui.tools.internal.editor;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.FocusCellOwnerDrawHighlighter;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.TreeViewerEditor;
import org.eclipse.jface.viewers.TreeViewerFocusCellManager;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.table.business.api.helper.TableHelper;
import org.eclipse.sirius.table.metamodel.table.DColumn;
import org.eclipse.sirius.table.metamodel.table.DFeatureColumn;
import org.eclipse.sirius.table.metamodel.table.DLine;
import org.eclipse.sirius.table.metamodel.table.DTable;
import org.eclipse.sirius.table.metamodel.table.DTargetColumn;
import org.eclipse.sirius.table.metamodel.table.description.CreateTool;
import org.eclipse.sirius.table.metamodel.table.description.CrossTableDescription;
import org.eclipse.sirius.table.metamodel.table.description.DeleteColumnTool;
import org.eclipse.sirius.table.metamodel.table.description.DeleteTool;
import org.eclipse.sirius.table.metamodel.table.description.ElementColumnMapping;
import org.eclipse.sirius.table.metamodel.table.description.LineMapping;
import org.eclipse.sirius.table.metamodel.table.description.TableDescription;
import org.eclipse.sirius.table.metamodel.table.description.TableMapping;
import org.eclipse.sirius.table.metamodel.table.provider.TableUIPlugin;
import org.eclipse.sirius.table.tools.api.command.ITableCommandFactory;
import org.eclipse.sirius.table.ui.tools.internal.editor.AbstractDTableEditor;
import org.eclipse.sirius.table.ui.tools.internal.editor.DLinesSorter;
import org.eclipse.sirius.table.ui.tools.internal.editor.DTableEraseItemListener;
import org.eclipse.sirius.table.ui.tools.internal.editor.DTableMenuListener;
import org.eclipse.sirius.table.ui.tools.internal.editor.DTableTreeViewer;
import org.eclipse.sirius.table.ui.tools.internal.editor.action.AbstractToolAction;
import org.eclipse.sirius.table.ui.tools.internal.editor.action.CreateLineAction;
import org.eclipse.sirius.table.ui.tools.internal.editor.action.CreateTargetColumnAction;
import org.eclipse.sirius.table.ui.tools.internal.editor.action.DeleteLinesAction;
import org.eclipse.sirius.table.ui.tools.internal.editor.action.DeleteTargetColumnAction;
import org.eclipse.sirius.table.ui.tools.internal.editor.action.EditorCreateLineMenuAction;
import org.eclipse.sirius.table.ui.tools.internal.editor.action.EditorCreateTargetColumnMenuAction;
import org.eclipse.sirius.table.ui.tools.internal.editor.listeners.DTableViewerListener;
import org.eclipse.sirius.table.ui.tools.internal.editor.provider.DFeatureColumnEditingSupport;
import org.eclipse.sirius.table.ui.tools.internal.editor.provider.DTableColumnHeaderLabelProvider;
import org.eclipse.sirius.table.ui.tools.internal.editor.provider.DTableContentProvider;
import org.eclipse.sirius.table.ui.tools.internal.editor.provider.DTableDecoratingLabelProvider;
import org.eclipse.sirius.table.ui.tools.internal.editor.provider.DTableLineLabelProvider;
import org.eclipse.sirius.table.ui.tools.internal.editor.provider.DTargetColumnEditingSupport;
import org.eclipse.sirius.table.ui.tools.internal.editor.provider.TableUIUpdater;
import org.eclipse.sirius.tools.api.command.ICommandFactory;
import org.eclipse.sirius.tools.api.profiler.SiriusTasksKey;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.sirius.ui.tools.internal.editor.AbstractDTableViewerManager;
import org.eclipse.sirius.ui.tools.internal.editor.AbstractDTreeEditor;
import org.eclipse.sirius.ui.tools.internal.editor.AbstractDTreeViewer;
import org.eclipse.sirius.ui.tools.internal.editor.DTableColumnViewerEditorActivationStrategy;
import org.eclipse.sirius.ui.tools.internal.editor.DTableTreeFocusListener;
import org.eclipse.sirius.ui.tools.internal.editor.DescriptionFileChangedNotifier;
import org.eclipse.sirius.ui.tools.internal.editor.SelectDRepresentationElementsListener;
import org.eclipse.sirius.ui.tools.internal.views.common.navigator.adapters.ModelDragTargetAdapter;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class DTableViewerManager
extends AbstractDTableViewerManager {
    public static final String EXPORT_IMG = "table/export";
    public static final String HIDE_IMG = "table/hide";
    public static final String REVEAL_IMG = "table/reveal";
    public static final String DELETE_IMG = "table/delete";
    public static final String CREATE_LINE = "table/newLine";
    public static final String CREATE_COLUMN = "table/newColumn";
    public static final String REFRESH_IMG = "table/refresh";
    public static final String SHOW_PROPERTIES_VIEW = "table/prop_ps";
    public static final String SORT_BY_LINE = "table/sortByLine";
    public static final String SORT_BY_COLUMN = "table/sortByColumn";
    public static final String HIDE_REVEAL_IMG = "table/hideReveal";
    public static final String TABLE_COLUMN_DATA = "org.eclipse.sirius.table.ui.dTableColumn";
    private static ImageRegistry imageRegistry = new ImageRegistry();
    protected boolean dRepresentationReplaced;
    private int activeColumn = -1;
    private DTableViewerListener tableViewerListener;
    private ITableCommandFactory tableCommandFactory;
    private EditorCreateLineMenuAction createLineMenu = new EditorCreateLineMenuAction();
    private EditorCreateTargetColumnMenuAction createTargetColumnMenu = new EditorCreateTargetColumnMenuAction();
    private TableUIUpdater tableUIUpdater;
    private DescriptionFileChangedNotifier descriptionFileChangedNotifier;
    private DTableContentProvider dTableContentProvider;
    private DTableMenuListener actualMenuListener;
    private SelectDRepresentationElementsListener selectTableElementsListener;
    private TreeColumnLayout treeLayout;
    private Composite composite;
    private DTableTreeFocusListener focusListener;

    static {
        imageRegistry.put(HIDE_IMG, ImageDescriptor.createFromURL((URL)((URL)TableUIPlugin.INSTANCE.getImage(HIDE_IMG))));
        imageRegistry.put(REVEAL_IMG, ImageDescriptor.createFromURL((URL)((URL)TableUIPlugin.INSTANCE.getImage(REVEAL_IMG))));
        imageRegistry.put(DELETE_IMG, ImageDescriptor.createFromURL((URL)((URL)TableUIPlugin.INSTANCE.getImage(DELETE_IMG))));
        imageRegistry.put(REFRESH_IMG, ImageDescriptor.createFromURL((URL)((URL)TableUIPlugin.INSTANCE.getImage(REFRESH_IMG))));
        imageRegistry.put(CREATE_LINE, ImageDescriptor.createFromURL((URL)((URL)TableUIPlugin.INSTANCE.getImage(CREATE_LINE))));
        imageRegistry.put(CREATE_COLUMN, ImageDescriptor.createFromURL((URL)((URL)TableUIPlugin.INSTANCE.getImage(CREATE_COLUMN))));
        imageRegistry.put(SHOW_PROPERTIES_VIEW, ImageDescriptor.createFromURL((URL)((URL)TableUIPlugin.INSTANCE.getImage(SHOW_PROPERTIES_VIEW))));
        imageRegistry.put(SORT_BY_LINE, ImageDescriptor.createFromURL((URL)((URL)TableUIPlugin.INSTANCE.getImage(SORT_BY_LINE))));
        imageRegistry.put(SORT_BY_COLUMN, ImageDescriptor.createFromURL((URL)((URL)TableUIPlugin.INSTANCE.getImage(SORT_BY_COLUMN))));
        imageRegistry.put(HIDE_REVEAL_IMG, ImageDescriptor.createFromURL((URL)((URL)TableUIPlugin.INSTANCE.getImage(HIDE_REVEAL_IMG))));
        imageRegistry.put(EXPORT_IMG, ImageDescriptor.createFromURL((URL)((URL)TableUIPlugin.INSTANCE.getImage(EXPORT_IMG))));
    }

    public DTableViewerManager(Composite parent, DTable dTable, TransactionalEditingDomain domain, ModelAccessor accessor, ITableCommandFactory tableCommandFactory, AbstractDTableEditor tableEditor) {
        super(parent, (DRepresentation)dTable, domain, accessor, (ICommandFactory)tableCommandFactory, (AbstractDTreeEditor)tableEditor);
        this.tableCommandFactory = tableCommandFactory;
        this.tableViewerListener = new DTableViewerListener(this, accessor, domain);
        this.createTreeViewer(parent);
    }

    public static ImageRegistry getImageRegistry() {
        return imageRegistry;
    }

    protected void createTreeViewer(Composite theComposite) {
        this.composite = theComposite;
        GridData gridData = new GridData(1808);
        theComposite.setLayoutData((Object)gridData);
        this.treeLayout = new TreeColumnLayout();
        theComposite.setLayout((Layout)this.treeLayout);
        this.treeViewer = new DTableTreeViewer(theComposite, 66306, this);
        this.treeViewer.addTreeListener((ITreeViewerListener)this.tableViewerListener);
        this.initializeDragSupport();
        this.treeViewer.setUseHashlookup(true);
        this.focusListener = new DTableTreeFocusListener(this.treeEditor, this.treeViewer.getTree());
        this.treeViewer.getTree().addFocusListener((FocusListener)this.focusListener);
        this.descriptionFileChangedNotifier = new DescriptionFileChangedNotifier((AbstractDTableViewerManager)this);
        this.dTableContentProvider = new DTableContentProvider();
        this.treeViewer.setContentProvider((IContentProvider)this.dTableContentProvider);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.treeViewer);
        this.treeViewer.getTree().setLinesVisible(true);
        this.treeViewer.getTree().setHeaderVisible(true);
        this.triggerCustomDrawingTreeItems();
        TreeViewerFocusCellManager focusCellManager = new TreeViewerFocusCellManager((TreeViewer)this.treeViewer, (FocusCellHighlighter)new FocusCellOwnerDrawHighlighter((ColumnViewer)this.treeViewer));
        TreeViewerEditor.create((TreeViewer)this.treeViewer, (SWTFocusCellManager)focusCellManager, (ColumnViewerEditorActivationStrategy)new DTableColumnViewerEditorActivationStrategy((ColumnViewer)this.treeViewer), (int)58);
        this.initializeKeyBindingSupport();
        this.triggerColumnSelectedColumn();
        this.initializeColumnsAndComponentsRelatedToDRepresentation(this.treeLayout);
    }

    private void initializeColumnsAndComponentsRelatedToDRepresentation(TreeColumnLayout theTreeLayout) {
        this.sortListener = new DLinesSorter(this.getEditingDomain(), this.getEditor().getTableModel());
        TreeViewerColumn headerTreeColumn = this.addFirstColumn(theTreeLayout);
        int index = 1;
        for (DColumn column : ((DTable)this.dRepresentation).getColumns()) {
            this.addNewColumn(column, index++);
        }
        this.tableUIUpdater = new TableUIUpdater(this, this.dRepresentation);
        if (this.selectTableElementsListener != null) {
            this.selectTableElementsListener.dispose();
        }
        this.selectTableElementsListener = new SelectDRepresentationElementsListener((DialectEditor)this.treeEditor, true);
        this.treeViewer.setInput((Object)this.dRepresentation);
        this.fillMenu();
        this.treeViewer.setExpandedElements(TableHelper.getExpandedLines((DTable)((DTable)this.dRepresentation)).toArray());
        int i = 0;
        while (i < this.treeViewer.getTree().getColumnCount()) {
            Object data = this.treeViewer.getTree().getColumn(i).getData("org.eclipse.jface.LAYOUT_DATA");
            if (data instanceof ColumnWeightData) {
                this.treeViewer.getTree().getColumn(i).pack();
            }
            ++i;
        }
        headerTreeColumn.getColumn().addControlListener((ControlListener)this.tableViewerListener);
    }

    private TreeViewerColumn addFirstColumn(TreeColumnLayout theTreeLayout) {
        DslCommonPlugin.PROFILER.startWork(SiriusTasksKey.ADD_SWT_COLUMN_KEY);
        TreeViewerColumn headerTreeColumn = new TreeViewerColumn((TreeViewer)this.treeViewer, 0x1000000, 0);
        DslCommonPlugin.PROFILER.startWork(SiriusTasksKey.SET_COLUMN_NAME_KEY);
        headerTreeColumn.getColumn().setText("");
        DslCommonPlugin.PROFILER.stopWork(SiriusTasksKey.SET_COLUMN_NAME_KEY);
        ILabelDecorator decorator = PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator();
        DTableLineLabelProvider lineheaderColumnLabelProvider = new DTableLineLabelProvider(decorator){

            public Color getBackground(Object element) {
                if (IS_GTK_OS) {
                    return Display.getCurrent().getSystemColor(19);
                }
                return Display.getCurrent().getSystemColor(19);
            }
        };
        headerTreeColumn.setLabelProvider((CellLabelProvider)lineheaderColumnLabelProvider);
        int headerColumnWidth = ((DTable)this.dRepresentation).getHeaderColumnWidth();
        if (headerColumnWidth > 0) {
            theTreeLayout.setColumnData((Widget)headerTreeColumn.getColumn(), (ColumnLayoutData)new ColumnPixelData(headerColumnWidth));
            if (headerTreeColumn.getColumn().getWidth() != headerColumnWidth) {
                headerTreeColumn.getColumn().setWidth(headerColumnWidth);
            }
        } else if (headerColumnWidth == 0 || ((DTable)this.dRepresentation).getDescription() instanceof CrossTableDescription) {
            theTreeLayout.setColumnData((Widget)headerTreeColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(1));
            if (IS_GTK_OS) {
                headerTreeColumn.getColumn().pack();
            }
        } else {
            this.treeLayout.setColumnData((Widget)headerTreeColumn.getColumn(), (ColumnLayoutData)new ColumnPixelData(0));
        }
        headerTreeColumn.getColumn().addListener(13, this.sortListener);
        DslCommonPlugin.PROFILER.stopWork(SiriusTasksKey.ADD_SWT_COLUMN_KEY);
        return headerTreeColumn;
    }

    private void initializeKeyBindingSupport() {
        this.treeViewer.getTree().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    DeleteLinesAction deleteLinesAction = new DeleteLinesAction(DTableViewerManager.this.getEditingDomain(), DTableViewerManager.this.getTableCommandFactory());
                    deleteLinesAction.setLines(DTableViewerManager.this.getSelectedLines());
                    if (deleteLinesAction.canExecute()) {
                        deleteLinesAction.run();
                    }
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
    }

    protected void initializeDragSupport() {
        int supportedOperations = 6;
        AbstractDTreeViewer selectionProvider = this.treeViewer;
        this.treeViewer.addDragSupport(supportedOperations, (Transfer[])new ByteArrayTransfer[]{LocalSelectionTransfer.getTransfer()}, (DragSourceListener)new ModelDragTargetAdapter((ISelectionProvider)selectionProvider));
    }

    public void fillMenu() {
        if (this.descriptionFileChanged || this.dRepresentationReplaced) {
            this.descriptionFileChanged = false;
            HashMap<TableMapping, DeleteTargetColumnAction> mappingToDeleteActions = new HashMap<TableMapping, DeleteTargetColumnAction>();
            HashMap<TableMapping, List<AbstractToolAction>> mappingToCreateActions = new HashMap<TableMapping, List<AbstractToolAction>>();
            ArrayList<AbstractToolAction> createActionsForTable = new ArrayList<AbstractToolAction>();
            this.calculateAvailableMenus(mappingToDeleteActions, mappingToCreateActions, createActionsForTable);
            this.mgr.setRemoveAllWhenShown(true);
            if (this.dRepresentationReplaced || this.actualMenuListener == null) {
                if (this.dRepresentationReplaced) {
                    this.mgr.removeMenuListener((IMenuListener)this.actualMenuListener);
                }
                this.actualMenuListener = new DTableMenuListener((DTable)this.dRepresentation, this, mappingToCreateActions, mappingToDeleteActions, createActionsForTable);
                this.mgr.addMenuListener((IMenuListener)this.actualMenuListener);
                Menu menu = this.mgr.createContextMenu(this.treeViewer.getControl());
                this.treeViewer.getControl().setMenu(menu);
                this.treeEditor.getSite().registerContextMenu(this.mgr, (ISelectionProvider)this.treeViewer);
            } else {
                this.mgr.removeAll();
                this.actualMenuListener.setMappingToCreateActions(mappingToCreateActions);
                this.actualMenuListener.setMappingToDeleteActions(mappingToDeleteActions);
                this.actualMenuListener.setCreateActionsForTable(createActionsForTable);
            }
            this.getCreateLineMenu().update(createActionsForTable);
            this.getCreateTargetColumnMenu().update(createActionsForTable);
            this.dRepresentationReplaced = false;
        }
    }

    private void calculateAvailableMenus(Map<TableMapping, DeleteTargetColumnAction> mappingToDeleteActions, Map<TableMapping, List<AbstractToolAction>> mappingToCreateActions, List<AbstractToolAction> createActionsForTable) {
        TableDescription tableDescription = ((DTable)this.dRepresentation).getDescription();
        if (tableDescription != null) {
            this.calculateAvailableMenusForLine((EList<LineMapping>)tableDescription.getAllLineMappings(), mappingToCreateActions, new ArrayList<LineMapping>());
            EList createLineTools = tableDescription.getAllCreateLine();
            for (CreateTool createTool : createLineTools) {
                CreateLineAction createLineAction = new CreateLineAction(createTool, this.getEditingDomain(), this.getTableCommandFactory());
                createLineAction.setTable((DTable)this.dRepresentation);
                createActionsForTable.add(createLineAction);
            }
            if (tableDescription instanceof CrossTableDescription) {
                this.calculateAvailableMenusForColumn((EList<ElementColumnMapping>)((CrossTableDescription)tableDescription).getOwnedColumnMappings(), mappingToDeleteActions, mappingToCreateActions);
                EList createColumnsTools = ((CrossTableDescription)tableDescription).getCreateColumn();
                for (CreateTool createTool : createColumnsTools) {
                    CreateTargetColumnAction createTargetColumnAction = new CreateTargetColumnAction(createTool, this.getEditingDomain(), this.getTableCommandFactory());
                    createTargetColumnAction.setTable((DTable)this.dRepresentation);
                    createActionsForTable.add(createTargetColumnAction);
                }
            }
        }
    }

    private void calculateAvailableMenusForColumn(EList<ElementColumnMapping> columnMappings, Map<TableMapping, DeleteTargetColumnAction> mappingToDeleteActions, Map<TableMapping, List<AbstractToolAction>> mappingToCreateActions) {
        for (ElementColumnMapping mapping : columnMappings) {
            if (mapping == null || mappingToDeleteActions.keySet().contains(mapping) || mappingToCreateActions.keySet().contains(mapping)) continue;
            DeleteColumnTool deleteTool = mapping.getDelete();
            mappingToDeleteActions.put((TableMapping)mapping, new DeleteTargetColumnAction((DeleteTool)deleteTool, this.getEditingDomain(), this.tableCommandFactory));
            EList createTools = mapping.getCreate();
            List<AbstractToolAction> existingCreateTools = mappingToCreateActions.get(mapping);
            if (existingCreateTools == null) {
                existingCreateTools = new ArrayList<AbstractToolAction>();
            }
            for (CreateTool createTool : createTools) {
                existingCreateTools.add(new CreateTargetColumnAction(createTool, this.getEditingDomain(), this.tableCommandFactory));
            }
            mappingToCreateActions.put((TableMapping)mapping, existingCreateTools);
        }
    }

    private void calculateAvailableMenusForLine(EList<LineMapping> lineMappings, Map<TableMapping, List<AbstractToolAction>> mappingToCreateActions, List<LineMapping> processedLineMappings) {
        for (LineMapping lineMapping : lineMappings) {
            if (lineMapping != null && !mappingToCreateActions.keySet().contains(lineMapping)) {
                EList createTools = lineMapping.getCreate();
                List<AbstractToolAction> existingCreateTools = mappingToCreateActions.get(lineMapping);
                if (existingCreateTools == null) {
                    existingCreateTools = new ArrayList<AbstractToolAction>();
                }
                for (CreateTool createTool : createTools) {
                    existingCreateTools.add(new CreateLineAction(createTool, this.getEditingDomain(), this.getTableCommandFactory()));
                }
                mappingToCreateActions.put((TableMapping)lineMapping, existingCreateTools);
            }
            if (lineMapping == null || processedLineMappings.contains(lineMapping)) continue;
            processedLineMappings.add(lineMapping);
            this.calculateAvailableMenusForLine((EList<LineMapping>)lineMapping.getAllSubLines(), mappingToCreateActions, processedLineMappings);
        }
    }

    protected void triggerCustomDrawingTreeItems() {
        this.treeViewer.getTree().addListener(40, (Listener)new DTableEraseItemListener(this, (TreeViewer)this.treeViewer));
    }

    protected void triggerColumnSelectedColumn() {
        this.treeViewer.getTree().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent event) {
                int x = 0;
                int i = 0;
                while (i < DTableViewerManager.this.treeViewer.getTree().getColumnCount()) {
                    if (event.x <= (x += DTableViewerManager.this.treeViewer.getTree().getColumn(i).getWidth())) {
                        DTableViewerManager.this.activeColumn = i;
                        break;
                    }
                    ++i;
                }
            }
        });
        this.treeViewer.getTree().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000003 && DTableViewerManager.this.activeColumn > 0) {
                    DTableViewerManager dTableViewerManager = DTableViewerManager.this;
                    dTableViewerManager.activeColumn = dTableViewerManager.activeColumn - 1;
                    DTableViewerManager.this.treeViewer.getTree().showColumn(DTableViewerManager.this.treeViewer.getTree().getColumn(DTableViewerManager.this.activeColumn));
                } else if (e.keyCode == 0x1000004 && DTableViewerManager.this.activeColumn < DTableViewerManager.this.treeViewer.getTree().getColumnCount() - 1) {
                    DTableViewerManager dTableViewerManager = DTableViewerManager.this;
                    dTableViewerManager.activeColumn = dTableViewerManager.activeColumn + 1;
                    DTableViewerManager.this.treeViewer.getTree().showColumn(DTableViewerManager.this.treeViewer.getTree().getColumn(DTableViewerManager.this.activeColumn));
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
    }

    public int getActiveColumn() {
        return this.activeColumn;
    }

    public Collection<DLine> getSelectedLines() {
        ArrayList<DLine> result = new ArrayList<DLine>();
        if (this.treeViewer.getTree().getSelectionCount() > 0) {
            TreeItem[] treeItemArray = this.treeViewer.getTree().getSelection();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                Object data = item.getData();
                if (data instanceof DLine) {
                    result.add((DLine)data);
                }
                ++n2;
            }
        }
        return result;
    }

    public ITableCommandFactory getTableCommandFactory() {
        return this.tableCommandFactory;
    }

    private void addNewColumn(DColumn newColumn, int index) {
        this.addNewColumn(newColumn, index, false);
    }

    public void addNewColumn(DColumn newColumn, int index, boolean changeInput) {
        DslCommonPlugin.PROFILER.startWork(SiriusTasksKey.ADD_SWT_COLUMN_KEY);
        if (this.treeViewer.getTree() != null) {
            TreeColumn[] treeColumnArray = this.treeViewer.getTree().getColumns();
            int n = treeColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeColumn tCol = treeColumnArray[n2];
                Object data = tCol.getData(TABLE_COLUMN_DATA);
                if (data != null && data.equals(newColumn)) {
                    return;
                }
                ++n2;
            }
        }
        TreeViewerColumn treeViewerColumn = new TreeViewerColumn((TreeViewer)this.treeViewer, 16384, index);
        if (newColumn.getLabel() != null) {
            DslCommonPlugin.PROFILER.startWork(SiriusTasksKey.SET_COLUMN_NAME_KEY);
            TreeColumn treeColumn = treeViewerColumn.getColumn();
            DTableColumnHeaderLabelProvider dTableColumnHeaderLabelProvider = new DTableColumnHeaderLabelProvider();
            String text = dTableColumnHeaderLabelProvider.getText(newColumn);
            treeColumn.setText(text);
            Image image = dTableColumnHeaderLabelProvider.getImage(newColumn);
            treeColumn.setImage(image);
            DslCommonPlugin.PROFILER.stopWork(SiriusTasksKey.SET_COLUMN_NAME_KEY);
        }
        if (newColumn.isVisible()) {
            if (newColumn.getWidth() != 0) {
                ((TreeColumnLayout)this.treeViewer.getControl().getParent().getLayout()).setColumnData((Widget)treeViewerColumn.getColumn(), (ColumnLayoutData)new ColumnPixelData(newColumn.getWidth()));
                if (treeViewerColumn.getColumn().getWidth() != newColumn.getWidth()) {
                    treeViewerColumn.getColumn().setWidth(newColumn.getWidth());
                }
            } else {
                ((TreeColumnLayout)this.treeViewer.getControl().getParent().getLayout()).setColumnData((Widget)treeViewerColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(1));
                if (IS_GTK_OS) {
                    treeViewerColumn.getColumn().pack();
                }
            }
        } else {
            ((TreeColumnLayout)this.treeViewer.getControl().getParent().getLayout()).setColumnData((Widget)treeViewerColumn.getColumn(), (ColumnLayoutData)new ColumnPixelData(0));
        }
        ILabelDecorator decorator = PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator();
        DTableDecoratingLabelProvider labelProvider = new DTableDecoratingLabelProvider(newColumn, decorator);
        treeViewerColumn.setLabelProvider((CellLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)labelProvider));
        if (newColumn instanceof DFeatureColumn) {
            treeViewerColumn.setEditingSupport((EditingSupport)new DFeatureColumnEditingSupport((ColumnViewer)this.treeViewer, (DFeatureColumn)newColumn, this.getEditingDomain(), this.getAccessor(), this.getTableCommandFactory(), (AbstractDTableEditor)this.treeEditor));
        } else if (newColumn instanceof DTargetColumn) {
            treeViewerColumn.setEditingSupport((EditingSupport)new DTargetColumnEditingSupport((ColumnViewer)this.treeViewer, (DTargetColumn)newColumn, this.getEditingDomain(), this.getAccessor(), this.tableCommandFactory, (AbstractDTableEditor)this.treeEditor));
        }
        treeViewerColumn.getColumn().setData(TABLE_COLUMN_DATA, (Object)newColumn);
        treeViewerColumn.getColumn().addControlListener((ControlListener)this.tableViewerListener);
        treeViewerColumn.getColumn().addListener(13, this.sortListener);
        DslCommonPlugin.PROFILER.stopWork(SiriusTasksKey.ADD_SWT_COLUMN_KEY);
    }

    public void removeOldColumn(DColumn oldColumn) {
        TreeColumn[] treeColumnArray = this.treeViewer.getTree().getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn treeColumn = treeColumnArray[n2];
            DColumn columnData = (DColumn)treeColumn.getData(TABLE_COLUMN_DATA);
            if (columnData != null && columnData.equals(oldColumn)) {
                treeColumn.dispose();
                break;
            }
            ++n2;
        }
    }

    public AbstractDTableEditor getEditor() {
        return (AbstractDTableEditor)this.treeEditor;
    }

    public EditorCreateLineMenuAction getCreateLineMenu() {
        return this.createLineMenu;
    }

    public EditorCreateTargetColumnMenuAction getCreateTargetColumnMenu() {
        return this.createTargetColumnMenu;
    }

    public void dispose() {
        if (this.treeViewer.getTree() != null && !this.treeViewer.getTree().isDisposed() && this.focusListener != null) {
            this.treeViewer.getTree().removeFocusListener((FocusListener)this.focusListener);
            this.focusListener = null;
        }
        this.treeViewer.removeTreeListener((ITreeViewerListener)this.tableViewerListener);
        this.tableViewerListener = null;
        this.descriptionFileChangedNotifier.dispose();
        this.descriptionFileChangedNotifier = null;
        this.tableUIUpdater.dispose();
        this.tableUIUpdater = null;
        this.selectTableElementsListener.dispose();
        this.selectTableElementsListener = null;
        this.dTableContentProvider.dispose();
        this.dTableContentProvider = null;
        super.dispose();
        this.createLineMenu.dispose();
        this.createLineMenu = null;
        this.createTargetColumnMenu.dispose();
        this.createTargetColumnMenu = null;
    }

    public void updateDRepresentation(DRepresentation newDRepresentation) {
        this.dRepresentation = newDRepresentation;
        this.tableViewerListener.resetDTable();
        this.getTreeViewer().getTree().removeAll();
        this.getTreeViewer().getTree().clearAll(true);
        while (this.getTreeViewer().getTree().getColumnCount() > 0) {
            this.getTreeViewer().getTree().getColumns()[0].dispose();
        }
        this.treeLayout = new TreeColumnLayout();
        this.composite.setLayout((Layout)this.treeLayout);
        this.dRepresentationReplaced = true;
        this.initializeColumnsAndComponentsRelatedToDRepresentation(this.treeLayout);
    }
}

