/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ext.emf;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.ext.emf.EStructuralFeatureQuery;

public class EClassQuery {
    private final EClass eClass;

    public EClassQuery(EClass eClass) {
        this.eClass = eClass;
    }

    public Collection<EStructuralFeature> getAllContainmentFeatures() {
        return ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)this.eClass.getEAllStructuralFeatures(), (Predicate)new IsContaintmentFeature()));
    }

    public Collection<EStructuralFeature> getAllNonContainmentFeatures() {
        return ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)this.eClass.getEAllStructuralFeatures(), (Predicate)Predicates.not((Predicate)new IsContaintmentFeature())));
    }

    public Set<EStructuralFeature> getEStructuralFeatures(String featureName, List<EClass> knownEClasses) {
        knownEClasses.add(this.eClass);
        LinkedHashSet<EStructuralFeature> result = new LinkedHashSet<EStructuralFeature>();
        EStructuralFeature eStructuralFeature = this.eClass.getEStructuralFeature(featureName);
        if (eStructuralFeature instanceof EReference) {
            result.add(eStructuralFeature);
        }
        Function<EReference, EClass> toEType = new Function<EReference, EClass>(){

            public EClass apply(EReference reference) {
                if (reference.getEType() instanceof EClass) {
                    return (EClass)reference.getEType();
                }
                return null;
            }
        };
        for (EClass subPartMetaModelEClass : Iterables.transform((Iterable)this.eClass.getEAllContainments(), (Function)toEType)) {
            if (subPartMetaModelEClass == null || knownEClasses.contains(subPartMetaModelEClass)) continue;
            result.addAll(new EClassQuery(subPartMetaModelEClass).getEStructuralFeatures(featureName, knownEClasses));
        }
        return result;
    }

    private static final class IsContaintmentFeature
    implements Predicate<EStructuralFeature> {
        private IsContaintmentFeature() {
        }

        public boolean apply(EStructuralFeature input) {
            return new EStructuralFeatureQuery(input).isContainment();
        }
    }
}

