/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.editor.properties.sections.description.layoutoption;

import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.provider.ItemProvider;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.sirius.diagram.description.BooleanLayoutOption;
import org.eclipse.sirius.diagram.description.CustomLayoutConfiguration;
import org.eclipse.sirius.diagram.description.DoubleLayoutOption;
import org.eclipse.sirius.diagram.description.EnumLayoutOption;
import org.eclipse.sirius.diagram.description.EnumSetLayoutOption;
import org.eclipse.sirius.diagram.description.IntegerLayoutOption;
import org.eclipse.sirius.diagram.description.LayoutOption;
import org.eclipse.sirius.diagram.description.StringLayoutOption;
import org.eclipse.sirius.editor.Messages;
import org.eclipse.sirius.editor.properties.sections.description.layoutoption.LayoutOptionPropertiesUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PatternFilter;

public class OptionOverrideEditorDialog
extends Dialog {
    private static final String TABLE_LABEL = Messages.OptionOverrideEditorDialog_tableLabel;
    private static final String CHECKBOX_COLUMN = "";
    private static final String LAYOUT_OPTION_TARGET_COLUMN = Messages.OptionOverrideEditorDialog_optionTargetColumnLabel;
    private static final String LAYOUT_OPTION_NAME_COLUMN = Messages.OptionOverrideEditorDialog_optionNameColumnLabel;
    private static final String LAYOUT_OPTION_TYPE_COLUMN = Messages.OptionOverrideEditorDialog_optionTypeColumnLabel;
    private static final String LAYOUT_OPTION_DEFAULT_VALUE_COLUMN = Messages.OptionOverrideEditorDialog_optionDefaultValueColumnLabel;
    private CustomLayoutConfiguration customLayoutConfiguration;
    private String displayName;
    private List<LayoutOption> layoutOptions;
    private boolean ascentTypeOrder;
    private boolean ascentTargetOrder;
    private String[] columnNames = new String[]{"", LAYOUT_OPTION_NAME_COLUMN, LAYOUT_OPTION_TARGET_COLUMN, LAYOUT_OPTION_TYPE_COLUMN, LAYOUT_OPTION_DEFAULT_VALUE_COLUMN};
    private Label layoutOptionDescriptionLabel;
    private Group descriptionGroupComposite;
    private Set<LayoutOption> checkedOptions;

    public OptionOverrideEditorDialog(Shell parent, CustomLayoutConfiguration customLayoutConfiguration, String displayName, List<LayoutOption> layoutOptions) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.customLayoutConfiguration = customLayoutConfiguration;
        this.displayName = displayName;
        this.layoutOptions = layoutOptions;
        this.checkedOptions = new HashSet<LayoutOption>();
    }

    public String getTypeLabel(LayoutOption layoutOption) {
        String result = CHECKBOX_COLUMN;
        switch (layoutOption.eClass().getClassifierID()) {
            case 24: {
                result = Messages.OptionOverrideEditorDialog_typeEnumLabel;
                break;
            }
            case 25: {
                result = Messages.OptionOverrideEditorDialog_typeEnumSetLabel;
                break;
            }
            case 21: {
                result = Messages.OptionOverrideEditorDialog_typeStringLabel;
                break;
            }
            case 20: {
                result = Messages.OptionOverrideEditorDialog_typeBooleanLabel;
                break;
            }
            case 23: {
                result = Messages.OptionOverrideEditorDialog_typeDoubleLabel;
                break;
            }
            case 22: {
                result = Messages.OptionOverrideEditorDialog_typeIntegerLabel;
                break;
            }
        }
        return result;
    }

    public String getTargetLabels(LayoutOption layoutOption) {
        EList targets = layoutOption.getTargets();
        return targets.stream().map(target -> {
            String result = CHECKBOX_COLUMN;
            switch (target) {
                case PARENT: {
                    result = Messages.OptionOverrideEditorDialog_targetParentLabel;
                    break;
                }
                case NODE: {
                    result = Messages.OptionOverrideEditorDialog_targetNodeLabel;
                    break;
                }
                case EDGE: {
                    result = Messages.OptionOverrideEditorDialog_targetEdgeLabel;
                    break;
                }
                case PORTS: {
                    result = Messages.OptionOverrideEditorDialog_targePortLabel;
                    break;
                }
                case LABEL: {
                    result = Messages.OptionOverrideEditorDialog_targetLabelLabel;
                    break;
                }
            }
            return result;
        }).collect(Collectors.joining(", "));
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.displayName);
    }

    protected Control createDialogArea(Composite parent) {
        Composite contents = (Composite)super.createDialogArea(parent);
        GridLayout contentsGridLayout = (GridLayout)contents.getLayout();
        contentsGridLayout.numColumns = 1;
        GridData contentsGridData = (GridData)contents.getLayoutData();
        contentsGridData.horizontalAlignment = 4;
        contentsGridData.verticalAlignment = 4;
        Text patternText = this.initFilterComposite(contents);
        Composite tableComposite = this.initTableComposites(contents);
        Table table = new Table(tableComposite, 67618);
        TableViewer tableViewer = new TableViewer(table);
        this.initTable(table, tableViewer);
        this.initTableViewer(patternText, table, tableViewer);
        this.initDescriptionComposite(contents);
        return contents;
    }

    private Composite initTableComposites(Composite contents) {
        Composite tableComposite = new Composite(contents, 0);
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)tableLayout);
        GridData data = new GridData(4, 4, true, true);
        data.horizontalAlignment = 0x1000008;
        tableComposite.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        data.horizontalAlignment = 4;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        tableComposite.setLayout((Layout)layout);
        Label tableLabel = new Label(tableComposite, 0);
        tableLabel.setText(TABLE_LABEL);
        GridData tableLabelGridData = new GridData();
        tableLabelGridData.verticalAlignment = 4;
        tableLabelGridData.horizontalAlignment = 4;
        tableLabel.setLayoutData((Object)tableLabelGridData);
        return tableComposite;
    }

    private void initTableViewer(Text patternText, Table table, final TableViewer tableViewer) {
        tableViewer.setUseHashlookup(true);
        tableViewer.setColumnProperties(this.columnNames);
        final LayoutOptionColumnLabelProvider labelProvider = new LayoutOptionColumnLabelProvider();
        tableViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        tableViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)new AdapterFactoryImpl()));
        final PatternFilter filter = new PatternFilter(){

            protected boolean isParentMatch(Viewer viewer, Object element) {
                return viewer instanceof AbstractTreeViewer && super.isParentMatch(viewer, element);
            }

            protected boolean isLeafMatch(Viewer viewer, Object element) {
                String labelText;
                boolean leafMatch = super.isLeafMatch(viewer, element);
                if (!leafMatch && (labelText = labelProvider.getColumnText(element, 2)) != null) {
                    boolean bl = leafMatch = leafMatch || this.wordMatches(labelText);
                    if (!leafMatch && (labelText = labelProvider.getColumnText(element, 3)) != null) {
                        leafMatch = leafMatch || this.wordMatches(labelText);
                    }
                }
                return leafMatch;
            }
        };
        tableViewer.addFilter((ViewerFilter)filter);
        if (patternText != null) {
            patternText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    filter.setPattern(((Text)e.widget).getText());
                    tableViewer.refresh();
                }
            });
        }
        tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                LayoutOption firstElement = (LayoutOption)selection.getFirstElement();
                if (firstElement != null) {
                    String description = LayoutOptionPropertiesUtils.getDescription(OptionOverrideEditorDialog.this.customLayoutConfiguration, firstElement);
                    if (description == null) {
                        description = OptionOverrideEditorDialog.CHECKBOX_COLUMN;
                    }
                    OptionOverrideEditorDialog.this.layoutOptionDescriptionLabel.setText(description);
                    OptionOverrideEditorDialog.this.descriptionGroupComposite.layout();
                }
            }
        });
        tableViewer.setInput((Object)new ItemProvider(this.layoutOptions));
    }

    private Composite initDescriptionComposite(Composite contents) {
        this.descriptionGroupComposite = new Group(contents, 0);
        this.descriptionGroupComposite.setText(Messages.OptionOverrideEditorDialog_optionDescriptionLabel);
        GridLayout layout = new GridLayout(1, true);
        this.descriptionGroupComposite.setLayout((Layout)layout);
        GridData layoutData = new GridData(4, 4, true, true);
        layoutData.minimumHeight = 100;
        layoutData.widthHint = 100;
        this.descriptionGroupComposite.setLayoutData((Object)layoutData);
        this.layoutOptionDescriptionLabel = new Label((Composite)this.descriptionGroupComposite, 64);
        this.layoutOptionDescriptionLabel.setLayoutData((Object)new GridData(4, 4, true, true));
        return this.descriptionGroupComposite;
    }

    private void initTable(Table table, final TableViewer tableViewer) {
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData tableGridData = new GridData();
        int displayWidth = Display.getCurrent().getBounds().width;
        tableGridData.widthHint = displayWidth / 5;
        tableGridData.heightHint = Display.getCurrent().getBounds().height / 3;
        tableGridData.verticalAlignment = 4;
        tableGridData.horizontalAlignment = 4;
        tableGridData.grabExcessHorizontalSpace = true;
        tableGridData.grabExcessVerticalSpace = true;
        table.setLayoutData((Object)tableGridData);
        TableColumn checkColumn = new TableColumn(table, 0x1000000, 0);
        checkColumn.setText(this.columnNames[0]);
        checkColumn.setWidth(30);
        TableColumn nameColumn = new TableColumn(table, 16384, 1);
        nameColumn.setWidth(displayWidth / 14);
        nameColumn.setText(this.columnNames[1]);
        TableColumn targetColumn = new TableColumn(table, 16384, 2);
        targetColumn.setWidth(displayWidth / 60);
        targetColumn.setText(this.columnNames[2]);
        TableColumn typeColumn = new TableColumn(table, 16384, 3);
        typeColumn.setWidth(displayWidth / 60);
        typeColumn.setText(this.columnNames[3]);
        TableColumn defaultValueColumn = new TableColumn(table, 16384, 4);
        defaultValueColumn.setWidth(displayWidth / 14);
        defaultValueColumn.setText(this.columnNames[4]);
        tableViewer.setComparator(new ViewerComparator(Comparator.naturalOrder()));
        nameColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Comparator comparator = OptionOverrideEditorDialog.this.ascentTypeOrder ? Comparator.naturalOrder() : Comparator.reverseOrder();
                OptionOverrideEditorDialog.this.ascentTypeOrder = !OptionOverrideEditorDialog.this.ascentTypeOrder;
                tableViewer.setComparator(new ViewerComparator(comparator));
            }
        });
        targetColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final Comparator comparator = OptionOverrideEditorDialog.this.ascentTargetOrder ? Comparator.naturalOrder() : Comparator.reverseOrder();
                OptionOverrideEditorDialog.this.ascentTargetOrder = !OptionOverrideEditorDialog.this.ascentTargetOrder;
                tableViewer.setComparator(new ViewerComparator(){

                    public int compare(Viewer viewer, Object e1, Object e2) {
                        LayoutOption layoutOption1 = (LayoutOption)e1;
                        LayoutOption layoutOption2 = (LayoutOption)e2;
                        return comparator.compare(OptionOverrideEditorDialog.this.getTargetLabels(layoutOption1), OptionOverrideEditorDialog.this.getTargetLabels(layoutOption2));
                    }
                });
            }
        });
        typeColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final Comparator comparator = OptionOverrideEditorDialog.this.ascentTypeOrder ? Comparator.naturalOrder() : Comparator.reverseOrder();
                OptionOverrideEditorDialog.this.ascentTypeOrder = !OptionOverrideEditorDialog.this.ascentTypeOrder;
                tableViewer.setComparator(new ViewerComparator(){

                    public int compare(Viewer viewer, Object e1, Object e2) {
                        LayoutOption layoutOption1 = (LayoutOption)e1;
                        LayoutOption layoutOption2 = (LayoutOption)e2;
                        return comparator.compare(OptionOverrideEditorDialog.this.getTypeLabel(layoutOption1), OptionOverrideEditorDialog.this.getTypeLabel(layoutOption2));
                    }
                });
            }
        });
        table.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 32) {
                    TableItem tableItem = (TableItem)event.item;
                    LayoutOption layoutOption = (LayoutOption)tableItem.getData();
                    if (!tableItem.getChecked()) {
                        OptionOverrideEditorDialog.this.checkedOptions.remove(layoutOption);
                    } else {
                        OptionOverrideEditorDialog.this.checkedOptions.add(layoutOption);
                    }
                }
            }
        });
    }

    private Text initFilterComposite(Composite contents) {
        Text patternText = null;
        Group filterGroupComposite = new Group(contents, 0);
        filterGroupComposite.setText(Messages.OptionOverrideEditorDialog_filteringLabel);
        filterGroupComposite.setLayout((Layout)new GridLayout(2, false));
        filterGroupComposite.setLayoutData((Object)new GridData(4, -1, true, false, 3, 1));
        Label label = new Label((Composite)filterGroupComposite, 0);
        label.setText(EMFEditUIPlugin.INSTANCE.getString("_UI_Choices_pattern_label"));
        patternText = new Text((Composite)filterGroupComposite, 2048);
        patternText.setLayoutData((Object)new GridData(768));
        return patternText;
    }

    protected void cancelPressed() {
        this.checkedOptions.clear();
        super.cancelPressed();
    }

    public boolean close() {
        this.layoutOptionDescriptionLabel = null;
        this.descriptionGroupComposite = null;
        return super.close();
    }

    public Set<LayoutOption> getResult() {
        return this.checkedOptions;
    }

    private final class LayoutOptionColumnLabelProvider
    extends CellLabelProvider
    implements ITableLabelProvider,
    ILabelProvider {
        private LayoutOptionColumnLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            LayoutOption layoutOption = (LayoutOption)element;
            String columnText = OptionOverrideEditorDialog.CHECKBOX_COLUMN;
            block0 : switch (columnIndex) {
                case 1: {
                    columnText = layoutOption.getLabel();
                    break;
                }
                case 2: {
                    columnText = OptionOverrideEditorDialog.this.getTargetLabels(layoutOption);
                    break;
                }
                case 3: {
                    columnText = OptionOverrideEditorDialog.this.getTypeLabel(layoutOption);
                    break;
                }
                case 4: {
                    columnText = layoutOption.getLabel();
                    switch (layoutOption.eClass().getClassifierID()) {
                        case 24: {
                            columnText = ((EnumLayoutOption)element).getValue().getName();
                            break block0;
                        }
                        case 25: {
                            columnText = ((EnumSetLayoutOption)element).getValues().stream().map(value -> value.getName()).collect(Collectors.joining(", "));
                            break block0;
                        }
                        case 21: {
                            columnText = ((StringLayoutOption)element).getValue();
                            break block0;
                        }
                        case 20: {
                            columnText = String.valueOf(((BooleanLayoutOption)element).isValue());
                            break block0;
                        }
                        case 23: {
                            columnText = String.valueOf(((DoubleLayoutOption)element).getValue());
                            break block0;
                        }
                        case 22: {
                            columnText = String.valueOf(((IntegerLayoutOption)element).getValue());
                            break block0;
                        }
                    }
                    break;
                }
            }
            return columnText;
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            cell.setText(this.getColumnText(element, cell.getColumnIndex()));
            Image image = this.getColumnImage(element, cell.getColumnIndex());
            cell.setImage(image);
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            return this.getColumnText(element, 1);
        }
    }
}

