/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.filter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.helper.SelectionDescriptionHelper;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.common.tools.api.util.TreeItemWrapper;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.DiagramFactory;
import org.eclipse.sirius.diagram.EObjectVariableValue;
import org.eclipse.sirius.diagram.TypedVariableValue;
import org.eclipse.sirius.diagram.VariableValue;
import org.eclipse.sirius.diagram.business.internal.helper.filter.VariableFilterWrapper;
import org.eclipse.sirius.diagram.description.filter.VariableFilter;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.tools.api.command.ui.UICallBack;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.eclipse.sirius.viewpoint.description.InteractiveVariableDescription;
import org.eclipse.sirius.viewpoint.description.SelectionDescription;
import org.eclipse.sirius.viewpoint.description.TypedVariable;
import org.eclipse.sirius.viewpoint.description.tool.SelectModelElementVariable;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;

public final class FilterTools {
    private FilterTools() {
    }

    public static void askForFilterValues(DSemanticDiagram diagram, VariableFilter filter) throws InterruptedException {
        EObject model = diagram.getTarget();
        UICallBack uiCallback = SiriusEditPlugin.getPlugin().getUiCallback();
        if (diagram.getFilterVariableHistory() != null) {
            Iterator it = diagram.getFilterVariableHistory().getOwnedValues().iterator();
            while (it.hasNext()) {
                TypedVariableValue typedVarValue;
                VariableValue value = (VariableValue)it.next();
                if (value instanceof EObjectVariableValue) {
                    EObjectVariableValue objVarValue = (EObjectVariableValue)value;
                    if (objVarValue.getVariableDefinition() != null && objVarValue.getModelElement() != null && !filter.getOwnedVariables().contains((Object)objVarValue.getVariableDefinition())) continue;
                    it.remove();
                    continue;
                }
                if (!(value instanceof TypedVariableValue) || (typedVarValue = (TypedVariableValue)value).getVariableDefinition() != null && !filter.getOwnedVariables().contains((Object)typedVarValue.getVariableDefinition())) continue;
                it.remove();
            }
        }
        Iterator itVar = filter.getOwnedVariables().iterator();
        ArrayList<TypedVariable> typedVariableList = new ArrayList<TypedVariable>();
        while (itVar.hasNext()) {
            InteractiveVariableDescription currentVar = (InteractiveVariableDescription)itVar.next();
            if (currentVar instanceof SelectModelElementVariable) {
                SelectModelElementVariable var = (SelectModelElementVariable)currentVar;
                TreeItemWrapper input = new TreeItemWrapper(null, null);
                FilterTools.computeInput(diagram, model, var, input);
                if (!var.isMultiple()) {
                    EObject modelElement = uiCallback.askForEObject(var.getMessage(), input, DiagramUIPlugin.getPlugin().getItemProvidersAdapterFactory());
                    EObjectVariableValue newValue = DiagramFactory.eINSTANCE.createEObjectVariableValue();
                    newValue.setModelElement(modelElement);
                    newValue.setVariableDefinition(var);
                    if (diagram.getFilterVariableHistory() == null) continue;
                    diagram.getFilterVariableHistory().getOwnedValues().add((Object)newValue);
                    continue;
                }
                BasicEList values = new BasicEList();
                Collection modelElements = uiCallback.askForEObjects(var.getMessage(), input, DiagramUIPlugin.getPlugin().getItemProvidersAdapterFactory());
                values.addAll(modelElements);
                BasicEList variables = new BasicEList();
                for (EObject modelElement : values) {
                    EObjectVariableValue newValue = DiagramFactory.eINSTANCE.createEObjectVariableValue();
                    newValue.setModelElement(modelElement);
                    newValue.setVariableDefinition(var);
                    variables.add((Object)newValue);
                }
                if (diagram.getFilterVariableHistory() == null) continue;
                diagram.getFilterVariableHistory().getOwnedValues().addAll((Collection)variables);
                continue;
            }
            if (!(currentVar instanceof TypedVariable)) continue;
            typedVariableList.add((TypedVariable)currentVar);
        }
        List<VariableValue> variables = FilterTools.getTypedVariableValue(uiCallback, typedVariableList, diagram);
        if (diagram.getFilterVariableHistory() != null) {
            diagram.getFilterVariableHistory().getOwnedValues().addAll(variables);
        }
        Optional<VariableFilterWrapper> variableFilterWrapper = filter.eAdapters().stream().filter(VariableFilterWrapper.class::isInstance).map(VariableFilterWrapper.class::cast).findFirst();
        if (variableFilterWrapper.isPresent()) {
            variableFilterWrapper.get().resetVariables();
        }
    }

    private static List<VariableValue> getTypedVariableValue(UICallBack uiCallback, List<TypedVariable> typedVariableList, DSemanticDiagram diagram) {
        ArrayList<VariableValue> variables = new ArrayList<VariableValue>();
        if (typedVariableList.size() > 0) {
            try {
                List values = null;
                List<String> defaultValues = FilterTools.computeDefaultValues(typedVariableList, diagram);
                values = uiCallback.askForTypedVariable(typedVariableList, defaultValues);
                int i = 0;
                while (i < typedVariableList.size()) {
                    TypedVariable variableDef = typedVariableList.get(i);
                    String value = (String)values.get(i);
                    if (!StringUtil.isEmpty((String)value)) {
                        TypedVariableValue newVariableValue = DiagramFactory.eINSTANCE.createTypedVariableValue();
                        newVariableValue.setValue(value);
                        newVariableValue.setVariableDefinition(variableDef);
                        variables.add((VariableValue)newVariableValue);
                    }
                    ++i;
                }
            }
            catch (InterruptedException interruptedException) {}
        }
        return variables;
    }

    private static List<String> computeDefaultValues(List<TypedVariable> typedVariableList, DSemanticDiagram diagram) {
        ArrayList<String> defaultValues = new ArrayList<String>();
        IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter((EObject)diagram);
        EObject diagramSemanticObject = diagram.getTarget();
        for (TypedVariable typedVariable : typedVariableList) {
            String defaultValue;
            block7: {
                String defaultValueExpression = typedVariable.getDefaultValueExpression();
                defaultValue = "";
                if (!StringUtil.isEmpty((String)defaultValueExpression)) {
                    interpreter.setVariable("diagram", (Object)diagram);
                    try {
                        try {
                            defaultValue = interpreter.evaluateString(diagramSemanticObject, typedVariable.getDefaultValueExpression());
                        }
                        catch (EvaluationException e) {
                            RuntimeLoggerManager.INSTANCE.error((EObject)typedVariable, (EStructuralFeature)DescriptionPackage.eINSTANCE.getTypedVariable_DefaultValueExpression(), (Throwable)e);
                            interpreter.unSetVariable("diagram");
                            break block7;
                        }
                    }
                    catch (Throwable throwable) {
                        interpreter.unSetVariable("diagram");
                        throw throwable;
                    }
                    interpreter.unSetVariable("diagram");
                }
            }
            defaultValues.add(defaultValue);
        }
        return defaultValues;
    }

    private static void computeInput(DSemanticDiagram diagram, EObject model, SelectModelElementVariable var, TreeItemWrapper input) {
        IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(model);
        if (var.getCandidatesExpression() != null) {
            interpreter.setVariable("diagram", (Object)diagram);
            SelectionDescriptionHelper.computeInput((SelectionDescription)var, (EObject)model, (IInterpreter)interpreter, (TreeItemWrapper)input);
            interpreter.unSetVariable("diagram");
        }
    }
}

