/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.api.draw2d.ui.figures;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.ResizableCompartmentFigure;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.AbstractDNodeContainerCompartmentEditPart;

public final class FigureUtilities {
    private FigureUtilities() {
    }

    public static Point getShiftFromMarginOffset(ResizableCompartmentFigure fig, boolean isConcernedBorderedNode, EditPart editPart) {
        if (isConcernedBorderedNode) {
            return new Point(0, 0);
        }
        Point shift = new Point();
        if (editPart instanceof AbstractDNodeContainerCompartmentEditPart) {
            FigureUtilities.shiftBorderInsets(shift, (IFigure)fig);
            for (Object next : fig.getChildren()) {
                if (!(next instanceof IFigure)) continue;
                IFigure childrenFigure = (IFigure)next;
                FigureUtilities.shiftBorderInsets(shift, childrenFigure);
            }
        }
        return shift;
    }

    private static void shiftBorderInsets(Point shift, IFigure figure) {
        Insets insets;
        Border border = figure.getBorder();
        if (border != null && (insets = border.getInsets(figure)) != null) {
            shift.translate(insets.left, insets.top);
        }
    }
}

