/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.preferences;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.common.util.AbstractEnumerator;
import org.eclipse.gmf.runtime.common.ui.preferences.CheckBoxFieldEditor;
import org.eclipse.gmf.runtime.common.ui.preferences.ComboFieldEditor;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.preferences.ConnectionsPreferencePage;
import org.eclipse.gmf.runtime.diagram.ui.properties.internal.l10n.DiagramUIPropertiesMessages;
import org.eclipse.gmf.runtime.notation.JumpLinkStatus;
import org.eclipse.gmf.runtime.notation.JumpLinkType;
import org.eclipse.gmf.runtime.notation.Routing;
import org.eclipse.gmf.runtime.notation.Smoothness;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.preferences.SiriusDiagramUiPreferencesKeys;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class DiagramConnectionsPreferencePage
extends ConnectionsPreferencePage {
    private static final String REVERSE_JUMP_LINKS_LABEL = DiagramUIPropertiesMessages.ConnectionAppearanceDetails_ReverseJumpLinksLabel_Text;
    private static final String JUMP_LINKS_STATUS_LABEL = DiagramUIPropertiesMessages.ConnectionAppearanceDetails_JumpLinksLabel_Text;
    private static final String JUMP_LINKS_TYPE_LABEL = DiagramUIPropertiesMessages.ConnectionAppearanceDetails_JumpLinkTypeLabel_Text;
    private static final String JUMP_LINKS_GROUP_LABEL = DiagramUIPropertiesMessages.ConnectionAppearanceDetails_JumpLinkGroupLabel_Text;
    IPreferenceStore diagramCorePreferenceStore;
    private List<FieldEditor> coreFields = null;
    private FieldEditor invalidCoreFieldEditor = null;
    protected CheckBoxFieldEditor showLinkFieldEditor = null;
    protected ComboFieldEditor lineStyleFieldEditor = null;
    protected CheckBoxFieldEditor enableLineStyleOverrideFieldEditor = null;
    protected CheckBoxFieldEditor enableJumpLinkOverrideFieldEditor = null;
    protected CheckBoxFieldEditor reverseJumpLinkFieldEditor = null;
    private Group specificDefaultValuesGroup;
    private RadioGroupFieldEditor jumpLinkStatusGroup;
    private RadioGroupFieldEditor jumpLinkTypeGroup;

    public static void initDefaults(IPreferenceStore preferenceStore) {
        ConnectionsPreferencePage.initDefaults((IPreferenceStore)preferenceStore);
    }

    public DiagramConnectionsPreferencePage() {
        this.setPreferenceStore(DiagramUIPlugin.getPlugin().getPreferenceStore());
        this.setCorePreferenceStore((IPreferenceStore)new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.sirius.diagram"));
    }

    protected void addFieldEditors(Composite composite) {
        this.showLinkFieldEditor = new CheckBoxFieldEditor(SiriusDiagramUiPreferencesKeys.PREF_SHOW_LINK_EDGE_LABEL_ON_SELECTION.name(), Messages.DiagramConnectionsPreferencePage_showEdgeLabelLinkOnSelect, composite);
        this.addField((FieldEditor)this.showLinkFieldEditor);
        this.specificDefaultValuesGroup = this.createGroup(composite, Messages.DiagramConnectionsPreferencePage_defaultValuesGroup_title, 3, false);
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        this.specificDefaultValuesGroup.setLayoutData((Object)gridData);
        this.addLineStylePreferences((Composite)this.specificDefaultValuesGroup);
        this.addJumpLinksPreferences((Composite)this.specificDefaultValuesGroup);
    }

    private Group createGroup(Composite parent, String text, int numColumns, boolean makeColumnsEqualWidth) {
        Group group = new Group(parent, 0);
        GridLayout gridLayout = new GridLayout(numColumns, makeColumnsEqualWidth);
        group.setLayout((Layout)gridLayout);
        group.setText(text);
        return group;
    }

    private void addLineStylePreferences(Composite parent) {
        this.enableLineStyleOverrideFieldEditor = new SpecificCheckBoxFieldEditor("Viewpoint.Connectors.enableOverride", Messages.DiagramConnectionsPreferencePage_enableLineStyleOverride_label, parent, 1);
        this.addCoreField((FieldEditor)this.enableLineStyleOverrideFieldEditor);
        this.lineStyleFieldEditor = new SpecificComboFieldEditor("Viewpoint.Connectors.lineStyle", "", parent, 1, false, 0, 0, true);
        this.addCoreField((FieldEditor)this.lineStyleFieldEditor);
        Combo lineStyleCombo = this.lineStyleFieldEditor.getComboControl();
        lineStyleCombo.add(DiagramUIMessages.ConnectionsPreferencePage_ConnectionView_Manual_text);
        lineStyleCombo.add(DiagramUIMessages.ConnectionsPreferencePage_ConnectionView_Rectilinear_text);
        lineStyleCombo.add(Routing.TREE_LITERAL.getLiteral());
        lineStyleCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                String comboValue = ((Combo)evt.getSource()).getText();
                if (DiagramUIMessages.ConnectionsPreferencePage_ConnectionView_Manual_text.equals(comboValue)) {
                    comboValue = Routing.MANUAL_LITERAL.getLiteral();
                }
                DiagramConnectionsPreferencePage.this.getPreferenceStore().setValue("Connectors.lineStyle", Routing.get((String)comboValue).getValue());
            }
        });
    }

    private void addJumpLinksPreferences(Composite parent) {
        String propertyValueName;
        AbstractEnumerator literal;
        this.enableJumpLinkOverrideFieldEditor = new SpecificCheckBoxFieldEditor("Sirius.Connectors.JumpLink.enableOverride", JUMP_LINKS_GROUP_LABEL, parent, 1);
        GridData gd = (GridData)this.enableJumpLinkOverrideFieldEditor.getCheckbox().getLayoutData();
        gd.verticalAlignment = 128;
        this.addCoreField((FieldEditor)this.enableJumpLinkOverrideFieldEditor);
        String[][] labelAndValues = new String[JumpLinkStatus.VALUES.size()][2];
        int i = 0;
        while (i < JumpLinkStatus.VALUES.size()) {
            literal = (AbstractEnumerator)JumpLinkStatus.VALUES.get(i);
            labelAndValues[i][0] = propertyValueName = this.translate(literal);
            labelAndValues[i][1] = Integer.toString(literal.getValue());
            ++i;
        }
        this.jumpLinkStatusGroup = new SpecificRadioGroupFieldEditor("Sirius.Connectors.JumpLink.status", JUMP_LINKS_STATUS_LABEL, 2, labelAndValues, parent, true);
        this.addCoreField((FieldEditor)this.jumpLinkStatusGroup);
        labelAndValues = new String[JumpLinkType.VALUES.size()][2];
        i = 0;
        while (i < JumpLinkType.VALUES.size()) {
            literal = (AbstractEnumerator)JumpLinkType.VALUES.get(i);
            labelAndValues[i][0] = propertyValueName = this.translate(literal);
            labelAndValues[i][1] = Integer.toString(literal.getValue());
            ++i;
        }
        this.jumpLinkTypeGroup = new SpecificRadioGroupFieldEditor("Sirius.Connectors.JumpLink.type", JUMP_LINKS_TYPE_LABEL, 2, labelAndValues, parent, true);
        this.addCoreField((FieldEditor)this.jumpLinkTypeGroup);
        new Label(parent, 0);
        this.reverseJumpLinkFieldEditor = new SpecificCheckBoxFieldEditor("Sirius.Connectors.JumpLink.reverse", REVERSE_JUMP_LINKS_LABEL, parent, 2);
        this.addCoreField((FieldEditor)this.reverseJumpLinkFieldEditor);
    }

    protected void initialize() {
        super.initialize();
        if (this.coreFields != null) {
            for (FieldEditor pe : this.coreFields) {
                pe.setPage((DialogPage)this);
                pe.setPropertyChangeListener((IPropertyChangeListener)this);
                pe.setPreferenceStore(this.getCorePreferenceStore());
                pe.load();
            }
        }
        this.enableLineStyleField(this.diagramCorePreferenceStore.getBoolean("Viewpoint.Connectors.enableOverride"));
        this.enableJumpLinkField(this.diagramCorePreferenceStore.getBoolean("Sirius.Connectors.JumpLink.enableOverride"));
    }

    public void propertyChange(PropertyChangeEvent event) {
        boolean enabled;
        if (event.getProperty().equals("field_editor_is_valid")) {
            boolean newValue = (Boolean)event.getNewValue();
            if (newValue) {
                this.checkState();
            } else if (this.coreFields.contains(event.getSource())) {
                this.invalidCoreFieldEditor = (FieldEditor)event.getSource();
                this.setValid(newValue);
            } else {
                super.propertyChange(event);
            }
        }
        if (this.enableLineStyleOverrideFieldEditor.equals(event.getSource()) && event.getProperty().equals("field_editor_value")) {
            enabled = (Boolean)event.getNewValue();
            this.enableLineStyleField(enabled);
            if (enabled) {
                this.getPreferenceStore().setValue("Connectors.lineStyle", this.lineStyleFieldEditor.getStringValue());
            } else {
                this.getPreferenceStore().setValue("Connectors.lineStyle", 0);
            }
        }
        if (this.enableJumpLinkOverrideFieldEditor.equals(event.getSource()) && event.getProperty().equals("field_editor_value")) {
            enabled = (Boolean)event.getNewValue();
            this.enableJumpLinkField(enabled);
        }
    }

    protected void enableLineStyleField(boolean enabled) {
        this.lineStyleFieldEditor.setEnabled(enabled, (Composite)this.specificDefaultValuesGroup);
        this.lineStyleFieldEditor.getComboControl().setEnabled(enabled);
    }

    protected void enableJumpLinkField(boolean enabled) {
        this.jumpLinkStatusGroup.setEnabled(enabled, (Composite)this.specificDefaultValuesGroup);
        this.jumpLinkTypeGroup.setEnabled(enabled, (Composite)this.specificDefaultValuesGroup);
        this.reverseJumpLinkFieldEditor.setEnabled(enabled, (Composite)this.specificDefaultValuesGroup);
    }

    protected void addCoreField(FieldEditor editor) {
        if (this.coreFields == null) {
            this.coreFields = new ArrayList<FieldEditor>();
        }
        this.coreFields.add(editor);
    }

    private String translate(AbstractEnumerator literal) {
        if (JumpLinkType.SEMICIRCLE_LITERAL.equals(literal)) {
            return DiagramUIMessages.PropertyDescriptorFactory_JumplinksType_SemiCircle;
        }
        if (JumpLinkType.SQUARE_LITERAL.equals(literal)) {
            return DiagramUIMessages.PropertyDescriptorFactory_JumplinksType_Square;
        }
        if (JumpLinkType.CHAMFERED_LITERAL.equals(literal)) {
            return DiagramUIMessages.PropertyDescriptorFactory_JumplinksType_Chamfered;
        }
        if (JumpLinkType.TUNNEL_LITERAL.equals(literal)) {
            return DiagramUIMessages.PropertyDescriptorFactory_JumplinksType_Tunnel;
        }
        if (JumpLinkStatus.NONE_LITERAL.equals(literal)) {
            return DiagramUIMessages.PropertyDescriptorFactory_JumplinksStatus_None;
        }
        if (JumpLinkStatus.ALL_LITERAL.equals(literal)) {
            return DiagramUIMessages.PropertyDescriptorFactory_JumplinksStatus_All;
        }
        if (JumpLinkStatus.BELOW_LITERAL.equals(literal)) {
            return DiagramUIMessages.PropertyDescriptorFactory_JumplinksStatus_Below;
        }
        if (JumpLinkStatus.ABOVE_LITERAL.equals(literal)) {
            return DiagramUIMessages.PropertyDescriptorFactory_JumplinksStatus_Above;
        }
        if (Smoothness.NONE_LITERAL.equals(literal)) {
            return DiagramUIMessages.PropertyDescriptorFactory_Smoothness_SmoothNone;
        }
        if (Smoothness.NORMAL_LITERAL.equals(literal)) {
            return DiagramUIMessages.PropertyDescriptorFactory_Smoothness_SmoothNormal;
        }
        if (Smoothness.LESS_LITERAL.equals(literal)) {
            return DiagramUIMessages.PropertyDescriptorFactory_Smoothness_SmoothLess;
        }
        if (Smoothness.MORE_LITERAL.equals(literal)) {
            return DiagramUIMessages.PropertyDescriptorFactory_Smoothness_SmoothMore;
        }
        if (Routing.MANUAL_LITERAL.equals(literal)) {
            return DiagramUIMessages.ConnectionAppearancePropertySection_Router_Manual;
        }
        if (Routing.RECTILINEAR_LITERAL.equals(literal)) {
            return DiagramUIMessages.ConnectionAppearancePropertySection_Router_Rectilinear;
        }
        if (Routing.TREE_LITERAL.equals(literal)) {
            return DiagramUIMessages.ConnectionAppearancePropertySection_Router_Tree;
        }
        assert (false) : "No translated string available.";
        return "";
    }

    public boolean performOk() {
        boolean result = super.performOk();
        if (this.coreFields != null) {
            for (FieldEditor pe : this.coreFields) {
                pe.store();
                if (!(pe instanceof SpecificFieldEditor)) continue;
                ((SpecificFieldEditor)pe).setPresentsDefaultValue(false);
            }
        }
        return result;
    }

    protected void performDefaults() {
        super.performDefaults();
        if (this.coreFields != null) {
            for (FieldEditor pe : this.coreFields) {
                pe.loadDefault();
            }
        }
        this.checkState();
        this.enableLineStyleField(this.enableLineStyleOverrideFieldEditor.getBooleanValue());
        this.enableJumpLinkField(this.enableJumpLinkOverrideFieldEditor.getBooleanValue());
    }

    public void setCorePreferenceStore(IPreferenceStore store) {
        this.diagramCorePreferenceStore = store;
    }

    public IPreferenceStore getCorePreferenceStore() {
        if (this.diagramCorePreferenceStore == null) {
            this.diagramCorePreferenceStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.sirius.diagram");
        }
        return this.diagramCorePreferenceStore;
    }

    protected void checkState() {
        super.checkState();
        boolean valid = this.isValid();
        if (valid) {
            this.invalidCoreFieldEditor = null;
            if (this.coreFields != null) {
                int size = this.coreFields.size();
                int i = 0;
                while (i < size) {
                    FieldEditor editor = this.coreFields.get(i);
                    boolean bl = valid = valid && editor.isValid();
                    if (!valid) {
                        this.invalidCoreFieldEditor = editor;
                        break;
                    }
                    ++i;
                }
            }
            this.setValid(valid);
        }
    }

    public void dispose() {
        super.dispose();
        if (this.coreFields != null) {
            for (FieldEditor pe : this.coreFields) {
                pe.setPage(null);
                pe.setPropertyChangeListener(null);
                pe.setPreferenceStore(null);
            }
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.invalidCoreFieldEditor != null) {
            this.invalidCoreFieldEditor.setFocus();
        }
    }

    class SpecificCheckBoxFieldEditor
    extends CheckBoxFieldEditor
    implements SpecificFieldEditor {
        int numColumns;

        public SpecificCheckBoxFieldEditor(String name, String label, Composite aParent, int numColumns) {
            super(name, label, aParent);
            this.numColumns = numColumns;
        }

        protected void createControl(Composite parent) {
            this.doFillIntoGrid(parent, this.numColumns);
        }

        @Override
        public void setPresentsDefaultValue(boolean booleanValue) {
            super.setPresentsDefaultValue(booleanValue);
        }
    }

    class SpecificComboFieldEditor
    extends ComboFieldEditor
    implements SpecificFieldEditor {
        public SpecificComboFieldEditor(String name, String labelText, Composite parent, int aType, boolean aSeparateLine, int anIndent, int aWidth, boolean aReadOnly) {
            super(name, labelText, parent, aType, aSeparateLine, anIndent, aWidth, aReadOnly);
        }

        protected void createControl(Composite parent) {
            this.doFillIntoGrid(parent, 2);
        }

        protected void doFillIntoGrid(Composite parent, int numColumns) {
            GridData gd = new GridData();
            gd.horizontalSpan = numColumns;
            if (this.width == 0) {
                gd.horizontalAlignment = 4;
                gd.grabExcessHorizontalSpace = true;
            } else {
                gd.widthHint = this.width;
            }
            int flags = 12292;
            if (this.readOnly) {
                flags |= 8;
            }
            this.combo = new Combo(parent, flags);
            this.combo.setLayoutData((Object)gd);
        }

        @Override
        public void setPresentsDefaultValue(boolean booleanValue) {
            super.setPresentsDefaultValue(booleanValue);
        }
    }

    static interface SpecificFieldEditor {
        public void setPresentsDefaultValue(boolean var1);
    }

    class SpecificRadioGroupFieldEditor
    extends RadioGroupFieldEditor
    implements SpecificFieldEditor {
        public SpecificRadioGroupFieldEditor(String name, String labelText, int numColumns, String[][] labelAndValues, Composite parent, boolean useGroup) {
            super(name, labelText, numColumns, labelAndValues, parent, useGroup);
        }

        protected void createControl(Composite parent) {
            this.doFillIntoGrid(parent, 1);
        }

        @Override
        public void setPresentsDefaultValue(boolean booleanValue) {
            super.setPresentsDefaultValue(booleanValue);
        }
    }
}

