/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.edit.parts;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.ResizableEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.Dot;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractNotSelectableShapeNodeEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramBorderNodeEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IStyleEditPart;
import org.eclipse.sirius.diagram.ui.edit.internal.part.DiagramBorderNodeEditPartOperation;
import org.eclipse.sirius.diagram.ui.edit.internal.part.DiagramElementEditPartOperation;
import org.eclipse.sirius.diagram.ui.edit.internal.part.DiagramNodeEditPartOperation;
import org.eclipse.sirius.diagram.ui.internal.edit.policies.FixedLayoutEditPolicy;
import org.eclipse.sirius.ext.draw2d.figure.AbstractTransparentEllipse;
import org.eclipse.sirius.ext.draw2d.figure.ITransparentFigure;
import org.eclipse.sirius.ext.gmf.runtime.gef.ui.figures.AirStyleDefaultSizeNodeFigure;
import org.eclipse.sirius.ui.tools.api.color.VisualBindingManager;
import org.eclipse.sirius.viewpoint.LabelStyle;
import org.eclipse.sirius.viewpoint.RGBValues;

public class DotEditPart
extends AbstractNotSelectableShapeNodeEditPart
implements IStyleEditPart {
    public static final int VISUAL_ID = 3002;
    protected IFigure contentPane;
    protected IFigure primaryShape;
    private IFigure nodePlate;

    public DragTracker getDragTracker(Request request) {
        return this.getParent().getDragTracker(request);
    }

    public DotEditPart(View view) {
        super(view);
    }

    protected void refreshBackgroundColor() {
        RGBValues rgb;
        super.refreshBackgroundColor();
        EObject element = this.resolveSemanticElement();
        if (this.getMetamodelType().isInstance(element) && (rgb = ((Dot)element).getBackgroundColor()) != null) {
            this.getPrimaryShape().setBackgroundColor(VisualBindingManager.getDefault().getColorFromRGBValues(rgb));
        }
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        EObject element = this.resolveSemanticElement();
        if (element instanceof LabelStyle) {
            if (element instanceof Dot) {
                Dot dot = (Dot)element;
                int borderSize = 0;
                if (dot.getBorderSize() != null) {
                    borderSize = dot.getBorderSize();
                }
                this.getPrimaryShape().setLineWidth(borderSize);
            }
            DiagramNodeEditPartOperation.refreshFigure(this);
            DiagramElementEditPartOperation.refreshLabelAlignment(((GraphicalEditPart)this.getParent()).getContentPane(), (LabelStyle)element);
        }
    }

    protected void refreshForegroundColor() {
        Dot dot;
        if (this.getMetamodelType().isInstance(this.resolveSemanticElement()) && (dot = (Dot)this.resolveSemanticElement()).getBorderColor() != null) {
            this.getPrimaryShape().setForegroundColor(VisualBindingManager.getDefault().getColorFromRGBValues(dot.getBorderColor()));
        }
    }

    protected void createDefaultEditPolicies() {
    }

    protected LayoutEditPolicy createLayoutEditPolicy() {
        return new FixedLayoutEditPolicy();
    }

    protected IFigure createNodeShape() {
        DotFigure dot = new DotFigure();
        EditPart parent = this.getParent();
        if (parent instanceof IDiagramBorderNodeEditPart) {
            DiagramBorderNodeEditPartOperation.updateTransparencyMode((IDiagramBorderNodeEditPart)parent, (ITransparentFigure)dot);
        }
        this.primaryShape = dot;
        return this.primaryShape;
    }

    public DotFigure getPrimaryShape() {
        return (DotFigure)this.primaryShape;
    }

    protected NodeFigure createNodePlate() {
        AirStyleDefaultSizeNodeFigure result = new AirStyleDefaultSizeNodeFigure(this.getMapMode().DPtoLP(40), this.getMapMode().DPtoLP(40));
        this.nodePlate = result;
        return result;
    }

    public EditPolicy getPrimaryDragEditPolicy() {
        EditPolicy result = super.getPrimaryDragEditPolicy();
        if (result instanceof ResizableEditPolicy) {
            ResizableEditPolicy ep = (ResizableEditPolicy)result;
            ep.setResizeDirections(0);
        }
        return result;
    }

    protected NodeFigure createNodeFigure() {
        NodeFigure figure = this.createNodePlate();
        figure.setLayoutManager((LayoutManager)new StackLayout());
        IFigure shape = this.createNodeShape();
        figure.add(shape);
        this.contentPane = this.setupContentPane(shape);
        return figure;
    }

    protected IFigure setupContentPane(IFigure nodeShape) {
        return nodeShape;
    }

    public IFigure getContentPane() {
        if (this.contentPane != null) {
            return this.contentPane;
        }
        return super.getContentPane();
    }

    public IFigure getNodePlate() {
        return this.nodePlate;
    }

    protected Class<?> getMetamodelType() {
        return Dot.class;
    }

    public static class DotFigure
    extends AbstractTransparentEllipse {
        public DotFigure() {
            this.setLineWidth(3);
        }
    }
}

