/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.business.internal.layout;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.SequenceDiagram;
import org.eclipse.sirius.diagram.sequence.business.internal.layout.AbstractSequenceLayout;

public abstract class AbstractSequenceOrderingLayout<S, T, U>
extends AbstractSequenceLayout<S, T> {
    protected final List<U> semanticOrdering = new ArrayList<U>();
    protected final List<U> graphicalOrdering = new ArrayList<U>();
    protected final List<U> flaggedEnds = new ArrayList<U>();
    protected final Map<S, Rectangle> oldFlaggedLayoutData = new HashMap<S, Rectangle>();
    private boolean allOrderingInSync;

    public AbstractSequenceOrderingLayout(SequenceDiagram sequenceDiagram) {
        super(sequenceDiagram);
    }

    @Override
    protected void dispose() {
        this.semanticOrdering.clear();
        this.graphicalOrdering.clear();
        this.flaggedEnds.clear();
        this.oldFlaggedLayoutData.clear();
        super.dispose();
    }

    protected int getDeltaStablePosition(int currentPos, U element, Map<? extends U, Integer> alreadyComputedLocations) {
        int deltaStablePos = currentPos;
        int semanticIndex = this.semanticOrdering.indexOf(element);
        int graphicalIndex = this.graphicalOrdering.indexOf(element);
        int flaggedIndex = this.flaggedEnds.indexOf(element);
        if (flaggedIndex != -1 && semanticIndex != 0 && graphicalIndex != -1) {
            Function<U, Integer> oldPosition = this.getOldPosition();
            Object flaggedPred = null;
            if (this.allOrderingInSync && semanticIndex == flaggedIndex && semanticIndex == graphicalIndex) {
                int predecessorIndex = graphicalIndex - 1;
                flaggedPred = this.graphicalOrdering.get(predecessorIndex);
            } else {
                LinkedHashSet<Object> semanticPredecessors = new LinkedHashSet<U>(this.semanticOrdering.subList(0, semanticIndex));
                LinkedHashSet<Object> graphicalPredecessors = new LinkedHashSet<U>(this.graphicalOrdering.subList(0, graphicalIndex));
                Sets.SetView flaggedPredecessors = new LinkedHashSet(this.flaggedEnds.subList(0, flaggedIndex));
                LinkedHashSet<U> flaggedEndsSet = new LinkedHashSet<U>(this.flaggedEnds);
                semanticPredecessors = new LinkedHashSet(Sets.intersection(semanticPredecessors, flaggedEndsSet));
                graphicalPredecessors = new LinkedHashSet(Sets.intersection(graphicalPredecessors, flaggedEndsSet));
                flaggedPredecessors = Sets.intersection(flaggedPredecessors, semanticPredecessors);
                Optional<U> lastGraphPredecessor = this.getLastGraphPredecessorIfEquals(semanticPredecessors, graphicalPredecessors);
                if (lastGraphPredecessor.isPresent()) {
                    flaggedPred = lastGraphPredecessor.get();
                } else {
                    oldPosition = this.getOldFlaggedPosition();
                    Optional<U> potentialSafePred = this.getLastFlaggedPredecessor((Set<U>)semanticPredecessors, (Iterable<U>)flaggedPredecessors);
                    if (potentialSafePred.isPresent()) {
                        flaggedPred = potentialSafePred.get();
                    }
                }
            }
            if (flaggedPred != null) {
                Integer predY = (Integer)oldPosition.apply(flaggedPred);
                Integer flaggedY = (Integer)oldPosition.apply(element);
                int delta = flaggedY - predY;
                if (delta >= 0) {
                    deltaStablePos = alreadyComputedLocations.get(flaggedPred) + delta;
                }
            }
        }
        return deltaStablePos;
    }

    private Optional<U> getLastGraphPredecessorIfEquals(Set<U> semanticPredecessors, Set<U> graphicalPredecessors) {
        Optional<Object> result;
        if (semanticPredecessors.size() != graphicalPredecessors.size()) {
            result = Optional.empty();
        } else {
            Iterator<U> graphicalPredecessorsIterator = graphicalPredecessors.iterator();
            Iterator<U> semanticPredecessorsIterator = semanticPredecessors.iterator();
            Object lastGraphPredecessor = null;
            while (graphicalPredecessorsIterator.hasNext() && semanticPredecessorsIterator.hasNext()) {
                U semPred;
                U graphPred = graphicalPredecessorsIterator.next();
                if (!graphPred.equals(semPred = semanticPredecessorsIterator.next())) {
                    return Optional.empty();
                }
                lastGraphPredecessor = graphPred;
            }
            result = Optional.ofNullable(lastGraphPredecessor);
        }
        return result;
    }

    private Optional<U> getLastFlaggedPredecessor(Set<U> semanticPredecessors, Iterable<U> flaggedPredecessors) {
        Object potentialSafePred = null;
        Iterator<U> semanticPredecessorsIterator = semanticPredecessors.iterator();
        Iterator<U> flaggedPredecessorsIterator = flaggedPredecessors.iterator();
        while (flaggedPredecessorsIterator.hasNext() && semanticPredecessorsIterator.hasNext()) {
            U flaggedPot = flaggedPredecessorsIterator.next();
            U semPot = semanticPredecessorsIterator.next();
            if (semPot == null || !semPot.equals(flaggedPot)) continue;
            potentialSafePred = semPot;
        }
        return Optional.ofNullable(potentialSafePred);
    }

    protected void checkOrderingSync() {
        this.allOrderingInSync = Iterables.elementsEqual(this.semanticOrdering, this.graphicalOrdering) && Iterables.elementsEqual(this.semanticOrdering, this.flaggedEnds);
    }

    protected abstract Function<U, Integer> getOldPosition();

    protected abstract Function<U, Integer> getOldFlaggedPosition();
}

