/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.validator;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.InstanceRole;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.SequenceDiagram;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.validator.AbstractInstanceRoleValidator;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.util.RequestQuery;

public class InstanceRoleResizeValidator
extends AbstractInstanceRoleValidator {
    private Map<InstanceRole, Dimension> sizeDeltas = new HashMap<InstanceRole, Dimension>();

    @Override
    public boolean isValid(ChangeBoundsRequest request) {
        boolean valid = super.isValid(request);
        if (this.instanceRoles.size() != 0) {
            SequenceDiagram sequenceDiagram = ((InstanceRole)this.instanceRoles.get(0)).getDiagram();
            List preResizeOrder = sequenceDiagram.getSortedInstanceRole();
            RequestQuery query = new RequestQuery((Request)request);
            Rectangle logicalDelta = query.getLogicalDelta();
            Point moveDelta = logicalDelta.getLocation();
            moveDelta.y = 0;
            Dimension sizeDelta = logicalDelta.getSize();
            for (InstanceRole instanceRole : this.instanceRoles) {
                this.moveDeltas.put(instanceRole, moveDelta.getCopy());
                this.sizeDeltas.put(instanceRole, sizeDelta.getCopy());
                Rectangle boundBeforeResizing = instanceRole.getBounds();
                Rectangle boundAfterResizing = boundBeforeResizing.getTranslated(moveDelta).resize(sizeDelta);
                if (boundAfterResizing.width > 0) continue;
                valid = false;
            }
            List<InstanceRole> postResizeOrder = this.getPostResizeOrder(preResizeOrder);
            if (!Iterables.elementsEqual((Iterable)preResizeOrder, postResizeOrder)) {
                valid = false;
            }
        }
        return valid;
    }

    private List<InstanceRole> getPostResizeOrder(List<InstanceRole> allInstanceRoles) {
        ArrayList<InstanceRole> result = new ArrayList<InstanceRole>(allInstanceRoles);
        this.comparator.setMoveDeltas(this.moveDeltas);
        Collections.sort(result, this.comparator);
        this.comparator.setMoveDeltas(null);
        return result;
    }

    public Map<InstanceRole, Dimension> getSizeDeltas() {
        return this.sizeDeltas;
    }
}

