/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.jaxws.editor;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.scout.sdk.core.util.Strings;
import org.eclipse.scout.sdk.s2e.ui.internal.jaxws.editor.WebServiceEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class ErrorFormPage
extends FormPage {
    private final Throwable m_throwable;
    private final String m_message;

    public ErrorFormPage(FormEditor editor, String message, Throwable throwable) {
        super(editor, "ErrorFormPage", "Error");
        this.m_message = message;
        this.m_throwable = throwable;
    }

    public WebServiceEditor getEditor() {
        return (WebServiceEditor)super.getEditor();
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        Composite parent = form.getBody();
        StringBuilder msgBuilder = new StringBuilder();
        if (Strings.hasText((CharSequence)this.m_message)) {
            msgBuilder.append(this.m_message).append(System.lineSeparator());
        }
        if (this.m_throwable != null) {
            msgBuilder.append(Strings.fromThrowable((Throwable)this.m_throwable));
        }
        Text text = toolkit.createText(parent, msgBuilder.toString(), 2);
        text.setEditable(false);
        GridLayoutFactory.swtDefaults().applyTo(parent);
        GridDataFactory.defaultsFor((Control)text).align(4, 0x1000000).grab(true, false).applyTo((Control)text);
    }
}

