/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.useractions.ui.compile;

import java.util.Hashtable;
import org.eclipse.core.resources.IFolder;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.internal.useractions.UserActionsPersistenceUtil;
import org.eclipse.rse.internal.useractions.api.ui.compile.SystemCascadingCompileAction;
import org.eclipse.rse.internal.useractions.ui.SystemCmdSubstVarList;
import org.eclipse.rse.internal.useractions.ui.compile.ISystemCompileCommandEditPaneHoster;
import org.eclipse.rse.internal.useractions.ui.compile.ISystemCompileCommandSubstitutor;
import org.eclipse.rse.internal.useractions.ui.compile.SystemCompileCommand;
import org.eclipse.rse.internal.useractions.ui.compile.SystemCompileCommandEditPane;
import org.eclipse.rse.internal.useractions.ui.compile.SystemCompileMultipleSelectAction;
import org.eclipse.rse.internal.useractions.ui.compile.SystemCompileProfile;
import org.eclipse.rse.internal.useractions.ui.compile.SystemDefaultCompileCommand;
import org.eclipse.rse.internal.useractions.ui.compile.SystemDefaultCompileCommands;
import org.eclipse.rse.internal.useractions.ui.compile.SystemNewCompileSrcTypeDialog;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDAResources;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.subsystems.files.core.subsystems.IVirtualRemoteFile;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.rse.ui.SystemMenuManager;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;
import org.eclipse.rse.ui.view.SystemAdapterHelpers;
import org.eclipse.swt.widgets.Shell;

public abstract class SystemCompileManager {
    private Hashtable compileProfilesPerProfile = new Hashtable();
    private Hashtable compileSubstitutorsPerConnection = new Hashtable();
    protected IHost systemConnection;
    protected String osType = "default";
    protected ISubSystemConfiguration subsystemFactory;
    protected SystemCompileCommand currentCompileCommand;

    public void setSubSystemFactory(ISubSystemConfiguration ssFactory) {
        this.subsystemFactory = ssFactory;
    }

    public ISubSystemConfiguration getSubSystemFactory() {
        return this.subsystemFactory;
    }

    public void setSystemConnection(IHost systemConnection) {
        this.systemConnection = systemConnection;
    }

    public IHost getSystemConnection() {
        return this.systemConnection;
    }

    public void setCurrentCompileCommand(SystemCompileCommand compileCmd) {
        this.currentCompileCommand = compileCmd;
    }

    public SystemCompileCommand getCurrentCompileCommand() {
        return this.currentCompileCommand;
    }

    public boolean isMultiSelectSupported(SystemCompileCommand compileCmd) {
        return true;
    }

    public SystemCompileProfile getCompileProfile(ISystemProfile profile) {
        SystemCompileProfile cprofile;
        if (this.compileProfilesPerProfile == null) {
            this.compileProfilesPerProfile = new Hashtable();
        }
        if ((cprofile = (SystemCompileProfile)this.compileProfilesPerProfile.get(profile)) == null && (cprofile = this.createCompileProfile(profile)) != null) {
            this.compileProfilesPerProfile.put(profile, cprofile);
        }
        return cprofile;
    }

    public SystemCompileProfile[] getAllCompileProfiles() {
        ISystemProfile[] systemProfiles = RSECorePlugin.getTheSystemProfileManager().getActiveSystemProfiles();
        SystemCompileProfile[] compProfiles = null;
        if (systemProfiles != null && systemProfiles.length > 0) {
            compProfiles = new SystemCompileProfile[systemProfiles.length];
            int idx = 0;
            while (idx < systemProfiles.length) {
                compProfiles[idx] = this.getCompileProfile(systemProfiles[idx]);
                ++idx;
            }
        }
        return compProfiles;
    }

    protected abstract SystemCompileProfile createCompileProfile(ISystemProfile var1);

    public IFolder getCompileProfileFolder(SystemCompileProfile compProfile) {
        ISystemProfile systemProfile = this.getSystemProfile(compProfile);
        if (systemProfile == null) {
            SystemMessage msg = RSEUIPlugin.getPluginMessage((String)"RSEO1012");
            msg.makeSubstitution((Object)SystemUDAResources.SystemCompileManager_0);
            SystemBasePlugin.logError((String)("In SystemCompileManager#getCompileProfileFolder, and we have gotten a null for the system profile named " + compProfile.getProfileName() + ". That should never happen!"));
            SystemMessageDialog.displayErrorMessage((Shell)SystemBasePlugin.getActiveWorkbenchShell(), (SystemMessage)msg);
        }
        IFolder folder = UserActionsPersistenceUtil.getCompileCommandsFolder(systemProfile, this.subsystemFactory);
        return folder;
    }

    public boolean wantToPrimeWithDefaults(SystemCompileProfile profile) {
        ISystemProfile systemProfile = this.getSystemProfile(profile);
        return systemProfile.isDefaultPrivate();
    }

    public abstract SystemDefaultCompileCommands getDefaultCompileCommands();

    public SystemDefaultCompileCommand getDefaultSuppliedCommand(String commandName) {
        SystemDefaultCompileCommands dftCmds = this.getDefaultCompileCommands();
        if (dftCmds == null) {
            return null;
        }
        return dftCmds.getCommand(commandName);
    }

    private ISystemProfile getSystemProfile(SystemCompileProfile compProfile) {
        ISystemProfile[] systemProfiles = RSECorePlugin.getTheSystemProfileManager().getSystemProfiles();
        String profileName = compProfile.getProfileName();
        ISystemProfile currentProfile = null;
        int idx = 0;
        while (currentProfile == null && idx < systemProfiles.length) {
            if (systemProfiles[idx].getName().equals(profileName)) {
                currentProfile = systemProfiles[idx];
            }
            ++idx;
        }
        return currentProfile;
    }

    public void profileRenamed(ISystemProfile profile, String oldName) {
        if (this.compileProfilesPerProfile == null) {
            return;
        }
        SystemCompileProfile cprofile = (SystemCompileProfile)this.compileProfilesPerProfile.get(profile);
        if (cprofile != null) {
            cprofile.setProfileName(profile.getName());
        }
    }

    public boolean isCompilable(Object selection) {
        if (selection instanceof IVirtualRemoteFile) {
            return false;
        }
        ISystemRemoteElementAdapter rmtAdapter = SystemAdapterHelpers.getRemoteAdapter((Object)selection);
        if (rmtAdapter == null) {
            return false;
        }
        String srcType = rmtAdapter.getRemoteSourceType(selection);
        if (srcType == null) {
            return false;
        }
        boolean compilable = false;
        ISystemProfile[] activeProfiles = RSECorePlugin.getTheSystemRegistry().getActiveSystemProfiles();
        int idx = 0;
        while (!compilable && idx < activeProfiles.length) {
            SystemCompileProfile compProfile = this.getCompileProfile(activeProfiles[idx]);
            compProfile.addContributions(selection);
            compilable = compProfile.getCompileType(srcType) != null;
            ++idx;
        }
        return compilable;
    }

    public void addCompileActions(Shell shell, IStructuredSelection selection, SystemMenuManager menu, String menuGroup) {
        if (selection == null || selection.getFirstElement() == null) {
            return;
        }
        int size = selection.size();
        if (size == 1) {
            this.addSingleSelectionCompileActions(shell, selection, menu, menuGroup);
        } else if (size > 1) {
            this.addMultipleSelectionCompileActions(shell, selection, menu, menuGroup);
        }
    }

    public void addSingleSelectionCompileActions(Shell shell, IStructuredSelection selection, SystemMenuManager menu, String menuGroup) {
        SystemCascadingCompileAction promptAction = new SystemCascadingCompileAction(shell, true);
        SystemCascadingCompileAction noPromptAction = new SystemCascadingCompileAction(shell, false);
        menu.add(menuGroup, (IAction)noPromptAction);
        menu.add(menuGroup, (IAction)promptAction);
    }

    public void addMultipleSelectionCompileActions(Shell shell, IStructuredSelection selection, SystemMenuManager menu, String menuGroup) {
        SystemCompileMultipleSelectAction multiAction = new SystemCompileMultipleSelectAction(shell);
        menu.add(menuGroup, (IAction)multiAction);
    }

    public abstract SystemCmdSubstVarList getSubstitutionVariableList();

    protected ISystemCompileCommandSubstitutor getSubstitutor() {
        ISystemCompileCommandSubstitutor substor = (ISystemCompileCommandSubstitutor)this.compileSubstitutorsPerConnection.get(this.systemConnection);
        if (substor == null) {
            substor = this.createSubstitutor(this.systemConnection);
            this.compileSubstitutorsPerConnection.put(this.systemConnection, substor);
        }
        return substor;
    }

    protected abstract ISystemCompileCommandSubstitutor createSubstitutor(IHost var1);

    public SystemCompileCommandEditPane getCompileCommandEditPane(Shell shell, ISystemCompileCommandEditPaneHoster hoster, boolean caseSensitive) {
        return new SystemCompileCommandEditPane(this, shell, hoster, caseSensitive);
    }

    protected SystemNewCompileSrcTypeDialog getNewSrcTypeDialog(Shell shell, boolean caseSensitive) {
        return new SystemNewCompileSrcTypeDialog(shell, this, caseSensitive);
    }

    public String getSourceTypePromptMRILabel() {
        return SystemUDAResources.RESID_WWCOMPCMDS_TYPES_LABEL;
    }

    public String getSourceTypePromptMRITooltip() {
        return SystemUDAResources.RESID_WWCOMPCMDS_TYPES_TOOLTIP;
    }

    public String getOSType() {
        return this.osType;
    }
}

