/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.widgets.services;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.IRSEModelObject;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.IServerLauncherProperties;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.widgets.services.RSEModelServiceElement;
import org.eclipse.rse.ui.widgets.services.ServerLauncherPropertiesServiceElement;
import org.eclipse.rse.ui.widgets.services.ServiceElement;
import org.eclipse.swt.graphics.Image;

public class ConnectorServiceElement
extends RSEModelServiceElement {
    private IConnectorService _connectorService;
    private ImageDescriptor _imageDescriptor;
    private ServiceElement[] _children;

    public ConnectorServiceElement(IHost host, ServiceElement parent, IConnectorService connectorService) {
        super(host, parent, (IRSEModelObject)connectorService);
        this._connectorService = connectorService;
    }

    public IConnectorService getConnectorService() {
        return this._connectorService;
    }

    public Image getImage() {
        if (this._imageDescriptor == null) {
            this._imageDescriptor = RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.connectorservice_objIcon");
        }
        return this._imageDescriptor.createImage();
    }

    public String getName() {
        return this._connectorService.getName();
    }

    public boolean internalHasChildren() {
        return this._connectorService.hasRemoteServerLauncherProperties();
    }

    public ServiceElement[] internalGetChildren() {
        if (this._children == null) {
            IServerLauncherProperties properties = this._connectorService.getRemoteServerLauncherProperties();
            ServerLauncherPropertiesServiceElement child = new ServerLauncherPropertiesServiceElement(this.getHost(), (ServiceElement)this, properties);
            return new ServiceElement[]{child};
        }
        return this._children;
    }

    public void commit() {
        if (this._childChanged) {
            super.commit();
            ServiceElement[] children = this.getChildren();
            if (children != null) {
                int i = 0;
                while (i < children.length) {
                    ServiceElement child = children[i];
                    child.commit();
                    ++i;
                }
            }
            this._connectorService.commit();
        }
    }

    public void revert() {
        super.revert();
        ServiceElement[] children = this.getChildren();
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                ServiceElement child = children[i];
                child.revert();
                ++i;
            }
        }
    }
}

