/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.widgets;

import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.internal.ui.SystemPropertyResources;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.messages.ISystemMessageLine;
import org.eclipse.rse.ui.validators.ISystemValidator;
import org.eclipse.rse.ui.validators.SystemNumericVerifyListener;
import org.eclipse.rse.ui.validators.ValidatorPortInput;
import org.eclipse.rse.ui.widgets.IInheritableEntryFieldStateChangeListener;
import org.eclipse.rse.ui.widgets.InheritableEntryField;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class SystemPortPrompt
implements SelectionListener {
    private Composite composite_prompts;
    private Label labelPort;
    private InheritableEntryField textPort;
    protected SystemMessage errorMessage;
    protected boolean portEditable = true;
    protected boolean portApplicable = true;
    protected int existingPortValue;
    protected ISystemValidator portValidator;
    protected ISystemMessageLine msgLine;

    public SystemPortPrompt(Composite parent, int style, ISystemMessageLine msgLine, boolean wantLabel, boolean isPortEditable, int existingPortValue, ISystemValidator portValidator) {
        this.composite_prompts = new Composite(parent, style);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = wantLabel ? 2 : 1;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.composite_prompts.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = false;
        this.composite_prompts.setLayoutData((Object)gridData);
        this.init(this.composite_prompts, msgLine, wantLabel, isPortEditable, existingPortValue, portValidator);
        this.composite_prompts.pack();
    }

    public SystemPortPrompt(Composite composite_prompts, ISystemMessageLine msgLine, boolean wantLabel, boolean isPortEditable, int existingPortValue, ISystemValidator portValidator) {
        this.composite_prompts = composite_prompts;
        this.init(composite_prompts, msgLine, wantLabel, isPortEditable, existingPortValue, portValidator);
    }

    public int getPort() {
        if (this.isEditable()) {
            String port = this.textPort.getLocalText();
            Integer portInteger = null;
            portInteger = this.textPort.isLocal() && port.length() > 0 ? new Integer(port) : new Integer(0);
            return portInteger;
        }
        return this.existingPortValue;
    }

    public String getPortString() {
        return this.internalGetPort();
    }

    public boolean isEditable() {
        return this.portEditable && this.portApplicable;
    }

    public boolean isComplete() {
        if (!this.isEditable()) {
            return true;
        }
        return this.errorMessage == null && this.internalGetPort().length() > 0;
    }

    public void setPort(int port) {
        if (this.portEditable || this.portApplicable) {
            String localPort = null;
            localPort = "" + port;
            int iPort = port;
            if (!this.portEditable) {
                this.labelPort.setText(localPort);
            } else {
                this.textPort.setLocalText(localPort);
                this.textPort.setInheritedText(NLS.bind((String)SystemPropertyResources.RESID_PORT_DYNAMICSELECT, (Object)new Integer(0)));
                this.textPort.setLocal(iPort != 0);
            }
        }
    }

    public boolean setFocus() {
        if (this.textPort != null) {
            this.textPort.getTextField().setFocus();
            return true;
        }
        return this.composite_prompts.setFocus();
    }

    public void setDefault() {
        this.setPort(this.existingPortValue);
    }

    public Control getPortField() {
        if (this.textPort != null) {
            return this.textPort.getTextField();
        }
        return this.labelPort;
    }

    public SystemMessage validatePortInput() {
        boolean wasInError = this.errorMessage != null;
        this.errorMessage = null;
        if (this.textPort != null) {
            if (!this.textPort.isLocal()) {
                if (wasInError) {
                    this.clearErrorMessage();
                }
                return null;
            }
            if (this.portValidator != null) {
                this.errorMessage = this.portValidator.validate(this.textPort.getText().trim());
            } else if (this.internalGetPort().equals("")) {
                this.errorMessage = RSEUIPlugin.getPluginMessage("RSEG1025");
            }
        }
        if (this.errorMessage == null) {
            if (wasInError) {
                this.clearErrorMessage();
            }
        } else {
            this.setErrorMessage(this.errorMessage);
        }
        return this.errorMessage;
    }

    protected void init(Composite composite_prompts, ISystemMessageLine msgLine, boolean wantLabel, boolean isPortEditable, int existingPortValue, ISystemValidator portValidator) {
        this.msgLine = msgLine;
        this.portEditable = isPortEditable;
        this.existingPortValue = existingPortValue;
        if (portValidator == null) {
            portValidator = new ValidatorPortInput();
        }
        this.portValidator = portValidator;
        this.createPortPrompt(composite_prompts, wantLabel);
        this.setPort(existingPortValue);
        if (this.textPort != null) {
            this.textPort.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    SystemPortPrompt.this.validatePortInput();
                }
            });
            SystemNumericVerifyListener verifyListener = new SystemNumericVerifyListener();
            this.textPort.getTextField().addVerifyListener((VerifyListener)verifyListener);
            this.textPort.addStateChangeListener(new PortFieldStateChangeListener(verifyListener));
        }
    }

    protected String internalGetPort() {
        if (this.textPort != null) {
            return this.textPort.getText().trim();
        }
        return this.labelPort.getText();
    }

    protected void createPortPrompt(Composite composite_prompts, boolean wantLabel) {
        String portRange = " (1-65535)";
        if (wantLabel) {
            String labelText = SystemWidgetHelpers.appendColon(String.valueOf(SystemResources.RESID_SUBSYSTEM_PORT_LABEL) + portRange);
            SystemWidgetHelpers.createLabel(composite_prompts, labelText);
        }
        this.portApplicable = this.isPortApplicable();
        this.portEditable = this.isPortEditable();
        if (this.isEditable()) {
            this.textPort = SystemWidgetHelpers.createInheritableTextField(composite_prompts, SystemResources.RESID_SUBSYSTEM_PORT_INHERITBUTTON_TIP, SystemResources.RESID_SUBSYSTEM_PORT_TIP);
            this.textPort.setFocus();
        } else {
            String labelValue = " ";
            if (!this.portApplicable) {
                labelValue = this.getTranslatedNotApplicable();
            }
            this.labelPort = SystemWidgetHelpers.createLabel(composite_prompts, labelValue);
        }
    }

    protected boolean isPortApplicable() {
        return this.isPortEditable() || this.existingPortValue != -1;
    }

    protected boolean isPortEditable() {
        return this.portEditable;
    }

    private String getTranslatedNotApplicable() {
        return SystemPropertyResources.RESID_TERM_NOTAPPLICABLE;
    }

    protected void setErrorMessage(SystemMessage msg) {
        if (this.msgLine != null) {
            this.msgLine.setErrorMessage(msg);
        }
    }

    protected void clearErrorMessage() {
        if (this.msgLine != null) {
            this.msgLine.clearErrorMessage();
        }
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }

    public void widgetSelected(SelectionEvent event) {
        this.textPort.isLocal();
    }

    private class PortFieldStateChangeListener
    implements IInheritableEntryFieldStateChangeListener {
        private SystemNumericVerifyListener verifyListener;

        private PortFieldStateChangeListener(SystemNumericVerifyListener verifyListener) {
            this.verifyListener = verifyListener;
        }

        public void stateChanged(InheritableEntryField field) {
            if (field.isLocal()) {
                this.verifyListener.setOff(false);
            } else {
                this.verifyListener.setOff(true);
            }
        }
    }
}

