/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.validators;

import java.util.Collection;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.validators.ISystemValidator;
import org.eclipse.rse.ui.validators.ValidatorUniqueString;

public class ValidatorFileName
extends ValidatorUniqueString
implements ISystemValidator {
    public static final int MAX_FILENAME_LENGTH = 256;
    protected boolean fUnique;
    protected SystemMessage msg_Invalid;
    protected IWorkspace workspace = ResourcesPlugin.getWorkspace();

    public ValidatorFileName(Collection existingNameList) {
        super(existingNameList, false);
        super.setErrorMessages(RSEUIPlugin.getPluginMessage("RSEG1006"), RSEUIPlugin.getPluginMessage("RSEG1007"));
        this.fUnique = true;
        this.msg_Invalid = RSEUIPlugin.getPluginMessage("RSEG1019");
    }

    public ValidatorFileName(String[] existingNameList) {
        super(existingNameList, false);
        super.setErrorMessages(RSEUIPlugin.getPluginMessage("RSEG1006"), RSEUIPlugin.getPluginMessage("RSEG1007"));
        this.fUnique = true;
        this.msg_Invalid = RSEUIPlugin.getPluginMessage("RSEG1019");
    }

    public ValidatorFileName() {
        super(new String[0], false);
        super.setErrorMessages(RSEUIPlugin.getPluginMessage("RSEG1006"), RSEUIPlugin.getPluginMessage("RSEG1007"));
        this.fUnique = true;
        this.msg_Invalid = RSEUIPlugin.getPluginMessage("RSEG1019");
    }

    public void setErrorMessages(SystemMessage msg_Empty, SystemMessage msg_NonUnique, SystemMessage msg_Invalid) {
        super.setErrorMessages(msg_Empty, msg_NonUnique);
        this.msg_Invalid = msg_Invalid;
    }

    protected boolean checkForBadCharacters(String newText) {
        return true;
    }

    public String toString() {
        return "FileNameValidator class";
    }

    public SystemMessage isSyntaxOk(String newText) {
        IStatus rc = this.workspace.validateName(newText, 1);
        if (rc.getCode() != 0) {
            return this.msg_Invalid;
        }
        if (this.getMaximumNameLength() > 0 && newText.length() > this.getMaximumNameLength()) {
            return this.msg_Invalid;
        }
        return this.checkForBadCharacters(newText) ? null : this.msg_Invalid;
    }

    public int getMaximumNameLength() {
        return 256;
    }
}

