/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui;

import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.rse.core.ISystemResourceListener;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.SystemResourceManager;
import org.eclipse.rse.core.events.ISystemModelChangeEvent;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.internal.core.model.SystemModelChangeEvent;
import org.eclipse.rse.internal.ui.view.SystemPerspectiveHelpers;
import org.eclipse.rse.internal.ui.view.SystemView;
import org.eclipse.rse.internal.ui.view.SystemViewPart;
import org.eclipse.rse.internal.ui.view.team.SystemTeamViewPart;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class SystemResourceListener
implements ISystemResourceListener,
Runnable {
    private boolean debug;
    private boolean fullDebug;
    private static SystemResourceListener inst = null;
    private IProject remoteSystemsProject;
    private boolean ignoreEvents;
    private boolean ensureEventsOnMode;
    private boolean sawSyncEvent;
    private boolean changesPending;
    private int addRmvListenerCount;
    private Vector listeners;
    private IWorkbenchPage primaryRSEPerspective;
    private IViewPart[] primaryRSEViews;
    private int runAction;
    private static final int CLOSE_PERSPECTIVES = 1;
    private static final int CLOSE_EDITORS = 2;
    private static final int CLOSE_VIEWS = 3;
    private static final int RSE_RESTART = 4;
    private static final int OPEN_VIEWS = 5;
    private static final int FIRE_EVENT = 99;

    SystemResourceListener(IProject remoteSystemsProject) {
        this.fullDebug = this.debug = true;
        this.remoteSystemsProject = null;
        this.ignoreEvents = true;
        this.ensureEventsOnMode = false;
        this.sawSyncEvent = false;
        this.changesPending = false;
        this.primaryRSEPerspective = null;
        this.primaryRSEViews = null;
        this.runAction = 0;
        this.remoteSystemsProject = remoteSystemsProject;
    }

    public static SystemResourceListener getListener(IProject remoteSystemsProject) {
        if (inst == null) {
            inst = new SystemResourceListener(remoteSystemsProject);
        }
        return inst;
    }

    public void addResourceChangeListener(IResourceChangeListener l) {
        if (this.listeners == null) {
            this.listeners = new Vector();
            this.listeners.add(l);
        } else if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    public void removeResourceChangeListener(IResourceChangeListener l) {
        if (this.listeners != null && this.listeners.contains(l)) {
            this.listeners.remove(l);
        }
    }

    public void turnOffResourceEventListening() {
        this.ignoreEvents = true;
        --this.addRmvListenerCount;
        if (this.addRmvListenerCount < -1) {
            SystemBasePlugin.logWarning("LISTENER TURNED OFF OUT-OF-SEQUENCE ERROR: " + this.addRmvListenerCount);
        }
    }

    public void turnOnResourceEventListening() {
        ++this.addRmvListenerCount;
        if (this.addRmvListenerCount > 0) {
            this.ignoreEvents = false;
            this.sawSyncEvent = false;
            if (this.addRmvListenerCount != 1) {
                SystemBasePlugin.logWarning("LISTENER TURNED ON OUT-OF-SEQUENCE ERROR: " + this.addRmvListenerCount);
            }
        }
    }

    public void ensureOnResourceEventListening() {
        SystemBasePlugin.logInfo("INSIDE ENSUREONRESOURCEEVENTLISTENING");
        if (this.ignoreEvents) {
            SystemBasePlugin.logWarning("RESOURCE LISTENER WAS TURNED OFF. IT WAS FORCED ON");
            this.turnOnResourceEventListening();
        }
        this.ensureEventsOnMode = true;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        Object source = event.getSource();
        if (this.ignoreEvents || !(event.getSource() instanceof IWorkspace)) {
            return;
        }
        if (this.fullDebug) {
            int type = event.getType();
            String sType = SystemResourceListener.getTypeString(type);
            SystemBasePlugin.logInfo("RESOURCE CHANGED EVENT: eventType=" + sType + ", eventSource=" + event.getSource());
        }
        if (this.ensureEventsOnMode) {
            this.ensureEventsOnMode = true;
        }
        IResource resource = event.getResource();
        IResourceDelta delta = event.getDelta();
        if (resource == null && delta != null) {
            resource = delta.getResource();
        }
        if (resource != null) {
            if (resource.getProject() != null) {
                if (!resource.getProject().getName().equals(this.remoteSystemsProject.getName())) {
                    if (this.fullDebug) {
                        SystemBasePlugin.logInfo("EVENT FILTERED OUT BY PROJECT NAME");
                    }
                    return;
                }
            } else if (resource.getType() == 4) {
                if (!resource.getName().equals(this.remoteSystemsProject.getName())) {
                    if (this.fullDebug) {
                        SystemBasePlugin.logInfo("EVENT FILTERED OUT BY PROJECT NAME");
                    }
                    return;
                }
                try {
                    if (!((IProject)resource).hasNature("org.eclipse.rse.ui.remotesystemsnature")) {
                        if (this.fullDebug) {
                            SystemBasePlugin.logInfo("EVENT FILTERED OUT BY PROJECT NATURE");
                        }
                        return;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (delta != null && this.preScanForIgnore(delta)) {
            if (this.fullDebug) {
                SystemBasePlugin.logInfo("EVENT FILTERED OUT IN PRESCAN");
            }
            return;
        }
        if (this.fullDebug) {
            SystemBasePlugin.logInfo("*** RESOURCE CHANGE EVENT ALLOWED IN ***");
        }
        if (this.debug) {
            int type = event.getType();
            String sType = SystemResourceListener.getTypeString(type);
            if (!this.fullDebug) {
                SystemBasePlugin.logInfo("RESOURCE CHANGED EVENT: eventType=" + sType + ", eventSource=" + source);
            }
        }
        boolean ignored = false;
        if (delta != null) {
            if (this.sawSyncEvent) {
                this.sawSyncEvent = false;
            }
            this.changesPending = true;
        }
        if (!ignored) {
            this.fireResourceChangeEvent(event);
        }
    }

    protected void fireResourceChangeEvent(IResourceChangeEvent event) {
        if (this.listeners == null) {
            return;
        }
        int idx = 0;
        while (idx < this.listeners.size()) {
            IResourceChangeListener l = (IResourceChangeListener)this.listeners.elementAt(idx);
            l.resourceChanged(event);
            ++idx;
        }
    }

    protected boolean preScanForIgnore(IResourceDelta delta) {
        if (delta == null) {
            return true;
        }
        IResourceDelta[] subdeltas = delta.getAffectedChildren();
        if (subdeltas.length > 0) {
            IResource resource = subdeltas[0].getResource();
            int resType = 0;
            if (resource != null) {
                resType = resource.getType();
            }
            int flags = subdeltas[0].getFlags();
            if (this.debug) {
                if (this.debug) {
                    SystemBasePlugin.logInfo("...In preScanForIgnore. Kind = " + SystemResourceListener.getKindString(delta.getKind()));
                }
                if (resource == null) {
                    SystemBasePlugin.logInfo("......resource is null");
                } else {
                    SystemBasePlugin.logInfo("......resource is: " + resource.getName() + ", type is: " + this.getResourceTypeString(resType));
                }
                if (flags == 65536) {
                    SystemBasePlugin.logInfo("......flags == SYNC");
                } else {
                    SystemBasePlugin.logInfo("......flags == " + flags);
                }
            }
            if (flags == 65536) {
                this.sawSyncEvent = true;
                return true;
            }
            if (resource != null && resType == 8) {
                return true;
            }
            if (resource != null && resType == 4) {
                if (!resource.getName().equals(this.remoteSystemsProject.getName())) {
                    return true;
                }
                if (!resource.isAccessible()) {
                    return true;
                }
                try {
                    if (!((IProject)resource).hasNature("org.eclipse.rse.ui.remotesystemsnature")) {
                        return true;
                    }
                }
                catch (CoreException exc) {
                    RSECorePlugin.getDefault().getLogger().logError("Exception trying to test the natures of the project that fired a resource change event", (Throwable)exc);
                }
            }
        }
        return false;
    }

    private String getResourceTypeString(int type) {
        switch (type) {
            case 8: {
                return "root";
            }
            case 4: {
                return "project";
            }
            case 2: {
                return "folder";
            }
            case 1: {
                return "file";
            }
        }
        return "unknown: " + Integer.toString(type);
    }

    protected boolean processDelta(String indent, IResourceDelta delta) {
        int kind = delta.getKind();
        int flags = delta.getFlags();
        if (kind == 4 && flags == 65536) {
            return false;
        }
        boolean processKids = true;
        IResource resource = delta.getResource();
        String kindString = null;
        String pre = null;
        if (this.debug) {
            kindString = SystemResourceListener.getKindString(kind);
            pre = String.valueOf(kindString) + ": " + indent;
            SystemBasePlugin.logInfo(String.valueOf(pre) + delta + ": flags: " + SystemResourceListener.getKindString(flags));
        }
        if (resource == null) {
            return true;
        }
        int resourceType = resource.getType();
        switch (kind) {
            case 1: {
                break;
            }
            case 4: {
                if (this.debug) {
                    SystemBasePlugin.logInfo(String.valueOf(pre) + "resource type: " + resourceType);
                }
                if (resourceType != 4) break;
                try {
                    if (((IProject)resource).hasNature("org.eclipse.rse.ui.remotesystemsnature")) break;
                    if (this.debug) {
                        SystemBasePlugin.logInfo("EVENT DELTA FILTERED OUT BY PROJECT NATURE");
                    }
                    return false;
                }
                catch (Exception exception) {
                    break;
                }
            }
            case 256: 
            case 262144: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                if (!this.debug) break;
                SystemBasePlugin.logInfo(String.valueOf(kindString) + " DELTA IGNORED");
            }
        }
        boolean stop = false;
        if (processKids) {
            IResourceDelta[] subdeltas = delta.getAffectedChildren();
            int i = 0;
            while (!stop && i < subdeltas.length) {
                stop = !this.processDelta(String.valueOf(indent) + "   ", subdeltas[i]);
                ++i;
            }
        }
        return !stop;
    }

    public static String getKindString(int kind) {
        String kindString = "Unknown: " + Integer.toString(kind);
        switch (kind) {
            case 1: {
                kindString = "ADDED";
                break;
            }
            case 8: {
                kindString = "ADDED_PHANTOM";
                break;
            }
            case 31: {
                kindString = "ALL_WITH_PHANTOMS";
                break;
            }
            case 4: {
                kindString = "CHANGED";
                break;
            }
            case 256: {
                kindString = "CONTENT";
                break;
            }
            case 524288: {
                kindString = "DESCRIPTION";
                break;
            }
            case 131072: {
                kindString = "ADDED";
                break;
            }
            case 4096: {
                kindString = "MOVED_FROM";
                break;
            }
            case 8192: {
                kindString = "MOVED_TO";
                break;
            }
            case 0: {
                kindString = "NO_CHANGE";
                break;
            }
            case 16384: {
                kindString = "OPEN";
                break;
            }
            case 2: {
                kindString = "REMOVED";
                break;
            }
            case 16: {
                kindString = "REMOVED_PHANTOM";
                break;
            }
            case 262144: {
                kindString = "REPLACED";
                break;
            }
            case 65536: {
                kindString = "SYNC";
                break;
            }
            case 32768: {
                kindString = "TYPE";
            }
        }
        return kindString;
    }

    public static String getTypeString(int type) {
        String typeString = "Unknown: " + Integer.toString(type);
        switch (type) {
            case 1: {
                typeString = "POST_CHANGE";
                break;
            }
            case 16: {
                typeString = "POST_BUILD";
                break;
            }
            case 4: {
                typeString = "PRE_DELETE";
                break;
            }
            case 2: {
                typeString = "PRE_CLOSE";
                break;
            }
            case 8: {
                typeString = "PRE_BUILD";
            }
        }
        return typeString;
    }

    private void closeRSEPerspectives() {
        this.primaryRSEPerspective = null;
        this.primaryRSEViews = null;
        IWorkbenchPage[] rsePages = this.getRSEPerspectives();
        IWorkbench wb = PlatformUI.getWorkbench();
        if (wb == null) {
            SystemBasePlugin.logInfo("PlatformUI.getWorkbench() returned null!!");
        } else {
            IWorkbenchWindow wbw = wb.getActiveWorkbenchWindow();
            if (wbw == null) {
                SystemBasePlugin.logInfo("Active workbench window is null");
            }
            if (this.primaryRSEPerspective != null && wbw != null && wbw.getActivePage() != this.primaryRSEPerspective) {
                wbw.setActivePage(this.primaryRSEPerspective);
            }
        }
        if (rsePages != null && rsePages.length > 0) {
            int idx = 0;
            while (idx < rsePages.length) {
                IWorkbenchPage rsePage = rsePages[idx];
                rsePage.close();
                ++idx;
            }
        }
        if (this.primaryRSEPerspective != null) {
            int idx;
            Vector<IViewPart> v = new Vector<IViewPart>();
            IViewReference[] views = this.primaryRSEPerspective.getViewReferences();
            if (views != null) {
                idx = 0;
                while (idx < views.length) {
                    if (!(views[idx].getView(false) instanceof SystemViewPart) && !(views[idx].getView(false) instanceof SystemTeamViewPart)) {
                        v.addElement(views[idx].getView(false));
                    }
                    ++idx;
                }
            }
            this.primaryRSEViews = new IViewPart[v.size()];
            idx = 0;
            while (idx < v.size()) {
                this.primaryRSEViews[idx] = (IViewPart)v.elementAt(idx);
                ++idx;
            }
        }
    }

    private SystemView getRSEView() {
        return SystemPerspectiveHelpers.findRSEView();
    }

    private IWorkbenchPage[] getRSEPerspectives() {
        ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchWindow[] wbWindows = wb.getWorkbenchWindows();
        Vector<IWorkbenchPage> v = new Vector<IWorkbenchPage>();
        int idx = 0;
        while (idx < wbWindows.length) {
            IWorkbenchPage[] pages = wbWindows[idx].getPages();
            if (pages != null) {
                int jdx = 0;
                while (jdx < pages.length) {
                    if (pages[jdx].getPerspective().getId().equals("org.eclipse.rse.ui.view.SystemPerspective")) {
                        SystemView sv = this.getSystemView(pages[jdx]);
                        if (sv != null && sv.getInput() != sr) {
                            v.addElement(pages[jdx]);
                        } else if (sv != null) {
                            this.primaryRSEPerspective = pages[jdx];
                        }
                    }
                    ++jdx;
                }
            }
            ++idx;
        }
        IWorkbenchPage[] ourPages = new IWorkbenchPage[v.size()];
        int idx2 = 0;
        while (idx2 < ourPages.length) {
            ourPages[idx2] = (IWorkbenchPage)v.elementAt(idx2);
            ++idx2;
        }
        return ourPages;
    }

    private SystemView getSystemView(IWorkbenchPage page) {
        IViewReference[] views = page.getViewReferences();
        if (views != null) {
            int idx = 0;
            while (idx < views.length) {
                if (views[idx].getView(false) instanceof SystemViewPart) {
                    return ((SystemViewPart)views[idx].getView(false)).getSystemView();
                }
                ++idx;
            }
        }
        return null;
    }

    public void run() {
        if (this.runAction == 1) {
            this.closeRSEPerspectives();
        } else if (this.runAction == 2) {
            this.closeEditors();
        } else if (this.runAction == 3) {
            this.closeViews();
        } else if (this.runAction == 4) {
            RSEUIPlugin.getDefault().restart();
        } else if (this.runAction == 5) {
            this.openViews();
        } else if (this.runAction == 99) {
            RSECorePlugin.getTheSystemRegistry().fireEvent((ISystemModelChangeEvent)new SystemModelChangeEvent(128, 9999, (Object)"dummy"));
        }
    }

    protected void closeEditors() {
    }

    protected void closeViews() {
        if (this.primaryRSEViews != null) {
            int idx = 0;
            while (idx < this.primaryRSEViews.length) {
                ++idx;
            }
        }
    }

    protected void openViews() {
        if (this.primaryRSEViews != null) {
            int idx = 0;
            while (idx < this.primaryRSEViews.length) {
                IViewPart cfr_ignored_0 = this.primaryRSEViews[idx];
                ++idx;
            }
        }
    }

    public static boolean changesPending() {
        SystemResourceListener us = null;
        us = inst == null ? SystemResourceListener.getListener(SystemResourceManager.getRemoteSystemsProject((boolean)false)) : inst;
        return us.changesPending;
    }

    public static void reloadRSE() {
        SystemResourceListener us = null;
        us = inst == null ? SystemResourceListener.getListener(SystemResourceManager.getRemoteSystemsProject((boolean)false)) : inst;
        Display d = Display.getCurrent();
        if (d == null) {
            d = Display.getDefault();
        }
        if (d == null) {
            SystemBasePlugin.logInfo("Hmm, can't get the display");
            SystemView sv = us.getRSEView();
            if (sv != null) {
                d = sv.getShell().getDisplay();
            } else {
                SystemBasePlugin.logInfo("Hmm, really can't get the display");
            }
        }
        us.runAction = 2;
        if (d != null) {
            d.syncExec((Runnable)us);
        } else {
            us.run();
        }
        us.runAction = 1;
        if (d != null) {
            d.syncExec((Runnable)us);
        } else {
            us.run();
        }
        us.runAction = 3;
        if (d != null) {
            d.syncExec((Runnable)us);
        } else {
            us.run();
        }
        us.runAction = 4;
        if (d != null) {
            d.syncExec((Runnable)us);
        } else {
            us.run();
        }
        us.runAction = 5;
        if (d != null) {
            d.syncExec((Runnable)us);
        } else {
            us.run();
        }
        us.changesPending = false;
        us.runAction = 99;
        if (d != null) {
            d.syncExec((Runnable)us);
        } else {
            us.run();
        }
    }
}

