/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.subsystems.files.core.servicesubsystem;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.events.ISystemRemoteChangeEvent;
import org.eclipse.rse.core.events.SystemRemoteChangeEvent;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;

public class FileSubSystemInputStream
extends InputStream {
    private InputStream _inStream;
    private String _remoteParent;
    private String _remoteFile;
    private IRemoteFileSubSystem _fs;

    public FileSubSystemInputStream(InputStream inStream, String remoteParent, String remoteFile, IRemoteFileSubSystem fs) {
        this._inStream = inStream;
        this._remoteParent = remoteParent;
        this._remoteFile = remoteFile;
        this._fs = fs;
    }

    public int available() throws IOException {
        return this._inStream.available();
    }

    public void close() throws IOException {
        this._inStream.close();
        ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
        sr.fireEvent((ISystemRemoteChangeEvent)new SystemRemoteChangeEvent(20, (Object)this._remoteParent, (Object)this._remoteFile, (ISubSystem)this._fs));
    }

    public synchronized void mark(int readlimit) {
        this._inStream.mark(readlimit);
    }

    public boolean markSupported() {
        return this._inStream.markSupported();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this._inStream.read(b, off, len);
    }

    public int read(byte[] b) throws IOException {
        return this._inStream.read(b);
    }

    public synchronized void reset() throws IOException {
        this._inStream.reset();
    }

    public long skip(long n) throws IOException {
        return this._inStream.skip(n);
    }

    public int read() throws IOException {
        return this._inStream.read();
    }
}

