/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services.dstore.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.dstore.extra.DomainEvent;
import org.eclipse.dstore.extra.IDomainListener;
import org.eclipse.dstore.extra.IDomainNotifier;

public class DStoreStatusMonitor
implements IDomainListener {
    protected boolean _networkDown = false;
    protected List _workingStatuses;
    protected List _cancelledStatuses;
    protected List _doneStatuses;
    protected DataStore _dataStore;

    public DStoreStatusMonitor(DataStore dataStore) {
        this._dataStore = dataStore;
        this.reInit();
    }

    public void reInit() {
        IDomainNotifier notifier;
        this._networkDown = false;
        this._workingStatuses = new ArrayList();
        this._doneStatuses = new ArrayList();
        this._cancelledStatuses = new ArrayList();
        if (this._dataStore != null && (notifier = this._dataStore.getDomainNotifier()) != null) {
            notifier.addDomainListener((IDomainListener)this);
        }
    }

    public DataStore getDataStore() {
        return this._dataStore;
    }

    public void dispose() {
        this._workingStatuses.clear();
        this._doneStatuses.clear();
        this._cancelledStatuses.clear();
        this._dataStore.getDomainNotifier().removeDomainListener((IDomainListener)this);
    }

    public boolean listeningTo(DomainEvent event) {
        if (this._workingStatuses.size() == 0) {
            return true;
        }
        DataElement parent = (DataElement)event.getParent();
        if (this._workingStatuses.contains(parent)) {
            return this.determineStatusDone(parent);
        }
        return false;
    }

    public void domainChanged(DomainEvent event) {
        boolean isStatusDone;
        if (this._workingStatuses.size() == 0) {
            return;
        }
        DataElement parent = (DataElement)event.getParent();
        if (this._workingStatuses.contains(parent) && (isStatusDone = this.determineStatusDone(parent))) {
            this.setDone(parent);
            this.notifyUpdate();
        }
    }

    public boolean determineStatusDone(DataElement status) {
        boolean statusDone = status.getAttribute(3).equals("done") || status.getAttribute(2).equals("done") || status.getAttribute(2).equals("cancelled");
        return statusDone;
    }

    public boolean isPassiveCommunicationsListener() {
        return false;
    }

    public synchronized void setDone(DataElement status) {
        this._workingStatuses.remove(status);
        this._doneStatuses.add(status);
    }

    public synchronized void setCancelled(DataElement status) {
        DataElement cmdDescriptor;
        DataElement command;
        DataStore dataStore;
        DataElement cancelDescriptor;
        this._workingStatuses.remove(status);
        this._cancelledStatuses.add(status);
        if (status != null && (cancelDescriptor = (dataStore = (command = status.getParent()).getDataStore()).localDescriptorQuery(cmdDescriptor = command.getDescriptor(), "C_CANCEL")) != null) {
            dataStore.command(cancelDescriptor, command);
        }
    }

    public synchronized void setWorking(DataElement status) {
        this._workingStatuses.add(status);
    }

    public boolean wasCancelled(DataElement status) {
        return this._cancelledStatuses.contains(status);
    }

    public boolean isNetworkDown() {
        return this._networkDown;
    }

    public DataElement waitForUpdate(DataElement status) throws InterruptedException {
        return this.waitForUpdate(status, null, 100);
    }

    public DataElement waitForUpdate(DataElement status, IProgressMonitor monitor) throws InterruptedException {
        return this.waitForUpdate(status, monitor, 100);
    }

    public DataElement waitForUpdate(DataElement status, int wait) throws InterruptedException {
        return this.waitForUpdate(status, null, wait);
    }

    public synchronized DataElement waitForUpdate(DataElement status, IProgressMonitor monitor, int wait) throws InterruptedException {
        if (this._networkDown && status.getDataStore().isConnected()) {
            this.reInit();
        }
        if (this.determineStatusDone(status)) {
            this.setDone(status);
            return status;
        }
        this.setWorking(status);
        int WaitThreshold = 50;
        if (wait > 0) {
            WaitThreshold = wait * 10;
        } else if (wait == -1) {
            WaitThreshold = -1;
        }
        int initialWaitThreshold = WaitThreshold;
        int nudges = 0;
        while (this._workingStatuses.contains(status)) {
            boolean statusDone = this.determineStatusDone(status);
            if (statusDone) {
                this.setDone(status);
                continue;
            }
            if (monitor != null && monitor.isCanceled() || !status.getDataStore().getStatus().getName().equals("okay")) {
                this.setCancelled(status);
                throw new InterruptedException();
            }
            this.waitForUpdate();
            if (!status.getDataStore().isConnected()) {
                this._networkDown = true;
            }
            if (WaitThreshold > 0) {
                --WaitThreshold;
            }
            if (WaitThreshold == 0) {
                this.wakeupServer(status);
                if (nudges >= 12) {
                    return status;
                }
                ++nudges;
                WaitThreshold = initialWaitThreshold;
                continue;
            }
            if (!this._networkDown) continue;
            this.dispose();
            throw new InterruptedException();
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataElement getCommandStatus(DataElement cmdDescriptor, DataElement subject) {
        List list = this._workingStatuses;
        synchronized (list) {
            int i = 0;
            while (i < this._workingStatuses.size()) {
                DataElement cmdSubject;
                DataElement status = (DataElement)this._workingStatuses.get(i);
                DataElement cmd = status.getParent();
                if (cmd.getDescriptor() == cmdDescriptor && subject == (cmdSubject = cmd.get(0).dereference())) {
                    return status;
                }
                ++i;
            }
        }
        return null;
    }

    private void wakeupServer(DataElement status) {
        if (status != null) {
            DataElement cmdDescriptor = this._dataStore.findCommandDescriptor("C_NOTIFICATION");
            DataElement subject = status.getParent().get(0);
            if (cmdDescriptor != null) {
                this._dataStore.command(cmdDescriptor, subject);
            }
        }
    }

    public synchronized void waitForUpdate() {
        try {
            this.wait(200L);
        }
        catch (InterruptedException e) {
            return;
        }
    }

    public synchronized void notifyUpdate() {
        this.notifyAll();
    }
}

