/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.persistence;

import java.io.File;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.rse.internal.persistence.PFFileSystemJob;
import org.eclipse.rse.internal.persistence.PFFileSystemLocation;
import org.eclipse.rse.internal.persistence.PFPersistenceAnchor;
import org.eclipse.rse.internal.persistence.PFPersistenceLocation;
import org.eclipse.rse.persistence.IRSEPersistenceProvider;
import org.eclipse.rse.persistence.dom.RSEDOM;

class PFFileSystemAnchor
implements PFPersistenceAnchor {
    private File providerFolder = null;

    public PFFileSystemAnchor(File providerFolder) {
        this.providerFolder = providerFolder;
    }

    public IStatus deleteProfileLocation(String profileName, IProgressMonitor monitor) {
        IStatus result = Status.OK_STATUS;
        File profileFolder = this.getProfileFolder(profileName);
        if (profileFolder.exists()) {
            this.delete(profileFolder);
        }
        return result;
    }

    public PFPersistenceLocation getProfileLocation(String profileLocationName) {
        File profileFolder = this.getProfileFolder(profileLocationName);
        PFFileSystemLocation result = new PFFileSystemLocation(profileFolder);
        return result;
    }

    public String[] getProfileLocationNames() {
        Vector<String> names = new Vector<String>(10);
        File[] profileCandidates = this.providerFolder.listFiles();
        int i = 0;
        while (i < profileCandidates.length) {
            String candidateName;
            File profileCandidate = profileCandidates[i];
            if (profileCandidate.isDirectory() && (candidateName = profileCandidate.getName()).startsWith("PRF")) {
                names.add(candidateName);
            }
            ++i;
        }
        String[] result = new String[names.size()];
        names.toArray(result);
        return result;
    }

    public Job makeSaveJob(RSEDOM dom, IRSEPersistenceProvider provider) {
        return new PFFileSystemJob(dom, provider);
    }

    private File getProfileFolder(String profileLocationName) {
        File profileFolder = this.getFolder(this.providerFolder, profileLocationName);
        return profileFolder;
    }

    private File getFolder(File parent, String name) {
        File folder = new File(parent, name);
        if (!folder.exists()) {
            folder.mkdir();
        }
        return folder;
    }

    private void delete(File resource) {
        if (resource.isDirectory()) {
            File[] resources = resource.listFiles();
            int i = 0;
            while (i < resources.length) {
                File child = resources[i];
                this.delete(child);
                ++i;
            }
        }
        resource.delete();
    }
}

