/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.workbench.core.condition;

import java.util.ArrayList;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.reddeer.common.logging.Logger;

public class Jobs {
    private static final Logger log = Logger.getLogger(Jobs.class);
    public static final int JOB_STATE_NONE = 0;
    public static final int JOB_STATE_SLEEPING = 1;
    public static final int JOB_STATE_WAITING = 2;
    public static final int JOB_STATE_RUNNING = 4;
    public static final String BUILDING_WORKSPACE_JOB = "Building workspace";
    public static final String LOADING_JOB = "Loading";
    public static final String COMPACTING_RESOURCE_MODEL = "Compacting resource model";

    public static String getFormattedJobDescription(Job job) {
        StringBuffer sb = new StringBuffer("");
        sb.append("P:\"");
        sb.append(job.getPriority());
        sb.append("\" S:\"");
        sb.append(Jobs.getStateName(job.getState()));
        sb.append("\" R:\"");
        sb.append(job.getResult());
        sb.append("\" N:\"");
        sb.append(job.getName());
        sb.append("\"");
        return sb.toString();
    }

    public static String getStateName(int jobState) {
        String jobStateName = "";
        if (jobState == 0) {
            jobStateName = "None";
        } else if (jobState == 1) {
            jobStateName = "Sleeping";
        } else if (jobState == 2) {
            jobStateName = "Waiting";
        } else if (jobState == 4) {
            jobStateName = "Running";
        } else {
            throw new IllegalArgumentException("Unknown JobState");
        }
        return jobStateName;
    }

    public static boolean isJobRunning(Job job) {
        return job.getState() == 4 || job.getState() == 2;
    }

    public static void printAllRunningJobs() {
        Job[] jobs;
        log.debug("Print All Running Jobs");
        Job[] jobArray = jobs = Job.getJobManager().find(null);
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            Job job = jobArray[n2];
            if (Jobs.isJobRunning(job)) {
                log.info(Jobs.getFormattedJobDescription(job));
            }
            ++n2;
        }
    }

    public static void printAllJobs() {
        Job[] jobs;
        log.debug("Print all jobs");
        Job[] jobArray = jobs = Job.getJobManager().find(null);
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            Job job = jobArray[n2];
            log.debug(Jobs.getFormattedJobDescription(job));
            ++n2;
        }
    }

    public static String[] getAllRunningJobs() {
        log.debug("Get all running jobs");
        Job[] jobs = Job.getJobManager().find(null);
        ArrayList<String> jobNames = new ArrayList<String>();
        Job[] jobArray = jobs;
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            Job job = jobArray[n2];
            if (Jobs.isJobRunning(job)) {
                jobNames.add(job.getName());
            }
            ++n2;
        }
        return jobNames.toArray(new String[0]);
    }
}

