/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.reddeer.eclipse.ui.wizards.NewRedDeerTestWizardPageOne;
import org.eclipse.reddeer.eclipse.ui.wizards.NewRedDeerTestWizardPageTwo;
import org.eclipse.reddeer.ui.Activator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class NewRedDeerTestCaseWizard
extends Wizard
implements INewWizard {
    private NewRedDeerTestWizardPageOne wizardPageOne;
    private NewRedDeerTestWizardPageTwo wizardPageTwo;
    private IWorkbench workbench;
    private IStructuredSelection selection;

    public NewRedDeerTestCaseWizard() {
        this.setWindowTitle("New RedDeer Test Case");
    }

    public void addPages() {
        this.wizardPageTwo = new NewRedDeerTestWizardPageTwo();
        this.wizardPageOne = new NewRedDeerTestWizardPageOne(this.wizardPageTwo);
        this.wizardPageOne.init(this.selection);
        this.addPage((IWizardPage)this.wizardPageOne);
        this.addPage((IWizardPage)this.wizardPageTwo);
    }

    public boolean performFinish() {
        IRunnableWithProgress runnable = this.wizardPageOne.getRunnable();
        if (this.finishPage(runnable)) {
            IType newClass = this.wizardPageOne.getCreatedType();
            IResource resource = newClass.getCompilationUnit().getResource();
            if (resource != null) {
                this.selectAndReveal(resource);
                this.openResource(resource);
            }
            return true;
        }
        return false;
    }

    protected boolean finishPage(IRunnableWithProgress runnable) {
        WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation(runnable);
        try {
            PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)this.getContainer(), (IRunnableWithProgress)op, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        }
        catch (InvocationTargetException e) {
            Activator.log(e);
            return false;
        }
        catch (InterruptedException e) {
            Activator.log(e);
            return false;
        }
        return true;
    }

    protected void selectAndReveal(IResource newResource) {
        BasicNewResourceWizard.selectAndReveal((IResource)newResource, (IWorkbenchWindow)this.workbench.getActiveWorkbenchWindow());
    }

    protected void openResource(final IResource resource) {
        Display display;
        IWorkbenchPage activePage;
        if (resource.getType() == 1 && (activePage = this.workbench.getActiveWorkbenchWindow().getActivePage()) != null && (display = Display.getDefault()) != null) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        IDE.openEditor((IWorkbenchPage)activePage, (IFile)((IFile)resource), (boolean)true);
                    }
                    catch (PartInitException e) {
                        Activator.log((Exception)((Object)e), "Cannot open newly created resource");
                    }
                }
            });
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        this.workbench = workbench;
    }
}

