/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.junit.execution.impl;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.List;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.junit.execution.TestMethodShouldRun;
import org.eclipse.reddeer.junit.extensionpoint.IIssueTracker;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.junit.runners.model.FrameworkMethod;

public class IssueIsResolved
implements TestMethodShouldRun {
    public static final String SKIP_UNRESILVED_ISSUES = "rd.skipUnresolvedIssues";
    private Logger log = new Logger(IssueIsResolved.class);

    @Override
    public boolean shouldRun(FrameworkMethod method) {
        boolean skipUnresolvedIssues = Boolean.valueOf(System.getProperty(SKIP_UNRESILVED_ISSUES, "false"));
        if (!skipUnresolvedIssues) {
            return true;
        }
        List<IIssueTracker> issueTrackers = RedDeerSuite.getIssueTrackerExtensions();
        Annotation[] annotationArray = method.getMethod().getDeclaredAnnotations();
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            for (IIssueTracker issueTracker : issueTrackers) {
                try {
                    if (!issueTracker.isIssueSupported(annotation) || issueTracker.isIssueResolved(annotation)) continue;
                    this.log.info(String.valueOf(issueTracker.getIssueStateMessage(annotation)) + ", skipping test '" + method.getName() + "'");
                    return false;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.log.warn("I/O exception occured when getting information about issue " + annotation);
                }
            }
            ++n2;
        }
        return true;
    }
}

