/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.gef.lookup;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.gef.GEFLayerException;
import org.eclipse.reddeer.gef.handler.ViewerHandler;
import org.eclipse.reddeer.gef.lookup.ViewerLookup;
import org.hamcrest.Matcher;

public class EditPartLookup {
    protected final Logger log = Logger.getLogger(this.getClass());
    private static EditPartLookup instance;

    private EditPartLookup() {
    }

    public static EditPartLookup getInstance() {
        if (instance == null) {
            instance = new EditPartLookup();
        }
        return instance;
    }

    public EditPart findEditPart(Matcher<EditPart> matcher, int index) {
        return this.findEditPart((EditPartViewer)ViewerLookup.getInstance().findGraphicalViewer(), matcher, index, null);
    }

    public EditPart findEditPart(Matcher<EditPart> matcher, int index, Comparator<EditPart> comparator) {
        return this.findEditPart((EditPartViewer)ViewerLookup.getInstance().findGraphicalViewer(), matcher, index, comparator);
    }

    public EditPart findEditPart(EditPartViewer viewer, Matcher<EditPart> matcher, int index, Comparator<EditPart> comparator) {
        List<EditPart> editParts = ViewerHandler.getInstance().getEditParts(viewer, matcher);
        if (editParts.size() <= 0) {
            throw new GEFLayerException("Cannot find edit part with matcher " + matcher + " at index " + index);
        }
        if (comparator != null) {
            Collections.sort(editParts, comparator);
        }
        return editParts.get(index);
    }
}

