/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.gef.spy.view;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.jface.viewers.TreeNodeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.reddeer.gef.handler.EditPartHandler;
import org.eclipse.reddeer.gef.lookup.ViewerLookup;
import org.eclipse.reddeer.gef.spy.TreeNodeExt;
import org.eclipse.reddeer.gef.spy.view.GEFSpyViewLabelProvider;
import org.eclipse.reddeer.workbench.core.lookup.EditorPartLookup;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class GEFSpyView
extends ViewPart {
    private TreeViewer treeViewer;

    public void createPartControl(Composite parent) {
        this.treeViewer = new TreeViewer(parent, 770);
        this.treeViewer.setContentProvider((IContentProvider)new TreeNodeContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new GEFSpyViewLabelProvider());
        this.refresh(this.treeViewer);
        this.hookRefreshAction();
        this.hookSelectAction();
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    protected void refresh(TreeViewer treeViewer) {
        EditPart editPart = null;
        try {
            IEditorPart editorPart = EditorPartLookup.getInstance().getEditor();
            editPart = ViewerLookup.getInstance().findGraphicalViewer(editorPart).getContents();
        }
        catch (Exception exception) {
            treeViewer.setInput((Object)new TreeNode[0]);
            MessageDialog.openWarning((Shell)treeViewer.getControl().getShell(), (String)"GEF View", (String)"No GEF editor was detected.");
            return;
        }
        treeViewer.setInput((Object)this.createTree(editPart));
        treeViewer.refresh();
    }

    protected TreeNode[] createTree(EditPart editPart) {
        TreeNodeExt root = new TreeNodeExt(editPart);
        this.createTree(root);
        return new TreeNode[]{root};
    }

    protected void createTree(TreeNodeExt node) {
        TreeNodeExt newNode;
        List children;
        Object obj = node.getValue();
        if (obj instanceof EditPart) {
            EditPart editPart = (EditPart)obj;
            children = editPart.getChildren();
            for (Object child : children) {
                newNode = new TreeNodeExt(child);
                this.createTree(newNode);
                node.addChild(newNode);
            }
            if (editPart instanceof GraphicalEditPart) {
                IFigure figure = ((GraphicalEditPart)editPart).getFigure();
                TreeNodeExt newNode2 = new TreeNodeExt(figure);
                this.createTree(newNode2);
                node.addChild(newNode2);
            }
        }
        if (obj instanceof IFigure) {
            IFigure figure = (IFigure)obj;
            children = figure.getChildren();
            for (Object child : children) {
                newNode = new TreeNodeExt(child);
                this.createTree(newNode);
                node.addChild(newNode);
            }
        }
    }

    private void hookRefreshAction() {
        Action refreshAction = new Action(){

            public void run() {
                GEFSpyView.this.refresh(GEFSpyView.this.treeViewer);
            }
        };
        refreshAction.setText("Refresh");
        refreshAction.setToolTipText("Refresh");
        refreshAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ELCL_SYNCED"));
        IActionBars bars = this.getViewSite().getActionBars();
        bars.getToolBarManager().add((IAction)refreshAction);
        bars.getToolBarManager().add((IContributionItem)new Separator());
    }

    private void hookSelectAction() {
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object treeObject;
                ISelection selection = event.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (obj instanceof TreeNode && (treeObject = ((TreeNode)obj).getValue()) instanceof EditPart && ((EditPart)treeObject).isSelectable()) {
                    EditPartHandler.getInstance().select((EditPart)treeObject);
                }
            }
        });
    }

    public void setFocus() {
    }
}

