/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.editors;

import java.util.ResourceBundle;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewerExtension6;
import org.eclipse.jface.text.IUndoManagerExtension;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.ui.actions.GotoScriptLineAction;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.operations.RedoActionHandler;
import org.eclipse.ui.operations.UndoActionHandler;
import org.eclipse.ui.texteditor.FindReplaceAction;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.ResourceAction;

public class TextViewerActionsSupport
implements FocusListener,
DisposeListener {
    private final TextViewer textViewer;
    private final IWorkbenchPartSite partSite;
    private final Shell shell;
    private final IObservableValue editable;
    private final DataBindingContext dbc = new DataBindingContext();
    private static final String CutLabel = Messages.TextViewerActionsSupport_CutLabel;
    private static final String CopyLabel = Messages.TextViewerActionsSupport_CopyLabel;
    private static final String PasteLabel = Messages.TextViewerActionsSupport_PasteLabel;
    private static final String DeleteLabel = Messages.TextViewerActionsSupport_DeleteLabel;
    private static final String SelectAllLabel = Messages.TextViewerActionsSupport_SelectAllLabel;
    static final String BUNDLE_FOR_CONSTRUCTED_KEYS = "org.eclipse.ui.texteditor.ConstructedEditorMessages";
    private Action undoAction;
    private Action redoAction;
    private Action cutAction;
    private Action copyAction;
    private Action pasteAction;
    private Action deleteAction;
    private Action selectAllAction;
    private ResourceAction findAction;
    private Action contentAssistAction;
    private Action gotoLineAction;

    public TextViewerActionsSupport(TextViewer textViewer, IWorkbenchPartSite partSite, IObservableValue editable) {
        this.textViewer = textViewer;
        this.partSite = partSite;
        this.shell = partSite.getShell();
        this.editable = editable;
        this.init();
    }

    public TextViewerActionsSupport(TextViewer textViewer, Shell shell, IObservableValue editable) {
        this.textViewer = textViewer;
        this.partSite = null;
        this.shell = shell;
        this.editable = editable;
        this.init();
    }

    private void init() {
        this.addListeners();
        this.createActions();
        if (this.partSite == null) {
            this.setAcceleratorLabel();
        } else if (this.getTextWidget() != null && this.getTextWidget().isFocusControl()) {
            this.activateActions();
        }
        this.updateEditActionsEnablement();
        this.editable.addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                TextViewerActionsSupport.this.updateEditActionsEnablement();
            }
        });
        this.createPopupMenu();
    }

    public Action getUndoAction() {
        return this.undoAction;
    }

    public Action getRedoAction() {
        return this.redoAction;
    }

    public Action getCutAction() {
        return this.cutAction;
    }

    public Action getCopyAction() {
        return this.copyAction;
    }

    public Action getPasteAction() {
        return this.pasteAction;
    }

    public Action getDeleteAction() {
        return this.deleteAction;
    }

    public Action getSelectAllAction() {
        return this.selectAllAction;
    }

    public ResourceAction getFindAction() {
        return this.findAction;
    }

    public Action getContentAssistAction() {
        return this.contentAssistAction;
    }

    public Action getGotoLineAction() {
        return this.gotoLineAction;
    }

    private void addListeners() {
        if (this.getTextWidget() != null) {
            if (this.partSite != null) {
                this.getTextWidget().addFocusListener((FocusListener)this);
                this.getTextWidget().addDisposeListener((DisposeListener)this);
            } else {
                this.getTextWidget().addKeyListener((KeyListener)new KeyAdapter(){

                    public void keyPressed(KeyEvent event) {
                        try {
                            TextViewerActionsSupport.this.processKeyDown(event);
                        }
                        catch (ParseException e) {
                            Q7UIPlugin.log(e);
                        }
                    }
                });
            }
        }
        this.textViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TextViewerActionsSupport.this.updateEditActionsEnablement();
            }
        });
    }

    private void processKeyDown(KeyEvent e) throws ParseException {
        KeyStroke pressed = KeyStroke.getInstance((int)e.stateMask, (int)Character.toUpperCase(e.keyCode));
        if (pressed.equals((Object)KeyStroke.getInstance((String)"M1+Z"))) {
            this.undoAction.run();
        } else if (pressed.equals((Object)KeyStroke.getInstance((String)"M1+Y"))) {
            this.redoAction.run();
        } else if (pressed.equals((Object)KeyStroke.getInstance((String)"M1+A"))) {
            this.selectAllAction.run();
        } else if (pressed.equals((Object)KeyStroke.getInstance((String)"M1+F"))) {
            this.findAction.run();
        } else if (pressed.equals((Object)KeyStroke.getInstance((String)"Ctrl+Space"))) {
            this.contentAssistAction.run();
        } else if (this.gotoLineAction != null && pressed.equals((Object)KeyStroke.getInstance((String)"M1+L"))) {
            this.gotoLineAction.run();
        }
    }

    private void createPopupMenu() {
        if (this.getTextWidget() != null) {
            MenuManager popupMenuManager = new MenuManager();
            IMenuListener listener = new IMenuListener(){

                public void menuAboutToShow(IMenuManager mng) {
                    TextViewerActionsSupport.this.fillContextMenu(mng);
                }
            };
            popupMenuManager.addMenuListener(listener);
            popupMenuManager.setRemoveAllWhenShown(true);
            Menu menu = popupMenuManager.createContextMenu(this.textViewer.getControl());
            this.getTextWidget().setMenu(menu);
        }
    }

    private void fillContextMenu(IMenuManager menuManager) {
        if (this.undoAction != null) {
            menuManager.add((IAction)this.undoAction);
        }
        if (this.redoAction != null) {
            menuManager.add((IAction)this.redoAction);
        }
        if (this.undoAction != null || this.redoAction != null) {
            menuManager.add((IContributionItem)new Separator());
        }
        menuManager.add((IAction)this.cutAction);
        menuManager.add((IAction)this.copyAction);
        menuManager.add((IAction)this.pasteAction);
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.deleteAction);
        menuManager.add((IAction)this.selectAllAction);
    }

    private void updateEditActionsEnablement() {
        ITextSelection selection = (ITextSelection)this.textViewer.getSelection();
        boolean hasSelectedText = !selection.isEmpty() && selection.getLength() > 0;
        boolean isEditable = (Boolean)this.editable.getValue();
        this.cutAction.setEnabled(isEditable && hasSelectedText);
        this.copyAction.setEnabled(hasSelectedText);
        this.pasteAction.setEnabled(isEditable);
        this.deleteAction.setEnabled(isEditable && hasSelectedText);
        if (this.findAction != null) {
            this.findAction.setEnabled(true);
        }
    }

    private void createActions() {
        this.createUndoRedoActions();
        this.createCommonTextAction();
        this.createAdditionalAction();
    }

    private void createUndoRedoActions() {
        IUndoContext undoContext;
        if (this.textViewer instanceof ITextViewerExtension6 && this.textViewer.getUndoManager() instanceof IUndoManagerExtension && (undoContext = ((IUndoManagerExtension)this.textViewer.getUndoManager()).getUndoContext()) != null) {
            if (this.partSite != null) {
                this.undoAction = new UndoActionHandler(this.partSite, undoContext);
                this.redoAction = new RedoActionHandler(this.partSite, undoContext);
            } else {
                this.undoAction = new CustomUndoAction(undoContext);
                this.redoAction = new CustomRedoAction(undoContext);
            }
            this.undoAction.setActionDefinitionId("org.eclipse.ui.edit.undo");
            this.redoAction.setActionDefinitionId("org.eclipse.ui.edit.redo");
            this.textViewer.getUndoManager().reset();
        }
    }

    private void createCommonTextAction() {
        this.cutAction = new Action(CutLabel){

            public void run() {
                if (TextViewerActionsSupport.this.textViewer.canDoOperation(3)) {
                    TextViewerActionsSupport.this.textViewer.doOperation(3);
                }
            }
        };
        this.cutAction.setActionDefinitionId("org.eclipse.ui.edit.cut");
        this.cutAction.setImageDescriptor(this.getImageDescriptor("IMG_TOOL_CUT"));
        this.cutAction.setDisabledImageDescriptor(this.getImageDescriptor("IMG_TOOL_CUT_DISABLED"));
        this.copyAction = new Action(CopyLabel){

            public void run() {
                if (TextViewerActionsSupport.this.textViewer.canDoOperation(4)) {
                    TextViewerActionsSupport.this.textViewer.doOperation(4);
                }
            }
        };
        this.copyAction.setActionDefinitionId("org.eclipse.ui.edit.copy");
        this.copyAction.setImageDescriptor(this.getImageDescriptor("IMG_TOOL_COPY"));
        this.copyAction.setDisabledImageDescriptor(this.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        this.pasteAction = new Action(PasteLabel){

            public void run() {
                if (TextViewerActionsSupport.this.textViewer.canDoOperation(5)) {
                    TextViewerActionsSupport.this.textViewer.doOperation(5);
                }
            }
        };
        this.pasteAction.setActionDefinitionId("org.eclipse.ui.edit.paste");
        this.pasteAction.setImageDescriptor(this.getImageDescriptor("IMG_TOOL_PASTE"));
        this.pasteAction.setDisabledImageDescriptor(this.getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
        this.deleteAction = new Action(DeleteLabel){

            public void run() {
                if (TextViewerActionsSupport.this.textViewer.canDoOperation(6)) {
                    TextViewerActionsSupport.this.textViewer.doOperation(6);
                }
            }
        };
        this.deleteAction.setActionDefinitionId("org.eclipse.ui.edit.delete");
        this.deleteAction.setImageDescriptor(this.getImageDescriptor("IMG_TOOL_DELETE"));
        this.deleteAction.setDisabledImageDescriptor(this.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.selectAllAction = new Action(SelectAllLabel){

            public void run() {
                if (TextViewerActionsSupport.this.textViewer.canDoOperation(7)) {
                    TextViewerActionsSupport.this.textViewer.doOperation(7);
                }
            }
        };
        this.selectAllAction.setActionDefinitionId("org.eclipse.ui.edit.selectAll");
    }

    private void createAdditionalAction() {
        if (this.shell != null) {
            ResourceBundle fgBundleForConstructedKeys = ResourceBundle.getBundle(BUNDLE_FOR_CONSTRUCTED_KEYS);
            this.findAction = new FindReplaceAction(fgBundleForConstructedKeys, "Editor.FindReplace.", this.shell, this.textViewer.getFindReplaceTarget());
            this.findAction.setActionDefinitionId("org.eclipse.ui.edit.findReplace");
        }
        this.contentAssistAction = new Action(){

            public void run() {
                if (TextViewerActionsSupport.this.textViewer.isEditable() && TextViewerActionsSupport.this.textViewer.getTextWidget().isFocusControl()) {
                    Display display = Display.getCurrent();
                    BusyIndicator.showWhile((Display)display, (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            TextViewerActionsSupport.this.textViewer.doOperation(13);
                        }
                    });
                }
            }
        };
        this.contentAssistAction.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        if (this.partSite == null && this.textViewer.getDocument() != null) {
            this.gotoLineAction = new GotoScriptLineAction(this.textViewer);
            this.gotoLineAction.setActionDefinitionId("org.eclipse.ui.edit.text.goto.line");
        }
    }

    private void setAcceleratorLabel() {
        if (this.undoAction != null) {
            this.undoAction.setAccelerator(this.KeyCodeAcceleratorFormat("M1+Z"));
        }
        if (this.redoAction != null) {
            this.redoAction.setAccelerator(this.KeyCodeAcceleratorFormat("M1+Y"));
        }
        this.cutAction.setAccelerator(this.KeyCodeAcceleratorFormat("M1+X"));
        this.copyAction.setAccelerator(this.KeyCodeAcceleratorFormat("M1+C"));
        this.pasteAction.setAccelerator(this.KeyCodeAcceleratorFormat("M1+V"));
        this.deleteAction.setAccelerator(this.KeyCodeAcceleratorFormat("DELETE"));
        this.selectAllAction.setAccelerator(this.KeyCodeAcceleratorFormat("M1+A"));
        if (this.gotoLineAction != null) {
            this.gotoLineAction.setAccelerator(this.KeyCodeAcceleratorFormat("M1+L"));
        }
    }

    private int KeyCodeAcceleratorFormat(String shortcut) {
        try {
            return KeyStroke.getInstance((String)shortcut).getModifierKeys() | KeyStroke.getInstance((String)shortcut).getNaturalKey();
        }
        catch (ParseException parseException) {
            return 0;
        }
    }

    private void activateActions() {
        IActionBars actionBars = this.getActionBars();
        if (actionBars != null) {
            actionBars.setGlobalActionHandler(ITextEditorActionConstants.UNDO, (IAction)this.undoAction);
            actionBars.setGlobalActionHandler(ITextEditorActionConstants.REDO, (IAction)this.redoAction);
            actionBars.setGlobalActionHandler(ITextEditorActionConstants.CUT, (IAction)this.cutAction);
            actionBars.setGlobalActionHandler(ITextEditorActionConstants.COPY, (IAction)this.copyAction);
            actionBars.setGlobalActionHandler(ITextEditorActionConstants.PASTE, (IAction)this.pasteAction);
            actionBars.setGlobalActionHandler(ITextEditorActionConstants.DELETE, (IAction)this.deleteAction);
            actionBars.setGlobalActionHandler(ITextEditorActionConstants.SELECT_ALL, (IAction)this.selectAllAction);
            actionBars.setGlobalActionHandler(ITextEditorActionConstants.FIND, (IAction)this.findAction);
            actionBars.setGlobalActionHandler("ContentAssistProposal", (IAction)this.contentAssistAction);
            actionBars.updateActionBars();
        }
    }

    private void deactivateActions() {
        IActionBars actionBars = this.getActionBars();
        if (actionBars != null) {
            actionBars.setGlobalActionHandler(ITextEditorActionConstants.UNDO, null);
            actionBars.setGlobalActionHandler(ITextEditorActionConstants.REDO, null);
            actionBars.setGlobalActionHandler(ITextEditorActionConstants.CUT, null);
            actionBars.setGlobalActionHandler(ITextEditorActionConstants.COPY, null);
            actionBars.setGlobalActionHandler(ITextEditorActionConstants.PASTE, null);
            actionBars.setGlobalActionHandler(ITextEditorActionConstants.DELETE, null);
            actionBars.setGlobalActionHandler(ITextEditorActionConstants.SELECT_ALL, null);
            actionBars.setGlobalActionHandler(ITextEditorActionConstants.FIND, null);
            actionBars.setGlobalActionHandler("ContentAssistProposal", null);
            actionBars.updateActionBars();
        }
    }

    public void widgetDisposed(DisposeEvent e) {
        this.deactivateActions();
    }

    public void focusGained(FocusEvent e) {
        this.activateActions();
    }

    public void focusLost(FocusEvent e) {
        this.deactivateActions();
    }

    private ImageDescriptor getImageDescriptor(String imageId) {
        return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(imageId);
    }

    private StyledText getTextWidget() {
        return this.textViewer.getTextWidget();
    }

    private IActionBars getActionBars() {
        if (this.partSite instanceof IEditorSite) {
            return ((IEditorSite)this.partSite).getActionBars();
        }
        if (this.partSite instanceof IViewSite) {
            return ((IViewSite)this.partSite).getActionBars();
        }
        return null;
    }

    private abstract class CustomOperationAction
    extends Action {
        private IUndoContext undoContext;

        CustomOperationAction(IUndoContext context) {
            super("");
            this.undoContext = null;
            this.undoContext = context;
            this.AddHistoryListener();
            this.updateEnablement();
        }

        private void AddHistoryListener() {
            this.getHistory().addOperationHistoryListener(new IOperationHistoryListener(){

                public void historyNotification(OperationHistoryEvent event) {
                    if (event.getOperation().hasContext(CustomOperationAction.this.undoContext)) {
                        CustomOperationAction.this.updateEnablement();
                    }
                }
            });
        }

        protected abstract void updateEnablement();

        IOperationHistory getHistory() {
            return PlatformUI.getWorkbench().getOperationSupport().getOperationHistory();
        }

        final IUndoContext getUndoContext() {
            return this.undoContext;
        }
    }

    private class CustomRedoAction
    extends CustomOperationAction {
        CustomRedoAction(IUndoContext context) {
            super(context);
            this.setText(Messages.TextViewerActionsSupport_RedoLabel);
            this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_REDO"));
            this.setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_REDO_DISABLED"));
        }

        public final void run() {
            if (this.isEnabled()) {
                try {
                    this.getHistory().redo(this.getUndoContext(), null, null);
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
            }
        }

        @Override
        protected void updateEnablement() {
            this.setEnabled(this.getHistory().canRedo(this.getUndoContext()));
        }
    }

    private class CustomUndoAction
    extends CustomOperationAction {
        CustomUndoAction(IUndoContext context) {
            super(context);
            this.setText(Messages.TextViewerActionsSupport_UndoLabel);
            this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_UNDO"));
            this.setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_UNDO_DISABLED"));
        }

        public final void run() {
            if (this.isEnabled()) {
                try {
                    this.getHistory().undo(this.getUndoContext(), null, null);
                }
                catch (ExecutionException e) {
                    Q7UIPlugin.log(e);
                }
            }
        }

        @Override
        protected void updateEnablement() {
            this.setEnabled(this.getHistory().canUndo(this.getUndoContext()));
        }
    }
}

