/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.preferences;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.rcptt.internal.preferences.Activator;
import org.eclipse.rcptt.preferences.PrefData;
import org.eclipse.rcptt.preferences.PrefNode;
import org.eclipse.rcptt.preferences.PreferencesFactory;
import org.eclipse.rcptt.preferences.StringPrefData;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public final class PrefUtils {
    private static final SubstitutionHelper helper = PrefUtils.resolveHelper();

    private PrefUtils() {
    }

    public static void remove(EObject object) {
        EReference ref = object.eContainmentFeature();
        List list = (List)object.eContainer().eGet((EStructuralFeature)ref);
        list.remove(object);
    }

    public static PrefNode convertPreferences(Preferences preferences) throws BackingStoreException {
        return PrefUtils.doConvertPreferences(preferences);
    }

    public static void encodePrefData(StringPrefData prefData) {
        String nullSymbol;
        String value = prefData.getValue();
        if (value.contains(nullSymbol = Character.toString('\u0000'))) {
            value = value.replace(nullSymbol, "\\u0000");
            prefData.setValue(value);
        }
    }

    public static void encodeWorkspaceLocation(StringPrefData prefData) {
        prefData.setValue(PrefUtils.encodeWorkspaceLocation(prefData.getValue()));
    }

    public static String encodeWorkspaceLocation(String value) {
        if (value == null) {
            return null;
        }
        try {
            File location = ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile();
            String absolutePath = location.getAbsolutePath();
            String canonicalPath = location.getCanonicalPath();
            String absolutePathSlash = absolutePath.replace('\\', '/');
            String canonicalPathSlash = canonicalPath.replace('\\', '/');
            if (value.contains(absolutePath)) {
                value = value.replace(absolutePath, "${workspace_loc}");
            }
            if (value.contains(canonicalPath)) {
                value = value.replace(canonicalPath, "${workspace_loc}");
            }
            if (value.contains(absolutePathSlash)) {
                value = value.replace(absolutePathSlash, "${workspace_loc}");
            }
            if (value.contains(canonicalPathSlash)) {
                value = value.replace(canonicalPathSlash, "${workspace_loc}");
            }
        }
        catch (Throwable throwable) {}
        return value;
    }

    public static void decodeWorkspaceLocation(StringPrefData prefData) {
        prefData.setValue(PrefUtils.decodeWorkspaceLocation(prefData.getValue()));
    }

    public static String decodeWorkspaceLocation(String value) {
        if (value == null) {
            return null;
        }
        try {
            File location = ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile();
            String canonicalPath = location.getCanonicalPath();
            if (value.contains("${workspace_loc}")) {
                value = value.replace("${workspace_loc}", canonicalPath);
            }
        }
        catch (Throwable throwable) {}
        return value;
    }

    public static void decodePrefData(StringPrefData prefData) {
        String value = prefData.getValue();
        if (value.contains("\\u0000")) {
            value = value.replace("\\u0000", Character.toString('\u0000'));
            prefData.setValue(value);
        }
    }

    public static void substituteVariables(StringPrefData prefData) {
        String key = PrefUtils.substituteVariables(prefData.getKey());
        prefData.setKey(key);
        String value = PrefUtils.substituteVariables(prefData.getValue());
        prefData.setValue(value);
    }

    public static String substituteVariables(String string) {
        return helper.substituteVariables(string);
    }

    private static PrefNode doConvertPreferences(Preferences preferences) throws BackingStoreException {
        List<PrefNode> childPrefNodes = PrefUtils.doConvertChildPreferences(preferences);
        List<PrefData> prefDatas = PrefUtils.collectPrefData(preferences);
        if (childPrefNodes.size() > 0 || prefDatas.size() > 0) {
            PrefNode prefNode = PreferencesFactory.eINSTANCE.createPrefNode();
            prefNode.setName(preferences.name());
            prefNode.getChilds().addAll(childPrefNodes);
            prefNode.getData().addAll(prefDatas);
            return prefNode;
        }
        return null;
    }

    private static List<PrefData> collectPrefData(Preferences preferences) throws BackingStoreException {
        String[] keys;
        ArrayList<PrefData> result = new ArrayList<PrefData>();
        String[] stringArray = keys = preferences.keys();
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            String value = preferences.get(key, null);
            if (value != null) {
                StringPrefData prefData = PreferencesFactory.eINSTANCE.createStringPrefData();
                prefData.setKey(key);
                prefData.setValue(value);
                PrefUtils.encodeWorkspaceLocation(prefData);
                PrefUtils.encodePrefData(prefData);
                result.add(prefData);
            }
            ++n2;
        }
        return result;
    }

    private static List<PrefNode> doConvertChildPreferences(Preferences preferences) throws BackingStoreException {
        String[] childrenNames;
        ArrayList<PrefNode> prefNodes = new ArrayList<PrefNode>();
        String[] stringArray = childrenNames = preferences.childrenNames();
        int n = childrenNames.length;
        int n2 = 0;
        while (n2 < n) {
            String childrenName = stringArray[n2];
            Preferences childPreferences = preferences.node(childrenName);
            PrefNode prefNode = PrefUtils.doConvertPreferences(childPreferences);
            if (prefNode != null) {
                prefNodes.add(prefNode);
            }
            ++n2;
        }
        return prefNodes;
    }

    private static SubstitutionHelper resolveHelper() {
        try {
            VariablesPlugin.getDefault();
            return new SubstitutionHelper(){

                @Override
                public String substituteVariables(String input) {
                    try {
                        return VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(input, true);
                    }
                    catch (CoreException e) {
                        Activator.log(e);
                        return input;
                    }
                }
            };
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return new SubstitutionHelper(){

                @Override
                public String substituteVariables(String input) {
                    return input;
                }
            };
        }
    }

    private static interface SubstitutionHelper {
        public String substituteVariables(String var1);
    }
}

