/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.treeitemkit;

import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.internal.lifecycle.ProcessActionRunner;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.internal.protocol.WidgetOperationHandler;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class TreeItemOperationHandler
extends WidgetOperationHandler<TreeItem> {
    private static final String PROP_CHECKED = "checked";
    private static final String PROP_EXPANDED = "expanded";

    public TreeItemOperationHandler(TreeItem item) {
        super(item);
    }

    @Override
    public void handleSet(TreeItem item, JsonObject properties) {
        this.handleSetChecked(item, properties);
        this.handleSetExpanded(item, properties);
    }

    public void handleSetChecked(TreeItem item, JsonObject properties) {
        JsonValue checked = properties.get(PROP_CHECKED);
        if (checked != null) {
            item.setChecked(checked.asBoolean());
        }
    }

    public void handleSetExpanded(final TreeItem item, JsonObject properties) {
        final JsonValue expanded = properties.get(PROP_EXPANDED);
        if (expanded != null) {
            ProcessActionRunner.add(new Runnable(){

                @Override
                public void run() {
                    item.setExpanded(expanded.asBoolean());
                    WidgetLCAUtil.preserveProperty((Widget)item, TreeItemOperationHandler.PROP_EXPANDED, item.getExpanded());
                }
            });
        }
    }
}

