/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.tabfolderkit;

import org.eclipse.rap.rwt.internal.theme.WidgetMatcher;
import org.eclipse.rap.rwt.theme.BoxDimensions;
import org.eclipse.swt.internal.widgets.controlkit.ControlThemeAdapterImpl;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Widget;

public class TabFolderThemeAdapter
extends ControlThemeAdapterImpl {
    @Override
    protected void configureMatcher(WidgetMatcher matcher) {
        super.configureMatcher(matcher);
        matcher.addState("bottom", TabFolderThemeAdapter.createItemOnBottomMatcher());
        matcher.addState("selected", TabFolderThemeAdapter.createSelectedItemMatcher());
        matcher.addState("first", TabFolderThemeAdapter.createFirstItemMatcher());
        matcher.addState("last", TabFolderThemeAdapter.createLastItemMatcher());
    }

    public BoxDimensions getContentContainerBorder(TabFolder folder) {
        return this.getCssBorder("TabFolder-ContentContainer", folder);
    }

    public BoxDimensions getItemBorder(TabItem item) {
        return this.getCssBorder("TabItem", item);
    }

    public BoxDimensions getItemPadding(TabItem item) {
        return this.getCssBoxDimensions((String)"TabItem", (String)"padding", (Widget)item).dimensions;
    }

    public BoxDimensions getItemMargin(TabItem item) {
        return this.getCssBoxDimensions((String)"TabItem", (String)"margin", (Widget)item).dimensions;
    }

    private static WidgetMatcher.Constraint createItemOnBottomMatcher() {
        return new WidgetMatcher.Constraint(){

            @Override
            public boolean matches(Widget widget) {
                if (widget instanceof TabItem) {
                    TabItem item = (TabItem)widget;
                    return (item.getParent().getStyle() & 0x400) != 0;
                }
                return false;
            }
        };
    }

    private static WidgetMatcher.Constraint createSelectedItemMatcher() {
        return new WidgetMatcher.Constraint(){

            @Override
            public boolean matches(Widget widget) {
                if (widget instanceof TabItem) {
                    TabItem item = (TabItem)widget;
                    TabItem[] selection = item.getParent().getSelection();
                    return selection.length > 0 && selection[0] == item;
                }
                return false;
            }
        };
    }

    private static WidgetMatcher.Constraint createFirstItemMatcher() {
        return new WidgetMatcher.Constraint(){

            @Override
            public boolean matches(Widget widget) {
                if (widget instanceof TabItem) {
                    TabItem item = (TabItem)widget;
                    TabFolder folder = item.getParent();
                    return folder.getItem(0) == item;
                }
                return false;
            }
        };
    }

    private static WidgetMatcher.Constraint createLastItemMatcher() {
        return new WidgetMatcher.Constraint(){

            @Override
            public boolean matches(Widget widget) {
                if (widget instanceof TabItem) {
                    TabItem item = (TabItem)widget;
                    TabFolder folder = item.getParent();
                    return folder.getItem(folder.getItemCount() - 1) == item;
                }
                return false;
            }
        };
    }
}

